/*
 * Copyright 2016 czy1121
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ezy.boost.update;


import android.content.Context;
import android.util.SparseIntArray;

public class UpdateError extends Throwable {

    public static final int UPDATE_IGNORED = 1001;
    public static final int UPDATE_NO_NEWER = 1002;
    public static final int CHECK_UNKNOWN = 2001;
    public static final int CHECK_NO_WIFI = 2002;
    public static final int CHECK_NO_NETWORK = 2003;
    public static final int CHECK_NETWORK_IO = 2004;
    public static final int CHECK_HTTP_STATUS = 2005;
    public static final int CHECK_PARSE = 2006;
    public static final int DOWNLOAD_UNKNOWN = 3001;
    public static final int DOWNLOAD_CANCELLED = 3002;
    public static final int DOWNLOAD_DISK_NO_SPACE = 3003;
    public static final int DOWNLOAD_DISK_IO = 3004;
    public static final int DOWNLOAD_NETWORK_IO = 3005;
    public static final int DOWNLOAD_NETWORK_BLOCKED = 3006;
    public static final int DOWNLOAD_NETWORK_TIMEOUT = 3007;
    public static final int DOWNLOAD_HTTP_STATUS = 3008;
    public static final int DOWNLOAD_INCOMPLETE = 3009;
    public static final int DOWNLOAD_VERIFY = 3010;
    public static final SparseIntArray messages = new SparseIntArray();

    static {
        messages.append(UPDATE_IGNORED, R.string.update_gaibanbenyijinghulve);
        messages.append(UPDATE_NO_NEWER, R.string.update_yijingshizuixinbanle);

        messages.append(CHECK_UNKNOWN, R.string.update_chaxungengxinshibai_weizhicuowu);
        messages.append(CHECK_NO_WIFI, R.string.update_chaxungengxinshibai_meiyou_wifi);
        messages.append(CHECK_NO_NETWORK, R.string.update_chaxungengxinshibai_meiyouwangluo);
        messages.append(CHECK_NETWORK_IO, R.string.update_chaxungengxinshibai_wangluoyichang);
        messages.append(CHECK_HTTP_STATUS, R.string.update_chaxungengxinshibai_cuowudehttpzhuangtai);
        messages.append(CHECK_PARSE, R.string.update_chaxungengxinshibai_jiexicuowu);

        messages.append(DOWNLOAD_UNKNOWN, R.string.update_xiazaishibai_weizhicuowu);
        messages.append(DOWNLOAD_CANCELLED, R.string.update_xiazaishibai_xiazaibeiquxiao);
        messages.append(DOWNLOAD_DISK_NO_SPACE, R.string.update_xiazaishibai_cipankongjianbuzu);
        messages.append(DOWNLOAD_DISK_IO, R.string.update_xiazaishibai_cipanduxiecuowu);
        messages.append(DOWNLOAD_NETWORK_IO, R.string.update_xiazaishibai_wangluoyichang);
        messages.append(DOWNLOAD_NETWORK_BLOCKED, R.string.update_xiazaishibai_wangluozhongduan);
        messages.append(DOWNLOAD_NETWORK_TIMEOUT, R.string.update_xiazaishibai_wangluochaoshi);
        messages.append(DOWNLOAD_HTTP_STATUS, R.string.update_xiazaishibai_cuowudehttpzhuangtai);
        messages.append(DOWNLOAD_INCOMPLETE, R.string.update_xiazaishibai_xiazaibuwanzheng);
        messages.append(DOWNLOAD_VERIFY, R.string.update_xiazaishibai_xiaoyancuowu);
    }

    public final int code;
    public UpdateError(Context context, int code) {
        this(context, code, null);
    }
    public UpdateError(Context context, int code, String message) {
        super(make(context, code, message));
        this.code = code;
    }

    private static String make(Context context, int code, String message) {
        int mRes = messages.get(code);
        String m = null;
        try {
            m = context.getString(mRes);
        } catch (Exception ignored) {
        }
        if (m == null) {
            return message;
        }
        if (message == null) {
            return m;
        }
        return m + "(" + message + ")";
    }

    public boolean isError() {
        return code >= 2000;
    }

    @Override
    public String toString() {
        if (isError()) {
            return "[" + code + "]" + getMessage();
        }
        return getMessage();
    }
}
