/*
 * Decompiled with CFR 0.152.
 */
package ezy.boost.update;

import android.app.Activity;
import android.app.NotificationManager;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.AsyncTask;
import android.os.Environment;
import android.text.method.MovementMethod;
import android.text.method.ScrollingMovementMethod;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AlertDialog;
import androidx.core.app.NotificationCompat;
import ezy.boost.update.DefaultDownloadListener;
import ezy.boost.update.DefaultPromptClickListener;
import ezy.boost.update.ICheckAgent;
import ezy.boost.update.IDownloadAgent;
import ezy.boost.update.IUpdateAgent;
import ezy.boost.update.IUpdateChecker;
import ezy.boost.update.IUpdateDownloader;
import ezy.boost.update.IUpdateParser;
import ezy.boost.update.IUpdatePrompter;
import ezy.boost.update.OnDownloadListener;
import ezy.boost.update.OnFailureListener;
import ezy.boost.update.R;
import ezy.boost.update.UpdateChecker;
import ezy.boost.update.UpdateDownloader2;
import ezy.boost.update.UpdateError;
import ezy.boost.update.UpdateInfo;
import ezy.boost.update.UpdateUtil;
import java.io.File;

class UpdateAgent
implements ICheckAgent,
IUpdateAgent,
IDownloadAgent {
    private static final String TAG = "UpdateAgent";
    private Context mContext;
    private String mUrl;
    private File mApkFile;
    private boolean mIsManual = false;
    private boolean mIsWifiOnly = false;
    private UpdateInfo mInfo;
    private UpdateError mError = null;
    private IUpdateParser mParser = new DefaultUpdateParser();
    private IUpdateChecker mChecker;
    private IUpdateDownloader mDownloader;
    private IUpdatePrompter mPrompter;
    private OnFailureListener mOnFailureListener;
    private OnDownloadListener mOnDownloadListener;
    private OnDownloadListener mOnNotificationDownloadListener;

    public UpdateAgent(Context context, String url, boolean isManual, boolean isWifiOnly, int notifyId) {
        this.mContext = context.getApplicationContext();
        this.mUrl = url;
        this.mIsManual = isManual;
        this.mIsWifiOnly = isWifiOnly;
        this.mDownloader = new DefaultUpdateDownloader(this.mContext);
        this.mPrompter = new DefaultUpdatePrompter(context);
        this.mOnFailureListener = new DefaultFailureListener(context);
        this.mOnDownloadListener = new DefaultDialogDownloadListener(context);
        this.mOnNotificationDownloadListener = notifyId > 0 ? new DefaultNotificationDownloadListener(this.mContext, notifyId) : new DefaultDownloadListener();
    }

    public void setParser(IUpdateParser parser) {
        this.mParser = parser;
    }

    public void setChecker(IUpdateChecker checker) {
        this.mChecker = checker;
    }

    public void setDownloader(IUpdateDownloader downloader) {
        this.mDownloader = downloader;
    }

    public void setPrompter(IUpdatePrompter prompter) {
        this.mPrompter = prompter;
    }

    public void setOnNotificationDownloadListener(OnDownloadListener listener) {
        this.mOnNotificationDownloadListener = listener;
    }

    public void setOnDownloadListener(OnDownloadListener listener) {
        this.mOnDownloadListener = listener;
    }

    public void setOnFailureListener(OnFailureListener listener) {
        this.mOnFailureListener = listener;
    }

    @Override
    public UpdateInfo getInfo() {
        return this.mInfo;
    }

    public void setInfo(UpdateInfo info) {
        this.mInfo = info;
    }

    @Override
    public void setInfo(String source) {
        try {
            this.mInfo = this.mParser.parse(source);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setError(new UpdateError(this.mContext, 2006));
        }
    }

    @Override
    public void setError(UpdateError error) {
        this.mError = error;
    }

    @Override
    public Context getApplicationContext() {
        return this.mContext;
    }

    @Override
    public void update() {
        this.mApkFile = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS), this.mInfo.md5 + ".apk");
        if (UpdateUtil.verify(this.mApkFile, this.mInfo.md5, true)) {
            Log.i((String)TAG, (String)"update: update install ============");
            this.doInstall();
        } else {
            this.doDownload();
        }
    }

    @Override
    public void ignore() {
        UpdateUtil.setIgnore(this.mContext, this.getInfo().md5);
    }

    @Override
    public void onStart() {
        if (this.mInfo.isSilent) {
            this.mOnNotificationDownloadListener.onStart();
        } else {
            this.mOnDownloadListener.onStart();
        }
    }

    @Override
    public void onProgress(int progress) {
        if (this.mInfo.isSilent) {
            this.mOnNotificationDownloadListener.onProgress(progress);
        } else {
            this.mOnDownloadListener.onProgress(progress);
        }
    }

    @Override
    public void onFinish() {
        if (this.mInfo.isSilent) {
            this.mOnNotificationDownloadListener.onFinish();
        } else {
            this.mOnDownloadListener.onFinish();
        }
        if (this.mError != null) {
            this.mOnFailureListener.onFailure(this.mError);
        } else if (this.mInfo.isAutoInstall) {
            if (UpdateUtil.verify(this.mApkFile, this.mInfo.md5, true)) {
                Log.i((String)TAG, (String)"onFinish: start install page ========");
                this.doInstall();
            } else {
                this.doPrompt();
                if (this.mApkFile != null && this.mApkFile.exists()) {
                    this.mApkFile.delete();
                }
                Toast.makeText((Context)this.mContext, (CharSequence)this.mContext.getString(R.string.update_agent_apk_error), (int)1).show();
            }
        }
    }

    public void check() {
        UpdateUtil.log("check");
        if (this.mIsWifiOnly) {
            if (UpdateUtil.checkWifi(this.mContext)) {
                this.doCheck();
            } else {
                this.doFailure(new UpdateError(this.mContext, 2002));
            }
        } else if (UpdateUtil.checkNetwork(this.mContext)) {
            this.doCheck();
        } else {
            this.doFailure(new UpdateError(this.mContext, 2003));
        }
    }

    void doCheck() {
        new AsyncTask<String, Void, Void>(){

            protected Void doInBackground(String ... params) {
                if (UpdateAgent.this.mChecker == null) {
                    UpdateAgent.this.mChecker = new UpdateChecker();
                }
                UpdateAgent.this.mChecker.check(UpdateAgent.this, UpdateAgent.this.mUrl);
                return null;
            }

            protected void onPostExecute(Void aVoid) {
                UpdateAgent.this.doCheckFinish();
            }
        }.execute((Object[])new String[0]);
    }

    void doCheckFinish() {
        UpdateUtil.log("check finish");
        UpdateError error = this.mError;
        if (error != null) {
            this.doFailure(error);
        } else {
            UpdateInfo info = this.getInfo();
            if (info == null) {
                this.doFailure(new UpdateError(this.mContext, 2001));
            } else if (!info.hasUpdate) {
                this.doFailure(new UpdateError(this.mContext, 1002));
            } else if (UpdateUtil.isIgnore(this.mContext, info.md5)) {
                this.doFailure(new UpdateError(this.mContext, 1001));
            } else {
                UpdateUtil.log("update md5" + this.mInfo.md5);
                this.mApkFile = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS), info.md5 + ".apk");
                if (UpdateUtil.verify(this.mApkFile, this.mInfo.md5, true)) {
                    Log.i((String)TAG, (String)"doCheckFinish: install page ============");
                    this.doInstall();
                } else if (info.isSilent) {
                    this.doDownload();
                } else {
                    this.doPrompt();
                }
            }
        }
    }

    void doPrompt() {
        this.mPrompter.prompt(this);
    }

    void doDownload() {
        this.mDownloader.download(this, this.mInfo.url, this.mApkFile);
    }

    void doInstall() {
        UpdateUtil.install(this.mContext, this.mApkFile, this.mInfo.isForce);
    }

    void doFailure(UpdateError error) {
        if (this.mIsManual || error.isError()) {
            this.mOnFailureListener.onFailure(error);
        }
    }

    public static class DefaultNotificationDownloadListener
    implements OnDownloadListener {
        private Context mContext;
        private int mNotifyId;
        private NotificationCompat.Builder mBuilder;

        public DefaultNotificationDownloadListener(Context context, int notifyId) {
            this.mContext = context;
            this.mNotifyId = notifyId;
        }

        @Override
        public void onStart() {
            if (this.mBuilder == null) {
                String title = this.mContext.getString(R.string.update_agent_apk_download_) + this.mContext.getString(this.mContext.getApplicationInfo().labelRes);
                this.mBuilder = new NotificationCompat.Builder(this.mContext);
                this.mBuilder.setOngoing(true).setAutoCancel(false).setPriority(2).setDefaults(2).setSmallIcon(this.mContext.getApplicationInfo().icon).setTicker((CharSequence)title).setContentTitle((CharSequence)title);
            }
            this.onProgress(0);
        }

        @Override
        public void onProgress(int progress) {
            if (this.mBuilder != null) {
                if (progress > 0) {
                    this.mBuilder.setPriority(0);
                    this.mBuilder.setDefaults(0);
                }
                this.mBuilder.setProgress(100, progress, false);
                NotificationManager nm = (NotificationManager)this.mContext.getSystemService("notification");
                nm.notify(this.mNotifyId, this.mBuilder.build());
            }
        }

        @Override
        public void onFinish() {
            NotificationManager nm = (NotificationManager)this.mContext.getSystemService("notification");
            nm.cancel(this.mNotifyId);
        }
    }

    public static class DefaultDialogDownloadListener
    implements OnDownloadListener {
        private Context mContext;
        private ProgressDialog mDialog;

        public DefaultDialogDownloadListener(Context context) {
            this.mContext = context;
        }

        @Override
        public void onStart() {
            if (this.mContext instanceof Activity && !((Activity)this.mContext).isFinishing()) {
                ProgressDialog dialog = new ProgressDialog(this.mContext);
                dialog.setProgressStyle(1);
                dialog.setMessage((CharSequence)this.mContext.getString(R.string.update_agent_apk_download));
                dialog.setIndeterminate(false);
                dialog.setCancelable(false);
                dialog.show();
                this.mDialog = dialog;
            }
        }

        @Override
        public void onProgress(int i) {
            if (this.mDialog != null) {
                this.mDialog.setProgress(i);
            }
        }

        @Override
        public void onFinish() {
            if (this.mDialog != null) {
                this.mDialog.dismiss();
                this.mDialog = null;
            }
        }
    }

    public static class DefaultFailureListener
    implements OnFailureListener {
        private Context mContext;

        public DefaultFailureListener(Context context) {
            this.mContext = context;
        }

        @Override
        public void onFailure(UpdateError error) {
            UpdateUtil.log(error.toString());
            Toast.makeText((Context)this.mContext, (CharSequence)error.toString(), (int)1).show();
        }
    }

    public static class DefaultUpdatePrompter
    implements IUpdatePrompter {
        private Context mContext;

        public DefaultUpdatePrompter(Context context) {
            this.mContext = context;
        }

        @Override
        public void prompt(IUpdateAgent agent) {
            if (this.mContext instanceof Activity && ((Activity)this.mContext).isFinishing()) {
                return;
            }
            UpdateInfo info = agent.getInfo();
            String size = info.size + "";
            String content = String.format(this.mContext.getString(R.string.update_agent_apk_content_format), info.versionName, size, info.updateContent);
            AlertDialog dialog = new AlertDialog.Builder(this.mContext).create();
            dialog.setTitle((CharSequence)this.mContext.getString(R.string.update_agent_apk_title));
            dialog.setCancelable(false);
            dialog.setCanceledOnTouchOutside(false);
            float density = this.mContext.getResources().getDisplayMetrics().density;
            TextView tv = new TextView(this.mContext);
            tv.setMovementMethod((MovementMethod)new ScrollingMovementMethod());
            tv.setVerticalScrollBarEnabled(true);
            tv.setTextSize(14.0f);
            tv.setMaxHeight((int)(250.0f * density));
            dialog.setView((View)tv, (int)(25.0f * density), (int)(15.0f * density), (int)(25.0f * density), 0);
            DefaultPromptClickListener listener = new DefaultPromptClickListener(agent, true);
            if (info.isForce) {
                tv.setText((CharSequence)(this.mContext.getString(R.string.update_agent_apk_tips) + content));
                dialog.setButton(-1, (CharSequence)this.mContext.getString(R.string.update_agent_apk_ok), (DialogInterface.OnClickListener)listener);
            } else {
                tv.setText((CharSequence)content);
                dialog.setButton(-1, (CharSequence)this.mContext.getString(R.string.update_agent_apk_update), (DialogInterface.OnClickListener)listener);
                dialog.setButton(-2, (CharSequence)this.mContext.getString(R.string.update_agent_apk_after), (DialogInterface.OnClickListener)listener);
                if (info.isIgnorable) {
                    dialog.setButton(-3, (CharSequence)this.mContext.getString(R.string.update_agent_apk_ignore), (DialogInterface.OnClickListener)listener);
                }
            }
            dialog.show();
        }
    }

    public static class DefaultUpdateParser
    implements IUpdateParser {
        @Override
        public UpdateInfo parse(String source) throws Exception {
            return UpdateInfo.parse(source);
        }
    }

    public static class DefaultUpdateDownloader
    implements IUpdateDownloader {
        final Context mContext;

        public DefaultUpdateDownloader(Context context) {
            this.mContext = context;
        }

        @Override
        public void download(IDownloadAgent agent, String url, File temp) {
            new UpdateDownloader2(this.mContext).download(agent, url, temp);
        }
    }
}

