/*
 * Decompiled with CFR 0.152.
 */
package ezy.boost.update;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Environment;
import android.os.StatFs;
import ezy.boost.update.IDownloadAgent;
import ezy.boost.update.UpdateError;
import ezy.boost.update.UpdateUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;

class UpdateDownloader
extends AsyncTask<Void, Integer, Long> {
    private static final int TIME_OUT = 30000;
    private static final int BUFFER_SIZE = 102400;
    private static final int EVENT_START = 1;
    private static final int EVENT_PROGRESS = 2;
    private static final int EVENT_COMPLETE = 3;
    private Context mContext;
    private IDownloadAgent mAgent;
    private String mUrl;
    private File mTemp;
    private long mBytesLoaded = 0L;
    private long mBytesTotal = 0L;
    private long mBytesTemp = 0L;
    private long mTimeBegin = 0L;
    private long mTimeUsed = 1L;
    private long mTimeLast = 0L;
    private long mSpeed = 0L;
    private HttpURLConnection mConnection;

    public UpdateDownloader(IDownloadAgent agent, Context context, String url, File file) {
        this.mContext = context;
        this.mAgent = agent;
        this.mUrl = url;
        this.mTemp = file;
        if (this.mTemp.exists()) {
            this.mBytesTemp = this.mTemp.length();
        }
    }

    public static long getAvailableStorage() {
        try {
            StatFs stat = new StatFs(Environment.getExternalStorageDirectory().toString());
            return stat.getAvailableBlocksLong() * stat.getBlockSizeLong();
        }
        catch (RuntimeException ex) {
            return 0L;
        }
    }

    public long getBytesLoaded() {
        return this.mBytesLoaded + this.mBytesTemp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long doInBackground(Void ... params) {
        this.mTimeBegin = System.currentTimeMillis();
        try {
            long result = this.download();
            if (this.isCancelled()) {
                this.mAgent.setError(new UpdateError(this.mContext, 3002));
            } else if (result == -1L) {
                this.mAgent.setError(new UpdateError(this.mContext, 3001));
            } else if (!UpdateUtil.verify(this.mTemp, this.mTemp.getName(), true)) {
                this.mAgent.setError(new UpdateError(this.mContext, 3010));
            }
        }
        catch (UpdateError e) {
            this.mAgent.setError(e);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.mAgent.setError(new UpdateError(this.mContext, 3004));
        }
        catch (IOException e) {
            e.printStackTrace();
            this.mAgent.setError(new UpdateError(this.mContext, 3005));
        }
        finally {
            if (this.mConnection != null) {
                this.mConnection.disconnect();
            }
        }
        return null;
    }

    protected void onProgressUpdate(Integer ... progress) {
        switch (progress[0]) {
            case 1: {
                this.mAgent.onStart();
                break;
            }
            case 2: {
                long now = System.currentTimeMillis();
                if (now - this.mTimeLast < 900L) break;
                this.mTimeLast = now;
                this.mTimeUsed = now - this.mTimeBegin;
                this.mSpeed = this.mBytesLoaded * 1000L / this.mTimeUsed;
                this.mAgent.onProgress((int)(this.getBytesLoaded() * 100L / this.mBytesTotal));
            }
        }
    }

    protected void onPostExecute(Long result) {
        this.mAgent.onFinish();
    }

    void checkNetwork() throws UpdateError {
        if (!UpdateUtil.checkNetwork(this.mContext)) {
            throw new UpdateError(this.mContext, 3006);
        }
    }

    void checkStatus() throws IOException, UpdateError {
        int statusCode = this.mConnection.getResponseCode();
        if (statusCode != 200 && statusCode != 206) {
            throw new UpdateError(this.mContext, 3008, "" + statusCode);
        }
    }

    void checkSpace(long loaded, long total) throws UpdateError {
        long storage = UpdateDownloader.getAvailableStorage();
        UpdateUtil.log("need = " + (total - loaded) + " = " + total + " - " + loaded + "\nspace = " + storage);
        if (total - loaded > storage) {
            throw new UpdateError(this.mContext, 3003);
        }
    }

    private HttpURLConnection create(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Accept", "application/*");
        connection.setConnectTimeout(10000);
        return connection;
    }

    private long download() throws IOException, UpdateError {
        this.checkNetwork();
        this.mConnection = this.create(new URL(this.mUrl));
        this.mConnection.connect();
        this.checkStatus();
        this.mBytesTotal = this.mConnection.getContentLength();
        this.checkSpace(this.mBytesTemp, this.mBytesTotal);
        if (this.mBytesTemp == this.mBytesTotal) {
            this.publishProgress(new Integer[]{1});
            return 0L;
        }
        if (this.mBytesTemp > 0L) {
            this.mConnection.disconnect();
            this.mConnection = this.create(this.mConnection.getURL());
            this.mConnection.addRequestProperty("Range", "bytes=" + this.mBytesTemp + "-");
            this.mConnection.connect();
            this.checkStatus();
        }
        this.publishProgress(new Integer[]{1});
        int bytesCopied = this.copy(this.mConnection.getInputStream(), new LoadingRandomAccessFile(this.mTemp));
        if (!this.isCancelled() && this.mBytesTemp + (long)bytesCopied != this.mBytesTotal && this.mBytesTotal != -1L) {
            UpdateUtil.log("download incomplete(" + this.mBytesTemp + " + " + bytesCopied + " != " + this.mBytesTotal + ")");
            throw new UpdateError(this.mContext, 3009);
        }
        return bytesCopied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int copy(InputStream in, RandomAccessFile out) throws IOException, UpdateError {
        byte[] buffer = new byte[102400];
        BufferedInputStream bis = new BufferedInputStream(in, 102400);
        try {
            int n;
            out.seek(out.length());
            int bytes = 0;
            long previousBlockTime = -1L;
            while (!this.isCancelled() && (n = bis.read(buffer, 0, 102400)) != -1) {
                out.write(buffer, 0, n);
                bytes += n;
                this.checkNetwork();
                if (this.mSpeed != 0L) {
                    previousBlockTime = -1L;
                    continue;
                }
                if (previousBlockTime == -1L) {
                    previousBlockTime = System.currentTimeMillis();
                    continue;
                }
                if (System.currentTimeMillis() - previousBlockTime <= 30000L) continue;
                throw new UpdateError(this.mContext, 3007);
            }
            int n2 = bytes;
            return n2;
        }
        finally {
            out.close();
            bis.close();
            in.close();
        }
    }

    private final class LoadingRandomAccessFile
    extends RandomAccessFile {
        public LoadingRandomAccessFile(File file) throws FileNotFoundException {
            super(file, "rw");
        }

        @Override
        public void write(byte[] buffer, int offset, int count) throws IOException {
            super.write(buffer, offset, count);
            UpdateDownloader.this.mBytesLoaded = UpdateDownloader.this.mBytesLoaded + (long)count;
            UpdateDownloader.this.publishProgress(new Integer[]{2});
        }
    }
}

