/*
 * Decompiled with CFR 0.152.
 */
package ezy.boost.update;

import android.content.Context;
import android.util.SparseIntArray;
import ezy.boost.update.R;

public class UpdateError
extends Throwable {
    public static final int UPDATE_IGNORED = 1001;
    public static final int UPDATE_NO_NEWER = 1002;
    public static final int CHECK_UNKNOWN = 2001;
    public static final int CHECK_NO_WIFI = 2002;
    public static final int CHECK_NO_NETWORK = 2003;
    public static final int CHECK_NETWORK_IO = 2004;
    public static final int CHECK_HTTP_STATUS = 2005;
    public static final int CHECK_PARSE = 2006;
    public static final int DOWNLOAD_UNKNOWN = 3001;
    public static final int DOWNLOAD_CANCELLED = 3002;
    public static final int DOWNLOAD_DISK_NO_SPACE = 3003;
    public static final int DOWNLOAD_DISK_IO = 3004;
    public static final int DOWNLOAD_NETWORK_IO = 3005;
    public static final int DOWNLOAD_NETWORK_BLOCKED = 3006;
    public static final int DOWNLOAD_NETWORK_TIMEOUT = 3007;
    public static final int DOWNLOAD_HTTP_STATUS = 3008;
    public static final int DOWNLOAD_INCOMPLETE = 3009;
    public static final int DOWNLOAD_VERIFY = 3010;
    public static final SparseIntArray messages = new SparseIntArray();
    public final int code;

    public UpdateError(Context context, int code) {
        this(context, code, null);
    }

    public UpdateError(Context context, int code, String message) {
        super(UpdateError.make(context, code, message));
        this.code = code;
    }

    private static String make(Context context, int code, String message) {
        int mRes = messages.get(code);
        String m = null;
        try {
            m = context.getString(mRes);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (m == null) {
            return message;
        }
        if (message == null) {
            return m;
        }
        return m + "(" + message + ")";
    }

    public boolean isError() {
        return this.code >= 2000;
    }

    @Override
    public String toString() {
        if (this.isError()) {
            return "[" + this.code + "]" + this.getMessage();
        }
        return this.getMessage();
    }

    static {
        messages.append(1001, R.string.update_gaibanbenyijinghulve);
        messages.append(1002, R.string.update_yijingshizuixinbanle);
        messages.append(2001, R.string.update_chaxungengxinshibai_weizhicuowu);
        messages.append(2002, R.string.update_chaxungengxinshibai_meiyou_wifi);
        messages.append(2003, R.string.update_chaxungengxinshibai_meiyouwangluo);
        messages.append(2004, R.string.update_chaxungengxinshibai_wangluoyichang);
        messages.append(2005, R.string.update_chaxungengxinshibai_cuowudehttpzhuangtai);
        messages.append(2006, R.string.update_chaxungengxinshibai_jiexicuowu);
        messages.append(3001, R.string.update_xiazaishibai_weizhicuowu);
        messages.append(3002, R.string.update_xiazaishibai_xiazaibeiquxiao);
        messages.append(3003, R.string.update_xiazaishibai_cipankongjianbuzu);
        messages.append(3004, R.string.update_xiazaishibai_cipanduxiecuowu);
        messages.append(3005, R.string.update_xiazaishibai_wangluoyichang);
        messages.append(3006, R.string.update_xiazaishibai_wangluozhongduan);
        messages.append(3007, R.string.update_xiazaishibai_wangluochaoshi);
        messages.append(3008, R.string.update_xiazaishibai_cuowudehttpzhuangtai);
        messages.append(3009, R.string.update_xiazaishibai_xiazaibuwanzheng);
        messages.append(3010, R.string.update_xiazaishibai_xiaoyancuowu);
    }
}

