/*
 * Decompiled with CFR 0.152.
 */
package ezy.boost.update;

import org.json.JSONException;
import org.json.JSONObject;

public class UpdateInfo {
    public boolean hasUpdate = false;
    public boolean isSilent = false;
    public boolean isForce = false;
    public boolean isAutoInstall = true;
    public boolean isIgnorable = true;
    public int maxTimes = 1;
    public int versionCode;
    public String versionName;
    public String updateContent;
    public String url;
    public String md5;
    public float size;
    public boolean isClickCheckUpdate = false;

    public static UpdateInfo parse(String s) throws JSONException {
        JSONObject o = new JSONObject(s);
        return UpdateInfo.parse(o.has("data") ? o.getJSONObject("data") : o);
    }

    private static UpdateInfo parse(JSONObject o) {
        UpdateInfo info = new UpdateInfo();
        if (o == null) {
            return info;
        }
        info.hasUpdate = o.optBoolean("hasUpdate", false);
        if (!info.hasUpdate) {
            return info;
        }
        info.isSilent = o.optBoolean("isSilent", false);
        info.isForce = o.optBoolean("isForce", false);
        info.isAutoInstall = o.optBoolean("isAutoInstall", !info.isSilent);
        info.isIgnorable = o.optBoolean("isIgnorable", true);
        info.versionCode = o.optInt("versionCode", 0);
        info.versionName = o.optString("versionName");
        info.updateContent = o.optString("updateContent");
        info.url = o.optString("url");
        info.md5 = o.optString("md5");
        info.size = o.optLong("size", 0L);
        return info;
    }
}

