/*
 * Decompiled with CFR 0.152.
 */
package ezy.boost.update;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import ezy.boost.update.IUpdateChecker;
import ezy.boost.update.IUpdateDownloader;
import ezy.boost.update.IUpdateParser;
import ezy.boost.update.IUpdatePrompter;
import ezy.boost.update.OnDownloadListener;
import ezy.boost.update.OnFailureListener;
import ezy.boost.update.UpdateAgent;
import ezy.boost.update.UpdateChecker;
import ezy.boost.update.UpdateError;
import ezy.boost.update.UpdateUtil;
import java.nio.charset.Charset;

public class UpdateManager {
    private static String sUrl;
    private static String sChannel;
    private static boolean sIsWifiOnly;

    public static void setWifiOnly(boolean wifiOnly) {
        sIsWifiOnly = wifiOnly;
    }

    public static void setUrl(String url, String channel) {
        sUrl = url;
        sChannel = channel;
    }

    public static void setDebuggable(boolean debuggable) {
        UpdateUtil.DEBUG = debuggable;
    }

    public static void install(Context context) {
        UpdateUtil.install(context, true);
    }

    public static void check(Context context) {
        UpdateManager.create(context).check();
    }

    public static void checkManual(Context context) {
        UpdateManager.create(context).setManual(true).check();
    }

    public static Builder create(Context context) {
        return new Builder(context).setWifiOnly(sIsWifiOnly);
    }

    static {
        sIsWifiOnly = false;
    }

    public static class Builder {
        private static long sLastTime;
        private Context mContext;
        private String mUrl;
        private byte[] mPostData;
        private boolean mIsManual;
        private boolean mIsWifiOnly;
        private int mNotifyId = 0;
        private OnDownloadListener mOnNotificationDownloadListener;
        private OnDownloadListener mOnDownloadListener;
        private IUpdatePrompter mPrompter;
        private OnFailureListener mOnFailureListener;
        private IUpdateParser mParser;
        private IUpdateChecker mChecker;
        private IUpdateDownloader mDownloader;

        public Builder(Context context) {
            this.mContext = context;
        }

        public Builder setUrl(String url) {
            this.mUrl = url;
            return this;
        }

        public Builder setPostData(@NonNull byte[] data) {
            this.mPostData = data;
            return this;
        }

        public Builder setPostData(@NonNull String data) {
            this.mPostData = data.getBytes(Charset.forName("UTF-8"));
            return this;
        }

        public Builder setNotifyId(int notifyId) {
            this.mNotifyId = notifyId;
            return this;
        }

        public Builder setManual(boolean isManual) {
            this.mIsManual = isManual;
            return this;
        }

        public Builder setWifiOnly(boolean isWifiOnly) {
            this.mIsWifiOnly = isWifiOnly;
            return this;
        }

        public Builder setParser(@NonNull IUpdateParser parser) {
            this.mParser = parser;
            return this;
        }

        public Builder setChecker(@NonNull IUpdateChecker checker) {
            this.mChecker = checker;
            return this;
        }

        public Builder setDownloader(@NonNull IUpdateDownloader downloader) {
            this.mDownloader = downloader;
            return this;
        }

        public Builder setPrompter(@NonNull IUpdatePrompter prompter) {
            this.mPrompter = prompter;
            return this;
        }

        public Builder setOnNotificationDownloadListener(@NonNull OnDownloadListener listener) {
            this.mOnNotificationDownloadListener = listener;
            return this;
        }

        public Builder setOnDownloadListener(@NonNull OnDownloadListener listener) {
            this.mOnDownloadListener = listener;
            return this;
        }

        public Builder setOnFailureListener(@NonNull OnFailureListener listener) {
            this.mOnFailureListener = listener;
            return this;
        }

        public void check() {
            long now = System.currentTimeMillis();
            if (now - sLastTime < 3000L) {
                return;
            }
            sLastTime = now;
            if (TextUtils.isEmpty((CharSequence)this.mUrl)) {
                this.mUrl = UpdateUtil.toCheckUrl(this.mContext, sUrl, sChannel);
            }
            UpdateAgent agent = new UpdateAgent(this.mContext, this.mUrl, this.mIsManual, this.mIsWifiOnly, this.mNotifyId);
            agent.setOnNotificationDownloadListener(new UpdateAgent.DefaultNotificationDownloadListener(this.mContext, 998));
            if (this.mOnNotificationDownloadListener != null) {
                agent.setOnNotificationDownloadListener(this.mOnNotificationDownloadListener);
            }
            agent.setOnDownloadListener(new UpdateAgent.DefaultDialogDownloadListener(this.mContext));
            if (this.mOnDownloadListener != null) {
                agent.setOnDownloadListener(this.mOnDownloadListener);
            }
            agent.setOnFailureListener(new OnFailureListener(){

                @Override
                public void onFailure(UpdateError error) {
                    Log.i((String)"fail", (String)error.toString());
                }
            });
            if (this.mOnFailureListener != null) {
                agent.setOnFailureListener(this.mOnFailureListener);
            }
            agent.setChecker(new UpdateChecker());
            if (this.mChecker != null) {
                agent.setChecker(this.mChecker);
            } else {
                agent.setChecker(new UpdateChecker(this.mPostData));
            }
            agent.setParser(new UpdateAgent.DefaultUpdateParser());
            if (this.mParser != null) {
                agent.setParser(this.mParser);
            }
            agent.setDownloader(new UpdateAgent.DefaultUpdateDownloader(this.mContext));
            if (this.mDownloader != null) {
                agent.setDownloader(this.mDownloader);
            }
            if (this.mPrompter != null) {
                agent.setPrompter(this.mPrompter);
            }
            agent.check();
        }
    }
}

