/*
 * Decompiled with CFR 0.152.
 */
package ezy.boost.update.download;

import android.app.DownloadManager;
import android.database.ContentObserver;
import android.database.Cursor;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import ezy.boost.update.download.LogUtils;

public class DownloadObserver
extends ContentObserver {
    private DownloadManager mDownloadManager;
    private long mTaskId;
    private Handler mHandler;
    private Bundle bundle = new Bundle();
    private Message message;
    private DownloadManager.Query query;
    private Cursor cursor;
    public static final String CURBYTES = "curBytes";
    public static final String TOTALBYTES = "totalBytes";
    public static final String PROGRESS = "progress";

    public DownloadObserver(Handler handler, DownloadManager downloadManager, long taskId) {
        super(handler);
        this.mHandler = handler;
        this.mDownloadManager = downloadManager;
        this.mTaskId = taskId;
        this.query = new DownloadManager.Query().setFilterById(new long[]{this.mTaskId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChange(boolean selfChange) {
        super.onChange(selfChange);
        try {
            this.cursor = this.mDownloadManager.query(this.query);
            if (this.cursor == null) {
                return;
            }
            this.cursor.moveToFirst();
            long curBytes = this.cursor.getLong(this.cursor.getColumnIndexOrThrow("bytes_so_far"));
            long totalBytes = this.cursor.getLong(this.cursor.getColumnIndexOrThrow("total_size"));
            int mProgress = (int)(curBytes * 100L / totalBytes);
            if (totalBytes != 0L) {
                LogUtils.debug("curBytes==" + curBytes);
                LogUtils.debug("totalBytes==" + totalBytes);
                LogUtils.debug("mProgress------->" + mProgress);
                this.message = this.mHandler.obtainMessage();
                this.bundle.putLong(CURBYTES, curBytes);
                this.bundle.putLong(TOTALBYTES, totalBytes);
                this.bundle.putInt(PROGRESS, mProgress);
                this.message.setData(this.bundle);
                this.mHandler.sendMessage(this.message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.cursor != null) {
                this.cursor.close();
            }
        }
    }
}

