/*
 * Decompiled with CFR 0.152.
 */
package ezy.boost.update.download;

import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import ezy.boost.update.download.CompleteListener;
import ezy.boost.update.download.LogUtils;
import ezy.boost.update.download.Updater;
import java.io.File;

public class DownloadReceiver
extends BroadcastReceiver {
    CompleteListener completeListener;

    public void bindCompleteListener(CompleteListener listener) {
        this.completeListener = listener;
    }

    public void onReceive(Context context, Intent intent) {
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            return;
        }
        long downId = bundle.getLong("extra_download_id", 0L);
        if (TextUtils.equals((CharSequence)intent.getAction(), (CharSequence)"android.intent.action.DOWNLOAD_COMPLETE") || TextUtils.equals((CharSequence)intent.getAction(), (CharSequence)"android.intent.action.DOWNLOAD_NOTIFICATION_CLICKED")) {
            this.queryFileUri(context, downId);
        }
    }

    private void queryFileUri(Context context, long downloadApkId) {
        DownloadManager dManager = (DownloadManager)context.getSystemService("download");
        DownloadManager.Query query = new DownloadManager.Query();
        query.setFilterById(new long[]{downloadApkId});
        if (dManager == null) {
            return;
        }
        Cursor c = dManager.query(query);
        if (c != null && c.moveToFirst()) {
            int status = c.getInt(c.getColumnIndexOrThrow("status"));
            switch (status) {
                case 1: {
                    LogUtils.debug("STATUS_PENDING");
                    break;
                }
                case 4: {
                    LogUtils.debug("STATUS_PAUSED");
                    break;
                }
                case 2: {
                    LogUtils.debug("STATUS_RUNNING");
                    break;
                }
                case 8: {
                    LogUtils.debug("STATUS_SUCCESSFUL");
                    String downloadFileUrl = c.getString(c.getColumnIndex("local_uri"));
                    if (this.completeListener == null) break;
                    this.completeListener.onComplete(new File(Uri.parse((String)downloadFileUrl).getPath()));
                    break;
                }
                case 1009: {
                    break;
                }
                case 16: {
                    LogUtils.debug("STATUS_FAILED");
                    Updater.showToast(context, "\u4e0b\u8f7d\u5931\u8d25\uff0c\u5f00\u59cb\u91cd\u65b0\u4e0b\u8f7d...");
                    context.sendBroadcast(new Intent("DownloadFailedReceiver"));
                }
            }
            c.close();
        }
    }
}

