/*
 * Decompiled with CFR 0.152.
 */
package ezy.boost.update.download;

import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.widget.Toast;
import ezy.boost.update.download.CompleteListener;
import ezy.boost.update.download.DownloadObserver;
import ezy.boost.update.download.DownloadReceiver;
import ezy.boost.update.download.LogUtils;
import ezy.boost.update.download.ProgressListener;
import java.io.File;
import java.util.ArrayList;

public class Updater {
    private File apkFile;
    private String title;
    private String downloadUrl;
    private Context context;
    private DownloadManager downloadManager;
    private long mTaskId;
    private boolean hideNotification = false;
    private boolean allowedOverRoaming = false;
    private DownloadReceiver downloadReceiver;
    private DownloadObserver downloadObserver;
    private boolean claerCache = false;
    private String[] perms = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"};
    private static final int RC_SDCARD = 123;
    private DownloadFailedReceiver downloadFailedReceiver = new DownloadFailedReceiver();
    private ArrayList<ProgressListener> listeners;
    CompleteListener completeListener;
    private Handler handler = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            Bundle data = msg.getData();
            long cutBytes = data.getLong("curBytes");
            long totalBytes = data.getLong("totalBytes");
            int progress = data.getInt("progress");
            if (Updater.this.listeners != null && !Updater.this.listeners.isEmpty()) {
                for (ProgressListener listener : Updater.this.listeners) {
                    listener.onProgressChange(totalBytes, cutBytes, progress);
                }
            }
            return false;
        }
    });

    private Updater(Context context) {
        this.context = context;
    }

    private void download() {
        if (this.context == null) {
            throw new NullPointerException("context must not be null");
        }
        if (TextUtils.isEmpty((CharSequence)this.downloadUrl)) {
            throw new NullPointerException("downloadUrl must not be null");
        }
        if (this.apkFile == null) {
            try {
                throw new Exception("\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740\u4e3anull");
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        if (this.downloadManager == null) {
            this.downloadManager = (DownloadManager)this.context.getSystemService("download");
        }
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)this.downloadUrl));
        request.setAllowedNetworkTypes(3);
        request.setAllowedOverRoaming(this.allowedOverRoaming);
        request.setTitle((CharSequence)(TextUtils.isEmpty((CharSequence)this.title) ? this.apkFile.getName() : this.title));
        request.setNotificationVisibility(this.hideNotification ? 2 : 0);
        request.setDestinationInExternalPublicDir(Environment.DIRECTORY_DOWNLOADS, this.apkFile.getName());
        this.mTaskId = this.downloadManager.enqueue(request);
        if (this.downloadFailedReceiver != null) {
            this.context.registerReceiver((BroadcastReceiver)this.downloadFailedReceiver, new IntentFilter("DownloadFailedReceiver"));
        }
    }

    public void registerDownloadReceiver() {
        if (this.downloadReceiver == null) {
            this.downloadReceiver = new DownloadReceiver();
        }
        this.context.registerReceiver((BroadcastReceiver)this.downloadReceiver, new IntentFilter("android.intent.action.DOWNLOAD_COMPLETE"));
    }

    public void unRegisterDownloadReceiver() {
        if (this.downloadReceiver != null) {
            this.context.unregisterReceiver((BroadcastReceiver)this.downloadReceiver);
        }
    }

    public Updater addProgressListener(ProgressListener progressListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (!this.listeners.contains(progressListener)) {
            this.listeners.add(progressListener);
        }
        if (this.downloadObserver == null && this.handler != null && this.downloadManager != null) {
            this.downloadObserver = new DownloadObserver(this.handler, this.downloadManager, this.mTaskId);
            this.context.getContentResolver().registerContentObserver(Uri.parse((String)"content://downloads/"), true, (ContentObserver)this.downloadObserver);
        }
        return this;
    }

    public Updater bindCompleteListener(CompleteListener completeListener) {
        this.downloadReceiver.bindCompleteListener(completeListener);
        return this;
    }

    public void removeProgressListener(ProgressListener progressListener) {
        if (!this.listeners.contains(progressListener)) {
            throw new NullPointerException("this progressListener not attch Updater");
        }
        if (this.listeners != null && !this.listeners.isEmpty()) {
            this.listeners.remove(progressListener);
            if (this.listeners.isEmpty() && this.downloadObserver != null) {
                this.context.getContentResolver().unregisterContentObserver((ContentObserver)this.downloadObserver);
            }
        }
    }

    public static void showToast(Context context, String msg) {
        Toast.makeText((Context)context, (CharSequence)msg, (int)0).show();
    }

    public class DownloadFailedReceiver
    extends BroadcastReceiver {
        public static final String tag = "DownloadFailedReceiver";

        public void onReceive(Context context, Intent intent) {
            LogUtils.debug("\u5f00\u59cb\u91cd\u65b0\u4e0b\u8f7d");
            Updater.this.download();
        }
    }

    public static class Builder {
        private Updater mUpdater;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Builder(Context context) {
            Class<Updater> clazz = Updater.class;
            synchronized (Updater.class) {
                if (this.mUpdater != null) return;
                Class<Updater> clazz2 = Updater.class;
                synchronized (Updater.class) {
                    this.mUpdater = new Updater(context);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }
        }

        public Builder setApkFile(File apkFile) {
            if (apkFile == null) {
                return this;
            }
            this.mUpdater.apkFile = apkFile;
            return this;
        }

        public Builder setDownloadUrl(String downloadUrl) {
            this.mUpdater.downloadUrl = downloadUrl;
            return this;
        }

        public Builder setNotificationTitle(String title) {
            this.mUpdater.title = title;
            return this;
        }

        public Builder hideNotification() {
            this.mUpdater.hideNotification = true;
            return this;
        }

        public Builder debug() {
            LogUtils.isDebug = true;
            return this;
        }

        public Builder allowedOverRoaming() {
            this.mUpdater.allowedOverRoaming = true;
            return this;
        }

        public Builder clearCache() {
            this.mUpdater.claerCache = true;
            return this;
        }

        public Updater start() {
            this.mUpdater.registerDownloadReceiver();
            this.mUpdater.download();
            return this.mUpdater;
        }
    }
}

