/*
 * Decompiled with CFR 0.152.
 */
package ezy.boost.update.download;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import androidx.core.content.FileProvider;
import ezy.boost.update.download.LogUtils;
import java.io.File;

public class Utils {
    public static final String getFileNameForUrl(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            throw new NullPointerException("url is null");
        }
        return url.substring(url.lastIndexOf("/") + 1);
    }

    public static void installApk(Context context, Uri uri) {
        File file = new File(uri.getPath());
        if (!file.exists()) {
            LogUtils.debug("apk file not exists");
            return;
        }
        Intent intent = new Intent();
        if (Build.VERSION.SDK_INT > 24) {
            String packageName = context.getPackageName();
            LogUtils.debug("packageName==" + packageName);
            Uri providerUri = FileProvider.getUriForFile((Context)context, (String)(packageName + ".fileProvider"), (File)file);
            LogUtils.debug("providerUri==" + providerUri);
            intent.addFlags(1);
            intent.setDataAndType(providerUri, "application/vnd.android.package-archive");
        } else {
            intent.setDataAndType(uri, "application/vnd.android.package-archive");
        }
        intent.addFlags(0x10000000);
        intent.setAction("android.intent.action.VIEW");
        context.startActivity(intent);
    }
}

