/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.widget.common;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;

public class FoldTextView
extends AppCompatTextView
implements View.OnClickListener {
    public static final String TAG = "FoldTextView";
    private int mDefaultShowLine = 2;
    private ViewGroup.LayoutParams mLayoutParams;
    private int mMaxHeight;
    private float mFoldHeight;
    private float mDefaultShowHeight;
    private OnFoldListener mOnFoldListener;

    public FoldTextView(Context context) {
        this(context, null);
    }

    public FoldTextView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FoldTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
    }

    public void setOnFoldListener(OnFoldListener onFoldListener) {
        this.mOnFoldListener = onFoldListener;
    }

    public void setShowLineRule(int lineRule) {
        this.mDefaultShowLine = lineRule;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mLayoutParams == null) {
            this.mLayoutParams = this.getLayoutParams();
        }
    }

    public void setText() {
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        super.setText(text, type);
        this.post(new Runnable(){

            @Override
            public void run() {
                int linCount = FoldTextView.this.getLineCount();
                if (linCount <= 0) {
                    return;
                }
                int defaultShowLine = FoldTextView.this.mDefaultShowLine;
                int lineHeight = FoldTextView.this.getLineHeight();
                int contentHeight = lineHeight * linCount;
                float defaultHeight = defaultShowLine * lineHeight;
                FoldTextView.this.mMaxHeight = contentHeight;
                FoldTextView.this.mDefaultShowHeight = defaultHeight;
                if (FoldTextView.this.mFoldHeight <= 0.0f) {
                    FoldTextView.this.mFoldHeight = (float)contentHeight - defaultHeight;
                }
                ((FoldTextView)FoldTextView.this).mLayoutParams.height = (int)FoldTextView.this.mDefaultShowHeight + FoldTextView.this.getPaddingBottom() + FoldTextView.this.getPaddingTop();
                FoldTextView.this.setLayoutParams(FoldTextView.this.mLayoutParams);
                if (linCount > 2) {
                    FoldTextView.this.setOnClickListener(FoldTextView.this);
                }
            }
        });
    }

    public void onClick(View v) {
        OnFoldListener onFoldListener = this.mOnFoldListener;
        if (onFoldListener == null) {
            return;
        }
        float foldHeight = this.mFoldHeight;
        float defaultSHowHeight = this.mDefaultShowHeight;
        if (v.getTag() == null) {
            this.animator(foldHeight, defaultSHowHeight);
            v.setTag((Object)true);
            onFoldListener.unfold();
        } else {
            this.animator(-foldHeight, this.mMaxHeight);
            v.setTag(null);
            onFoldListener.fold();
        }
    }

    public void foldContent() {
        OnFoldListener onFoldListener = this.mOnFoldListener;
        float foldHeight = this.mFoldHeight;
        int maxHeight = this.mMaxHeight;
        this.animator(-foldHeight, maxHeight);
        this.setTag(null);
        if (onFoldListener == null) {
            return;
        }
        onFoldListener.fold();
    }

    public void unfoldContent() {
        OnFoldListener onFoldListener = this.mOnFoldListener;
        float foldHeight = this.mFoldHeight;
        float defaultSHowHeight = this.mDefaultShowHeight;
        this.animator(foldHeight, defaultSHowHeight);
        this.setTag(true);
        if (onFoldListener == null) {
            return;
        }
        onFoldListener.unfold();
    }

    private void animator(final float foldHeight, final float defaultSHowHeight) {
        final ViewGroup.LayoutParams layoutParams = this.mLayoutParams;
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f}).setDuration(360L);
        valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float progress = ((Float)animation.getAnimatedValue()).floatValue();
                layoutParams.height = (int)(defaultSHowHeight + foldHeight * progress) + FoldTextView.this.getPaddingBottom() + FoldTextView.this.getPaddingTop();
                FoldTextView.this.setLayoutParams(layoutParams);
            }
        });
        if (valueAnimator.isRunning() && valueAnimator.isStarted()) {
            valueAnimator.cancel();
        }
        valueAnimator.start();
    }

    public static interface OnFoldListener {
        public void fold();

        public void unfold();
    }
}

