/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.widget.common.byh;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.ViewFlipper;
import com.kangxin.widget.R;
import com.kangxin.widget.common.byh.MarqueeTextViewClickListener;

public class MarqueeTextView
extends LinearLayout {
    private Context mContext;
    private ViewFlipper viewFlipper;
    private View marqueeTextView;
    private String[] textArrays;
    private MarqueeTextViewClickListener marqueeTextViewClickListener;

    public MarqueeTextView(Context context) {
        super(context);
        this.mContext = context;
        this.initBasicView();
    }

    public MarqueeTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.initBasicView();
    }

    public void setTextArraysAndClickListener(String[] textArrays, MarqueeTextViewClickListener marqueeTextViewClickListener) {
        this.textArrays = textArrays;
        this.marqueeTextViewClickListener = marqueeTextViewClickListener;
        this.initMarqueeTextView(textArrays, marqueeTextViewClickListener);
    }

    public void initBasicView() {
        this.marqueeTextView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.marquee_textview_layout, null);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -1);
        layoutParams.gravity = 16;
        this.addView(this.marqueeTextView, (ViewGroup.LayoutParams)layoutParams);
        this.viewFlipper = (ViewFlipper)this.marqueeTextView.findViewById(R.id.viewFlipper);
        this.viewFlipper.setInAnimation(AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.slide_in_bottom));
        this.viewFlipper.setOutAnimation(AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.slide_out_top));
        this.viewFlipper.startFlipping();
    }

    public void initMarqueeTextView(String[] textArrays, MarqueeTextViewClickListener marqueeTextViewClickListener) {
        if (textArrays.length == 0) {
            return;
        }
        int i = 0;
        if (this.viewFlipper == null) {
            this.initBasicView();
        }
        this.viewFlipper.removeAllViews();
        while (i < textArrays.length) {
            TextView textView = new TextView(this.mContext);
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -1);
            lp.gravity = 16;
            textView.setGravity(16);
            textView.setLayoutParams((ViewGroup.LayoutParams)lp);
            textView.setTextColor(this.mContext.getResources().getColor(R.color.widget_gray_333333));
            textView.setTextSize(14.0f);
            textView.setText((CharSequence)textArrays[i]);
            textView.setLines(1);
            textView.setMaxLines(1);
            textView.setSingleLine(true);
            textView.setEllipsize(TextUtils.TruncateAt.END);
            textView.setOnClickListener((View.OnClickListener)marqueeTextViewClickListener);
            this.viewFlipper.addView((View)textView, (ViewGroup.LayoutParams)lp);
            ++i;
        }
    }

    public void releaseResources() {
        if (this.marqueeTextView != null) {
            if (this.viewFlipper != null) {
                this.viewFlipper.stopFlipping();
                this.viewFlipper.removeAllViews();
                this.viewFlipper = null;
            }
            this.marqueeTextView = null;
        }
    }
}

