/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.widget.common.byh;

import android.content.Context;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import androidx.appcompat.widget.AppCompatEditText;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZpPhoneEditText
extends AppCompatEditText
implements TextWatcher {
    private static final String TAG = "ZpPhoneEditText";
    private static final int PHONE_INDEX_3 = 3;
    private static final int PHONE_INDEX_4 = 4;
    private static final int PHONE_INDEX_8 = 8;
    private static final int PHONE_INDEX_9 = 9;

    public ZpPhoneEditText(Context context) {
        super(context);
        this.initView();
    }

    public ZpPhoneEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public ZpPhoneEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        this.setFilters(new InputFilter[]{new InputFilter(){

            public CharSequence filter(CharSequence source, int start, int end, Spanned spanned, int dstart, int dend) {
                Log.i((String)ZpPhoneEditText.TAG, (String)("filter==>source=" + source + "=start=" + start + "=end=" + end + "=dstart=" + dstart + "=dend=" + dend + "=spanned=" + spanned));
                String phoneNum = spanned.toString();
                int phoneLength = ZpPhoneEditText.this.replaceBlank(phoneNum).length();
                if (" ".equals(source.toString()) || source.toString().contentEquals("\n") || dstart == 13 || phoneLength == 11) {
                    return "";
                }
                return null;
            }
        }});
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        super.onTextChanged(s, start, before, count);
        if (s == null || s.length() == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (i != 3 && i != 8 && s.charAt(i) == ' ') continue;
            sb.append(s.charAt(i));
            if (sb.length() != 4 && sb.length() != 9 || sb.charAt(sb.length() - 1) == ' ') continue;
            sb.insert(sb.length() - 1, ' ');
        }
        if (!sb.toString().equals(s.toString())) {
            int index = start + 1;
            if (sb.charAt(start) == ' ') {
                index = before == 0 ? ++index : --index;
            } else if (before == 1) {
                --index;
            }
            this.setText(sb.toString());
            this.setSelection(index);
        }
    }

    public void afterTextChanged(Editable s) {
    }

    public String getPhoneText() {
        String str = this.getText().toString();
        return this.replaceBlank(str);
    }

    private String replaceBlank(String str) {
        Pattern p;
        Matcher m;
        String dest = "";
        if (str != null && (m = (p = Pattern.compile("\\s*|\t|\r|\n")).matcher(str)).find()) {
            dest = m.replaceAll("");
        }
        return dest;
    }
}

