/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.widget.worktab;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.List;

public abstract class RecyclerViewAdapter<T>
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    public static final int TYPE_HEADER = 0;
    public static final int TYPE_FOOTER = 1;
    public static final int TYPE_NORMAL = 2;
    protected View mHeader;
    protected View mFooter;
    protected List<T> mDatas;
    protected Context mContext;
    protected LayoutInflater mInflater;

    public RecyclerViewAdapter(Context context) {
        this(context, null);
    }

    public RecyclerViewAdapter(Context context, List<T> list) {
        this.mDatas = list;
        this.mContext = context;
        if (list != null) {
            this.mDatas = new ArrayList<T>(list);
        }
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
    }

    public void setData(List<T> data) {
        this.mDatas = data == null ? null : new ArrayList<T>(data);
        this.notifyDataSetChanged();
    }

    public void setHeaderView(View headerView) {
        if (null == headerView) {
            if (null != this.mHeader) {
                this.mHeader = null;
                this.notifyItemRemoved(0);
            }
        } else if (null != this.mHeader) {
            if (this.mHeader != headerView) {
                this.mHeader = headerView;
                this.notifyItemChanged(0);
            }
        } else {
            this.mHeader = headerView;
            this.notifyItemInserted(0);
        }
    }

    public void setFooterView(View footerView) {
        if (null == footerView) {
            if (null != this.mFooter) {
                this.mFooter = null;
                this.notifyItemRemoved(this.getItemCount());
            }
        } else if (null != this.mFooter) {
            if (this.mFooter != footerView) {
                this.mFooter = footerView;
                this.notifyItemChanged(this.getItemCount());
            }
        } else {
            this.mFooter = footerView;
            this.notifyItemInserted(this.getItemCount());
        }
    }

    public T getItem(int position) {
        if (this.isEmpty(this.mDatas) || position < 0 || position >= this.mDatas.size()) {
            return null;
        }
        return this.mDatas.get(position);
    }

    public boolean isEmpty(List list) {
        return list == null || list.isEmpty();
    }

    public int getHeaderViewsCount() {
        return null == this.mHeader ? 0 : 1;
    }

    public int getFooterViewsCount() {
        return null == this.mFooter ? 0 : 1;
    }

    public int getItemViewType(int position) {
        if (null != this.mHeader && position == 0) {
            return 0;
        }
        if (null != this.mFooter && position == this.getItemCount() - 1) {
            return 1;
        }
        return 2;
    }

    public int getItemCount() {
        int size = this.getHeaderViewsCount();
        size += this.getFooterViewsCount();
        if (null != this.mDatas) {
            size += this.mDatas.size();
        }
        return size;
    }

    public int getRealCount() {
        return null == this.mDatas ? 0 : this.mDatas.size();
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 0) {
            return new HeaderFooterHolder(this.mHeader);
        }
        if (viewType == 1) {
            return new HeaderFooterHolder(this.mFooter);
        }
        return this.onCreateNormalViewHolder(parent, viewType);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        int viewType = this.getItemViewType(position);
        if (viewType == 2) {
            this.onBindNormalViewHolder(holder, position - this.getHeaderViewsCount());
        }
    }

    public abstract RecyclerView.ViewHolder onCreateNormalViewHolder(ViewGroup var1, int var2);

    public abstract void onBindNormalViewHolder(RecyclerView.ViewHolder var1, int var2);

    static class HeaderFooterHolder
    extends RecyclerView.ViewHolder {
        public HeaderFooterHolder(View itemView) {
            super(itemView);
        }
    }
}

