/*
 * Decompiled with CFR 0.152.
 */
package ezy.boost.update;

import ezy.boost.update.ICheckAgent;
import ezy.boost.update.IUpdateChecker;
import ezy.boost.update.UpdateError;
import ezy.boost.update.UpdateUtil;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

public class UpdateChecker
implements IUpdateChecker {
    final byte[] mPostData;

    public UpdateChecker() {
        this.mPostData = null;
    }

    public UpdateChecker(byte[] data) {
        this.mPostData = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check(ICheckAgent agent, String url) {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestProperty("Accept", "application/json");
            if (this.mPostData == null) {
                connection.setRequestMethod("GET");
                connection.connect();
            } else {
                connection.setRequestMethod("POST");
                connection.setDoOutput(true);
                connection.setInstanceFollowRedirects(false);
                connection.setUseCaches(false);
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                connection.setRequestProperty("Content-Length", Integer.toString(this.mPostData.length));
                connection.getOutputStream().write(this.mPostData);
            }
            if (connection.getResponseCode() == 200) {
                agent.setInfo(UpdateUtil.readString(connection.getInputStream()));
            } else {
                agent.setError(new UpdateError(2005, "" + connection.getResponseCode()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            agent.setError(new UpdateError(2004));
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

