/*
 * Decompiled with CFR 0.152.
 */
package ezy.boost.update;

import android.util.SparseArray;

public class UpdateError
extends Throwable {
    public final int code;
    public static final int UPDATE_IGNORED = 1001;
    public static final int UPDATE_NO_NEWER = 1002;
    public static final int CHECK_UNKNOWN = 2001;
    public static final int CHECK_NO_WIFI = 2002;
    public static final int CHECK_NO_NETWORK = 2003;
    public static final int CHECK_NETWORK_IO = 2004;
    public static final int CHECK_HTTP_STATUS = 2005;
    public static final int CHECK_PARSE = 2006;
    public static final int DOWNLOAD_UNKNOWN = 3001;
    public static final int DOWNLOAD_CANCELLED = 3002;
    public static final int DOWNLOAD_DISK_NO_SPACE = 3003;
    public static final int DOWNLOAD_DISK_IO = 3004;
    public static final int DOWNLOAD_NETWORK_IO = 3005;
    public static final int DOWNLOAD_NETWORK_BLOCKED = 3006;
    public static final int DOWNLOAD_NETWORK_TIMEOUT = 3007;
    public static final int DOWNLOAD_HTTP_STATUS = 3008;
    public static final int DOWNLOAD_INCOMPLETE = 3009;
    public static final int DOWNLOAD_VERIFY = 3010;
    public static final SparseArray<String> messages = new SparseArray();

    public UpdateError(int code) {
        this(code, null);
    }

    public UpdateError(int code, String message) {
        super(UpdateError.make(code, message));
        this.code = code;
    }

    public boolean isError() {
        return this.code >= 2000;
    }

    @Override
    public String toString() {
        if (this.isError()) {
            return "[" + this.code + "]" + this.getMessage();
        }
        return this.getMessage();
    }

    private static String make(int code, String message) {
        String m = (String)messages.get(code);
        if (m == null) {
            return message;
        }
        if (message == null) {
            return m;
        }
        return m + "(" + message + ")";
    }

    static {
        messages.append(1001, (Object)"\u8be5\u7248\u672c\u5df2\u7ecf\u5ffd\u7565");
        messages.append(1002, (Object)"\u5df2\u7ecf\u662f\u6700\u65b0\u7248\u4e86");
        messages.append(2001, (Object)"\u67e5\u8be2\u66f4\u65b0\u5931\u8d25\uff1a\u672a\u77e5\u9519\u8bef");
        messages.append(2002, (Object)"\u67e5\u8be2\u66f4\u65b0\u5931\u8d25\uff1a\u6ca1\u6709 WIFI");
        messages.append(2003, (Object)"\u67e5\u8be2\u66f4\u65b0\u5931\u8d25\uff1a\u6ca1\u6709\u7f51\u7edc");
        messages.append(2004, (Object)"\u67e5\u8be2\u66f4\u65b0\u5931\u8d25\uff1a\u7f51\u7edc\u5f02\u5e38");
        messages.append(2005, (Object)"\u67e5\u8be2\u66f4\u65b0\u5931\u8d25\uff1a\u9519\u8bef\u7684HTTP\u72b6\u6001");
        messages.append(2006, (Object)"\u67e5\u8be2\u66f4\u65b0\u5931\u8d25\uff1a\u89e3\u6790\u9519\u8bef");
        messages.append(3001, (Object)"\u4e0b\u8f7d\u5931\u8d25\uff1a\u672a\u77e5\u9519\u8bef");
        messages.append(3002, (Object)"\u4e0b\u8f7d\u5931\u8d25\uff1a\u4e0b\u8f7d\u88ab\u53d6\u6d88");
        messages.append(3003, (Object)"\u4e0b\u8f7d\u5931\u8d25\uff1a\u78c1\u76d8\u7a7a\u95f4\u4e0d\u8db3");
        messages.append(3004, (Object)"\u4e0b\u8f7d\u5931\u8d25\uff1a\u78c1\u76d8\u8bfb\u5199\u9519\u8bef");
        messages.append(3005, (Object)"\u4e0b\u8f7d\u5931\u8d25\uff1a\u7f51\u7edc\u5f02\u5e38");
        messages.append(3006, (Object)"\u4e0b\u8f7d\u5931\u8d25\uff1a\u7f51\u7edc\u4e2d\u65ad");
        messages.append(3007, (Object)"\u4e0b\u8f7d\u5931\u8d25\uff1a\u7f51\u7edc\u8d85\u65f6");
        messages.append(3008, (Object)"\u4e0b\u8f7d\u5931\u8d25\uff1a\u9519\u8bef\u7684HTTP\u72b6\u6001");
        messages.append(3009, (Object)"\u4e0b\u8f7d\u5931\u8d25\uff1a\u4e0b\u8f7d\u4e0d\u5b8c\u6574");
        messages.append(3010, (Object)"\u4e0b\u8f7d\u5931\u8d25\uff1a\u6821\u9a8c\u9519\u8bef");
    }
}

