/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMRandomDelay;
import com.hyphenate.chat.a.b;
import com.hyphenate.chat.a.e;
import com.hyphenate.cloud.EMHttpClient;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.util.DeviceUuidFactory;
import com.hyphenate.util.EMLog;
import com.xiaomi.mipush.sdk.MiPushClient;
import java.util.Random;
import org.json.JSONObject;

class EMPushHelper {
    public static final String TAG = EMPushHelper.class.getSimpleName();
    private static EMPushHelper instance;
    private Thread pushThread = null;
    private Object sendTokenLock = new Object();
    private String notifyDeviceToken;
    private boolean isLogout = false;
    private EMPushType pushType = EMPushType.NORMAL;

    EMPushHelper() {
    }

    public static EMPushHelper getInstance() {
        if (instance == null) {
            instance = new EMPushHelper();
        }
        return instance;
    }

    public void setPushType(EMPushType eMPushType) {
        this.pushType = eMPushType;
    }

    public EMPushType getPushType() {
        return this.pushType;
    }

    boolean checkAvailablePushService() {
        boolean bl = EMClient.getInstance().getOptions().isUseFCM() || EMClient.getInstance().getChatConfigPrivate().j();
        EMLog.d(TAG, "FCM is enabled : " + bl);
        boolean bl2 = false;
        try {
            if (bl && Class.forName("com.google.android.gms.common.GoogleApiAvailability") != null) {
                int n = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(EMClient.getInstance().getContext());
                bl2 = n == 0;
                EMLog.d(TAG, "FCM service available : " + bl2);
                if (!(!bl2 || TextUtils.isEmpty((CharSequence)EMClient.getInstance().getOptions().getFCMNumber()) && TextUtils.isEmpty((CharSequence)EMClient.getInstance().getOptions().getGCMNumber()))) {
                    if (!TextUtils.isEmpty((CharSequence)EMClient.getInstance().getOptions().getFCMNumber())) {
                        this.setPushType(EMPushType.FCM);
                    } else {
                        this.setPushType(EMPushType.GCM);
                    }
                } else {
                    bl2 = false;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            EMLog.e(TAG, "" + classNotFoundException.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl2) {
            return bl2;
        }
        try {
            if (Class.forName("com.xiaomi.mipush.sdk.MiPushClient") != null) {
                bl2 = MiPushClient.shouldUseMIUIPush((Context)EMClient.getInstance().getContext());
                EMLog.d(TAG, "mipush available : " + bl2);
                if (bl2) {
                    this.setPushType(EMPushType.MIPUSH);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            EMLog.d(TAG, "no mipush sdk");
        }
        catch (Exception exception) {
            EMLog.d(TAG, "exception, regard it as no mipush sdk");
        }
        return bl2;
    }

    boolean isPushServiceEnabled() {
        return this.pushType != EMPushType.NORMAL;
    }

    void onInit() {
        this.isLogout = false;
    }

    synchronized void sendDeviceTokenToServer() {
        if (this.isPushServiceEnabled()) {
            EMLog.d(TAG, "third-party push available");
            if (this.isLogout) {
                return;
            }
            if (this.pushThread != null) {
                return;
            }
            if (this.pushThread == null) {
                this.pushThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            class HandleSendFail {
                                HandleSendFail() {
                                }

                                void onSendFail() {
                                    EMPushHelper.this.setPushType(EMPushType.NORMAL);
                                    EMClient.getInstance().doStopService();
                                    EMClient.getInstance().doStartService();
                                }
                            }
                            int n;
                            String string = null;
                            for (n = 0; n < 3 && (string = EMPushHelper.this.getDeviceToken()) == null; ++n) {
                                try {
                                    1.sleep(new Random().nextInt(10) * 1000);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                                if (!this.isInterrupted()) continue;
                                return;
                            }
                            if (string == null) {
                                new HandleSendFail().onSendFail();
                                return;
                            }
                            if (EMPushHelper.this.getPushToken() == null) {
                                n = 0;
                                for (int i = 0; i < 3 && (n = (int)(EMPushHelper.this.sendDeviceInfo(string) ? 1 : 0)) != 1; ++i) {
                                    try {
                                        1.sleep((20 + new Random().nextInt(10)) * 1000);
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                    if (!this.isInterrupted()) continue;
                                    return;
                                }
                                if (n == 0) {
                                    new HandleSendFail().onSendFail();
                                    return;
                                }
                            }
                            n = 0;
                            int n2 = 0;
                            EMRandomDelay eMRandomDelay = new EMRandomDelay();
                            while (n == 0 && (n = (int)(EMPushHelper.this.sendTokenToServer(string) ? 1 : 0)) != 1) {
                                try {
                                    1.sleep(eMRandomDelay.timeDelay(n2++) * 1000);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                                if (!this.isInterrupted()) continue;
                                return;
                            }
                            if (n == 1) {
                                EMClient.getInstance().cancelJob();
                                EMClient.getInstance().doStopService();
                            }
                        }
                        catch (Exception exception) {
                            EMLog.e(TAG, exception.toString());
                        }
                        finally {
                            EMPushHelper.this.pushThread = null;
                        }
                    }
                };
                this.pushThread.start();
            }
        } else {
            EMLog.d(TAG, "FCM and mipush not available");
        }
    }

    synchronized void sendDeviceTokenToServer(final String string) {
        if (this.isPushServiceEnabled()) {
            EMLog.d(TAG, "third-party push available");
            if (this.isLogout) {
                return;
            }
            if (this.pushThread != null) {
                return;
            }
            this.pushThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        boolean bl = false;
                        int n = 0;
                        EMRandomDelay eMRandomDelay = new EMRandomDelay();
                        for (int i = 0; i < 3 && !(bl = EMPushHelper.this.sendTokenToServer(string)); ++i) {
                            try {
                                2.sleep(eMRandomDelay.timeDelay(n++) * 1000);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            if (!this.isInterrupted()) continue;
                            return;
                        }
                        if (bl) {
                            EMClient.getInstance().cancelJob();
                            EMClient.getInstance().doStopService();
                        } else {
                            EMPushHelper.this.setPushType(EMPushType.NORMAL);
                            EMClient.getInstance().doStopService();
                            EMClient.getInstance().doStartService();
                        }
                    }
                    catch (Exception exception) {
                        EMLog.e(TAG, exception.toString());
                    }
                    finally {
                        EMPushHelper.this.pushThread = null;
                    }
                }
            };
            this.pushThread.start();
        } else {
            EMLog.d(TAG, "third-party push not available");
        }
    }

    public void onDestroy(boolean bl) throws HyphenateException {
        EMLog.d(TAG, "push notification helper ondestory");
        this.onReceiveToken(null);
        if (this.pushThread != null) {
            this.pushThread.interrupt();
            this.pushThread = null;
        }
        this.isLogout = true;
        if (bl && this.isPushServiceEnabled()) {
            boolean bl2 = this.sendTokenToServer("");
            if (!bl2) {
                EMLog.d(TAG, "unbind device token faild");
                throw new HyphenateException(212, "unbind device token failed");
            }
            this.setPushType(EMPushType.NORMAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onReceiveToken(String string) {
        this.notifyDeviceToken = string;
        Object object = this.sendTokenLock;
        synchronized (object) {
            try {
                this.sendTokenLock.notify();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sendTokenToServer(String string) {
        Object object = this.sendTokenLock;
        synchronized (object) {
            String string2 = EMClient.getInstance().getChatConfigPrivate().f() + "/users/" + EMClient.getInstance().getCurrentUser();
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("device_token", (Object)string);
                String string3 = null;
                switch (this.pushType) {
                    case GCM: {
                        string3 = EMClient.getInstance().getOptions().getGCMNumber();
                        break;
                    }
                    case FCM: {
                        string3 = EMClient.getInstance().getOptions().getFCMNumber();
                        break;
                    }
                    case MIPUSH: {
                        string3 = EMClient.getInstance().getOptions().getMipushConfig().a;
                        break;
                    }
                    case HUAWEIPUSH: {
                        string3 = this.getHWAppId();
                    }
                }
                if (string3 == null) {
                    string3 = "";
                }
                jSONObject.put("notifier_name", (Object)string3);
                DeviceUuidFactory deviceUuidFactory = new DeviceUuidFactory(EMClient.getInstance().getContext());
                jSONObject.put("device_id", (Object)deviceUuidFactory.getDeviceUuid().toString());
                EMLog.d(TAG, "send device token to server, token = " + string + ",url = " + string2 + ",notifier_name = " + string3);
                Pair<Integer, String> pair = EMHttpClient.getInstance().sendRequestWithToken(string2, jSONObject.toString(), EMHttpClient.PUT);
                int n = (Integer)pair.first;
                String string4 = (String)pair.second;
                switch (n) {
                    case 200: {
                        EMLog.d(TAG, "sendTokenToServer SC_OK:");
                        return true;
                    }
                }
                EMLog.d(TAG, "sendTokenToServer error:" + string4);
            }
            catch (Exception exception) {
                EMLog.e(TAG, exception.toString());
            }
            return false;
        }
    }

    boolean sendDeviceInfo(String string) {
        String string2 = EMClient.getInstance().getChatConfigPrivate().f() + "/devices";
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("model", (Object)"android");
            jSONObject.put("name", (Object)string);
            jSONObject.put("token", (Object)string);
            jSONObject.put("sdk_version", (Object)EMClient.getInstance().getChatConfigPrivate().e());
            jSONObject.put("os_version", (Object)Build.VERSION.RELEASE);
            DeviceUuidFactory deviceUuidFactory = new DeviceUuidFactory(EMClient.getInstance().getContext());
            String string3 = deviceUuidFactory.getDeviceUuid().toString();
            jSONObject.put("device_uuid", (Object)string3);
            Pair<Integer, String> pair = EMHttpClient.getInstance().sendRequest(string2, null, jSONObject.toString(), EMHttpClient.POST);
            int n = (Integer)pair.first;
            String string4 = (String)pair.second;
            switch (n) {
                case 200: {
                    EMLog.d(TAG, "sendDeviceToServer SC_OK:");
                    this.setPushToken(string);
                    return true;
                }
            }
            if (string4.contains("duplicate_unique_property_exists")) {
                EMLog.d(TAG, "device token already exists");
                this.setPushToken(string);
                return true;
            }
            this.setPushToken(null);
            EMLog.d(TAG, "sendDeviceToServer error : " + string4);
        }
        catch (Exception exception) {
            EMLog.e(TAG, exception.toString());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getDeviceToken() {
        String string;
        block12: {
            string = this.getPushToken();
            if (string != null) {
                EMLog.d(TAG, "Device token already exist!");
                return string;
            }
            try {
                b.b b2;
                EMPushType eMPushType = this.getPushType();
                if (eMPushType == EMPushType.GCM) {
                    if (EMClient.getInstance().getOptions().getGCMNumber() != null) {
                        GoogleCloudMessaging googleCloudMessaging = null;
                        if (googleCloudMessaging == null) {
                            googleCloudMessaging = GoogleCloudMessaging.getInstance((Context)EMClient.getInstance().getContext());
                        }
                        string = googleCloudMessaging.register(new String[]{EMClient.getInstance().getOptions().getGCMNumber()});
                    }
                    break block12;
                }
                if (eMPushType != EMPushType.MIPUSH || (b2 = EMClient.getInstance().getOptions().getMipushConfig()) == null) break block12;
                MiPushClient.registerPush((Context)EMClient.getInstance().getContext(), (String)b2.a, (String)b2.b);
                Object object = this.sendTokenLock;
                synchronized (object) {
                    try {
                        this.sendTokenLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                string = this.notifyDeviceToken;
            }
            catch (Exception exception) {
                EMLog.e(TAG, "get device token with error: " + exception.toString());
            }
        }
        EMLog.d(TAG, "devicetoken = " + string);
        if (string == null || "".equals(string)) {
            this.setPushType(EMPushType.NORMAL);
        }
        return string;
    }

    public String getPushToken() {
        String string = e.a().m();
        if (!TextUtils.isEmpty((CharSequence)string) && !"3.4.1".equals(e.a().o())) {
            this.setPushToken(null);
            EMLog.d(TAG, "Reset device token!");
            return null;
        }
        return string;
    }

    public void setPushToken(String string) {
        e.a().f("3.4.1");
        e.a().d(string);
    }

    public String getFCMPushToken() {
        return e.a().n();
    }

    public void setFCMPushToken(String string) {
        e.a().e(string);
    }

    public void setHWAppId(String string) {
        e.a().g(string);
    }

    public String getHWAppId() {
        return e.a().p();
    }

    public void setHMSToken(String string) {
        e.a().h(string);
    }

    public String getHMSToken() {
        return e.a().q();
    }

    public static enum EMPushType {
        GCM,
        FCM,
        MIPUSH,
        HUAWEIPUSH,
        NORMAL;

    }
}

