/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat.adapter;

import android.util.Base64;
import com.hyphenate.util.EMLog;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class EMAREncryptUtils {
    public static final String TAG = "EMAREncryptUtils";
    Cipher cipher;
    Cipher decipher;

    public static byte[] generateAESKey() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(128);
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey.getEncoded();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return null;
        }
    }

    public void initAES(byte[] byArray) {
        this.initAEScbc(byArray);
    }

    public void unInitAES() {
    }

    public void initAESecb(byte[] byArray) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
            this.cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            this.cipher.init(1, secretKeySpec);
            this.decipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            this.decipher.init(2, secretKeySpec);
            EMLog.d("encrypt", "init for AES ecb");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            EMLog.d(TAG, exception.getStackTrace().toString());
        }
    }

    public void initAEScbc(byte[] byArray) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
            IvParameterSpec ivParameterSpec = new IvParameterSpec("0000000000000000".getBytes());
            IvParameterSpec ivParameterSpec2 = new IvParameterSpec("0000000000000000".getBytes());
            this.cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            this.cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            this.decipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            this.decipher.init(2, (Key)secretKeySpec, ivParameterSpec2);
            EMLog.d("encrypt", "init for AES cbc");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            EMLog.d(TAG, exception.getStackTrace().toString());
        }
    }

    public static String b64Encode(byte[] byArray, int n) {
        return Base64.encodeToString((byte[])byArray, (int)0, (int)byArray.length, (int)(n == B64_ENCODE_FLAG.ONESDK_B64_NO_WRAP.ordinal() ? 2 : 0));
    }

    public static byte[] b64Decode(String string) {
        return Base64.decode((String)string, (int)0);
    }

    public String aesEncrypt(String string, int n) {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            byte[] byArray2 = this.cipher.doFinal(byArray);
            return EMAREncryptUtils.b64Encode(byArray2, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            EMLog.d(TAG, exception.getStackTrace().toString());
            return null;
        }
    }

    public String aesDecrypt(String string) {
        try {
            byte[] byArray = EMAREncryptUtils.b64Decode(string);
            byte[] byArray2 = this.decipher.doFinal(byArray);
            return new String(byArray2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            EMLog.d(TAG, exception.getStackTrace().toString());
            return null;
        }
    }

    public byte[] aesEncryptInner(byte[] byArray) {
        try {
            return this.cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            EMLog.d(TAG, exception.getStackTrace().toString());
            return null;
        }
    }

    public byte[] aesDecryptInner(byte[] byArray) {
        try {
            return this.decipher.doFinal(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            EMLog.d(TAG, exception.getStackTrace().toString());
            return null;
        }
    }

    public static byte[] encryptByRSAPublicKey(String string, byte[] byArray, AtomicBoolean atomicBoolean) {
        String string2 = string;
        string2 = string2.replace("-----BEGIN PUBLIC KEY-----", "");
        string2 = string2.replace("-----END PUBLIC KEY-----", "");
        string2 = string2.replace("\n", "");
        byte[] byArray2 = Base64.decode((byte[])string2.getBytes(), (int)2);
        try {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray2);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            EMLog.d(TAG, "publicKey.getFormat:" + publicKey.getFormat());
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, publicKey);
            byte[] byArray3 = cipher.doFinal(byArray);
            atomicBoolean.set(true);
            return byArray3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            EMLog.d(TAG, exception.getStackTrace().toString());
            return null;
        }
    }

    public static String messageDigest(int n, byte[] byArray) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        byte[] byArray2 = messageDigest.digest(byArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray2.length; ++i) {
            int n2 = byArray2[i] & 0xFF;
            if (n2 < 16) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toHexString(n2));
        }
        return stringBuffer.toString();
    }

    static enum B64_ENCODE_FLAG {
        ONESDK_B64_DEFAULT,
        ONESDK_B64_NO_WRAP;

    }
}

