/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.util;

import android.content.Context;
import android.os.Environment;
import java.io.File;

public class PathUtil {
    public static String pathPrefix;
    public static final String historyPathName = "/chat/";
    public static final String imagePathName = "/image/";
    public static final String voicePathName = "/voice/";
    public static final String filePathName = "/file/";
    public static final String videoPathName = "/video/";
    public static final String netdiskDownloadPathName = "/netdisk/";
    public static final String meetingPathName = "/meeting/";
    private static File storageDir;
    private static PathUtil instance;
    private File voicePath = null;
    private File imagePath = null;
    private File historyPath = null;
    private File videoPath = null;
    private File filePath;

    private PathUtil() {
    }

    public static PathUtil getInstance() {
        if (instance == null) {
            instance = new PathUtil();
        }
        return instance;
    }

    public void initDirs(String string, String string2, Context context) {
        String string3 = context.getPackageName();
        pathPrefix = "/Android/data/" + string3 + "/";
        this.voicePath = PathUtil.generateVoicePath(string, string2, context);
        if (!this.voicePath.exists()) {
            this.voicePath.mkdirs();
        }
        this.imagePath = PathUtil.generateImagePath(string, string2, context);
        if (!this.imagePath.exists()) {
            this.imagePath.mkdirs();
        }
        this.historyPath = PathUtil.generateHistoryPath(string, string2, context);
        if (!this.historyPath.exists()) {
            this.historyPath.mkdirs();
        }
        this.videoPath = PathUtil.generateVideoPath(string, string2, context);
        if (!this.videoPath.exists()) {
            this.videoPath.mkdirs();
        }
        this.filePath = PathUtil.generateFiePath(string, string2, context);
        if (!this.filePath.exists()) {
            this.filePath.mkdirs();
        }
    }

    public File getImagePath() {
        return this.imagePath;
    }

    public File getVoicePath() {
        return this.voicePath;
    }

    public File getFilePath() {
        return this.filePath;
    }

    public File getVideoPath() {
        return this.videoPath;
    }

    public File getHistoryPath() {
        return this.historyPath;
    }

    private static File getStorageDir(Context context) {
        if (storageDir == null) {
            File file = Environment.getExternalStorageDirectory();
            if (file.exists()) {
                return file;
            }
            storageDir = context.getFilesDir();
        }
        return storageDir;
    }

    private static File generateImagePath(String string, String string2, Context context) {
        String string3 = null;
        string3 = string == null ? pathPrefix + string2 + imagePathName : pathPrefix + string + "/" + string2 + imagePathName;
        return new File(PathUtil.getStorageDir(context), string3);
    }

    private static File generateVoicePath(String string, String string2, Context context) {
        String string3 = null;
        string3 = string == null ? pathPrefix + string2 + voicePathName : pathPrefix + string + "/" + string2 + voicePathName;
        return new File(PathUtil.getStorageDir(context), string3);
    }

    private static File generateFiePath(String string, String string2, Context context) {
        String string3 = null;
        string3 = string == null ? pathPrefix + string2 + filePathName : pathPrefix + string + "/" + string2 + filePathName;
        return new File(PathUtil.getStorageDir(context), string3);
    }

    private static File generateVideoPath(String string, String string2, Context context) {
        String string3 = null;
        string3 = string == null ? pathPrefix + string2 + videoPathName : pathPrefix + string + "/" + string2 + videoPathName;
        return new File(PathUtil.getStorageDir(context), string3);
    }

    private static File generateHistoryPath(String string, String string2, Context context) {
        String string3 = null;
        string3 = string == null ? pathPrefix + string2 + historyPathName : pathPrefix + string + "/" + string2 + historyPathName;
        return new File(PathUtil.getStorageDir(context), string3);
    }

    public static File getTempPath(File file) {
        return new File(file.getAbsoluteFile() + ".tmp");
    }

    static {
        storageDir = null;
        instance = null;
    }
}

