/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.call;

import com.superrtc.call.MediaStreamTrack;

public class RtpSender {
    final long nativeRtpSender;
    private MediaStreamTrack cachedTrack;
    private boolean ownsTrack = true;

    public RtpSender(long nativeRtpSender) {
        this.nativeRtpSender = nativeRtpSender;
        long track = RtpSender.nativeGetTrack(nativeRtpSender);
        this.cachedTrack = track == 0L ? null : new MediaStreamTrack(track);
    }

    public boolean setTrack(MediaStreamTrack track, boolean takeOwnership) {
        if (!RtpSender.nativeSetTrack(this.nativeRtpSender, track == null ? 0L : track.nativeTrack)) {
            return false;
        }
        if (this.cachedTrack != null && this.ownsTrack) {
            this.cachedTrack.dispose();
        }
        this.cachedTrack = track;
        this.ownsTrack = takeOwnership;
        return true;
    }

    public MediaStreamTrack track() {
        return this.cachedTrack;
    }

    public String id() {
        return RtpSender.nativeId(this.nativeRtpSender);
    }

    public void dispose() {
        if (this.cachedTrack != null && this.ownsTrack) {
            this.cachedTrack.dispose();
        }
        RtpSender.free(this.nativeRtpSender);
    }

    private static native boolean nativeSetTrack(long var0, long var2);

    private static native long nativeGetTrack(long var0);

    private static native String nativeId(long var0);

    private static native void free(long var0);
}

