/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.call;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.Camera;
import android.os.Environment;
import android.os.Handler;
import android.os.SystemClock;
import android.util.Log;
import android.view.WindowManager;
import com.superrtc.call.CameraEnumerationAndroid;
import com.superrtc.call.EglBase;
import com.superrtc.call.Logging;
import com.superrtc.call.RendererCommon;
import com.superrtc.call.SurfaceTextureHelper;
import com.superrtc.call.ThreadUtils;
import com.superrtc.call.VideoCapturer;
import com.superrtc.sdk.RtcListener;
import com.superrtc.util.RTCCallback;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class VideoCapturerAndroid
implements VideoCapturer,
Camera.PreviewCallback,
SurfaceTextureHelper.OnTextureFrameAvailableListener {
    private static final String TAG = "VideoCapturerAndroid";
    private static final int CAMERA_OBSERVER_PERIOD_MS = 2000;
    private static final int CAMERA_FREEZE_REPORT_TIMOUT_MS = 4000;
    private Camera camera;
    private Thread cameraThread;
    private final Handler cameraThreadHandler;
    private Context applicationContext;
    private final Object cameraIdLock = new Object();
    private int id;
    private Camera.CameraInfo info;
    private final CameraStatistics cameraStatistics;
    private int requestedWidth;
    private int requestedHeight;
    private int requestedFramerate;
    private CameraEnumerationAndroid.CaptureFormat captureFormat;
    private final Object pendingCameraSwitchLock = new Object();
    private volatile boolean pendingCameraSwitch;
    private VideoCapturer.CapturerObserver frameObserver = null;
    private final CameraEventsHandler eventsHandler;
    private boolean firstFrameReported;
    private static final int NUMBER_OF_CAPTURE_BUFFERS = 3;
    private final Set<byte[]> queuedBuffers = new HashSet<byte[]>();
    private final boolean isCapturingToTexture;
    final SurfaceTextureHelper surfaceHelper;
    private boolean dropNextFrame = false;
    private Runnable openCameraOnCodecThreadRunner;
    private static final int MAX_OPEN_CAMERA_ATTEMPTS = 3;
    private static final int OPEN_CAMERA_DELAY_MS = 500;
    private int openCameraAttempts;
    private boolean enableCamera = true;
    private boolean supportedCamraFormats = true;
    private VideoCapturerDataProcessor dataprocessor;
    private GlTextureProcessor textureProcessor;
    private boolean enableExternalVideoData;
    private boolean isStartvideo;
    private int configRotation = 0;
    private boolean isconfigRotation = false;
    private int lastSetCameraMagnification = 0;
    private final Camera.ErrorCallback cameraErrorCallback = new Camera.ErrorCallback(){

        public void onError(int error, Camera camera) {
            String errorMessage = error == 100 ? "Camera server died!" : "Camera error: " + error;
            Logging.e(VideoCapturerAndroid.TAG, errorMessage);
            if (VideoCapturerAndroid.this.eventsHandler != null) {
                VideoCapturerAndroid.this.eventsHandler.onCameraError(errorMessage);
            }
        }
    };
    private final Runnable cameraObserver = new Runnable(){
        private int freezePeriodCount;

        @Override
        public void run() {
            int cameraFramesCount = VideoCapturerAndroid.this.cameraStatistics.getAndResetFrameCount();
            int cameraFps = (cameraFramesCount * 1000 + 1000) / 2000;
            Logging.d(VideoCapturerAndroid.TAG, "Camera fps: " + cameraFps + ".");
            if (cameraFramesCount == 0) {
                ++this.freezePeriodCount;
                if (2000 * this.freezePeriodCount >= 4000 && VideoCapturerAndroid.this.eventsHandler != null) {
                    Logging.e(VideoCapturerAndroid.TAG, "Camera freezed.");
                    if (VideoCapturerAndroid.this.surfaceHelper.isTextureInUse()) {
                        VideoCapturerAndroid.this.eventsHandler.onCameraFreezed("Camera failure. Client must return video buffers.");
                    } else {
                        VideoCapturerAndroid.this.eventsHandler.onCameraFreezed("Camera failure.");
                    }
                    return;
                }
            } else {
                this.freezePeriodCount = 0;
            }
            VideoCapturerAndroid.this.cameraThreadHandler.postDelayed((Runnable)this, 2000L);
        }
    };
    private RtcListener rtcListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCameraDataProcessor(VideoCapturerDataProcessor dataprocessor) {
        if (this.dataprocessor != null) {
            VideoCapturerDataProcessor videoCapturerDataProcessor = this.dataprocessor;
            synchronized (videoCapturerDataProcessor) {
                this.dataprocessor = dataprocessor;
            }
        } else {
            this.dataprocessor = dataprocessor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGlTextureProcessor(GlTextureProcessor textureProcessor) {
        if (this.textureProcessor != null) {
            GlTextureProcessor glTextureProcessor = this.textureProcessor;
            synchronized (glTextureProcessor) {
                this.textureProcessor = textureProcessor;
            }
        } else {
            this.textureProcessor = textureProcessor;
        }
    }

    public void setEnableExternalVideoData(boolean enable) {
        this.enableExternalVideoData = enable;
    }

    public void setRotation(int rotation) {
        this.isconfigRotation = true;
        this.configRotation = rotation;
    }

    public CameraEnumerationAndroid.CaptureFormat getCaptureFormat() {
        return this.captureFormat;
    }

    public static VideoCapturerAndroid create(String name, CameraEventsHandler eventsHandler) {
        return VideoCapturerAndroid.create(name, eventsHandler, null);
    }

    public static VideoCapturerAndroid create(String name, CameraEventsHandler eventsHandler, EglBase.Context sharedEglContext) {
        int cameraId = VideoCapturerAndroid.lookupDeviceName(name);
        if (cameraId == -1) {
            return null;
        }
        return new VideoCapturerAndroid(cameraId, eventsHandler, sharedEglContext);
    }

    public void printStackTrace() {
        StackTraceElement[] cameraStackTraces;
        if (this.cameraThread != null && (cameraStackTraces = this.cameraThread.getStackTrace()).length > 0) {
            Logging.d(TAG, "VideoCapturerAndroid stacks trace:");
            for (StackTraceElement stackTrace : cameraStackTraces) {
                Logging.d(TAG, stackTrace.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchCamera(final CameraSwitchHandler handler) {
        if (this.enableExternalVideoData) {
            return;
        }
        if (Camera.getNumberOfCameras() < 2) {
            if (handler != null) {
                handler.onCameraSwitchError("No camera to switch to.");
            }
            return;
        }
        Object object = this.pendingCameraSwitchLock;
        synchronized (object) {
            if (this.pendingCameraSwitch) {
                Logging.w(TAG, "Ignoring camera switch request.");
                if (handler != null) {
                    handler.onCameraSwitchError("Pending camera switch already in progress.");
                }
                return;
            }
            this.pendingCameraSwitch = true;
        }
        this.cameraThreadHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (VideoCapturerAndroid.this.camera == null) {
                    if (handler != null) {
                        handler.onCameraSwitchError("Camera is stopped.");
                    }
                    return;
                }
                VideoCapturerAndroid.this.switchCameraOnCameraThread();
                Object object = VideoCapturerAndroid.this.pendingCameraSwitchLock;
                synchronized (object) {
                    VideoCapturerAndroid.this.pendingCameraSwitch = false;
                }
                if (handler != null) {
                    handler.onCameraSwitchDone(((VideoCapturerAndroid)VideoCapturerAndroid.this).info.facing == 1);
                }
            }
        });
    }

    public void onOutputFormatRequest(final int width, final int height, final int framerate) {
        this.cameraThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (VideoCapturerAndroid.this.enableExternalVideoData) {
                    return;
                }
                VideoCapturerAndroid.this.onOutputFormatRequestOnCameraThread(width, height, framerate);
            }
        });
    }

    public void changeCaptureFormat(final int width, final int height, final int framerate) {
        this.cameraThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (VideoCapturerAndroid.this.enableExternalVideoData) {
                    return;
                }
                VideoCapturerAndroid.this.startPreviewOnCameraThread(width, height, framerate);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentCameraId() {
        Object object = this.cameraIdLock;
        synchronized (object) {
            return this.id;
        }
    }

    @Override
    public List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats() {
        return CameraEnumerationAndroid.getSupportedFormats(this.getCurrentCameraId());
    }

    public boolean isCapturingToTexture() {
        return this.isCapturingToTexture;
    }

    @Override
    public SurfaceTextureHelper getSurfaceTextureHelper() {
        return this.surfaceHelper;
    }

    private VideoCapturerAndroid(int cameraId, CameraEventsHandler eventsHandler, EglBase.Context sharedContext) {
        this.id = cameraId;
        this.eventsHandler = eventsHandler;
        this.isCapturingToTexture = sharedContext != null;
        this.cameraStatistics = new CameraStatistics();
        this.surfaceHelper = SurfaceTextureHelper.create(sharedContext);
        this.cameraThreadHandler = this.surfaceHelper.getHandler();
        this.cameraThread = this.cameraThreadHandler.getLooper().getThread();
        Logging.d(TAG, "VideoCapturerAndroid isCapturingToTexture : " + this.isCapturingToTexture);
    }

    private void checkIsOnCameraThread() {
        if (Thread.currentThread() != this.cameraThread) {
            throw new IllegalStateException("Wrong thread");
        }
    }

    private static int lookupDeviceName(String deviceName) {
        Logging.d(TAG, "lookupDeviceName: " + deviceName);
        if (deviceName == null || Camera.getNumberOfCameras() == 0) {
            return -1;
        }
        if (deviceName.isEmpty()) {
            return 0;
        }
        for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
            if (!deviceName.equals(CameraEnumerationAndroid.getDeviceName(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void dispose() {
        Logging.d(TAG, "release");
        if (this.isDisposed()) {
            throw new IllegalStateException("Already released");
        }
        ThreadUtils.invokeUninterruptibly(this.cameraThreadHandler, new Runnable(){

            @Override
            public void run() {
                if (VideoCapturerAndroid.this.camera != null) {
                    throw new IllegalStateException("Release called while camera is running");
                }
            }
        });
        this.surfaceHelper.dispose();
        this.cameraThread = null;
    }

    public boolean isDisposed() {
        return this.cameraThread == null;
    }

    @Override
    public boolean getSupportedGetCameraFormats() {
        return this.supportedCamraFormats;
    }

    @Override
    public void startCapture(final int width, final int height, final int framerate, final Context applicationContext, final VideoCapturer.CapturerObserver frameObserver) {
        Logging.d(TAG, "startCapture requested: " + width + "x" + height + "@" + framerate);
        if (applicationContext == null) {
            throw new RuntimeException("applicationContext not set.");
        }
        if (frameObserver == null) {
            throw new RuntimeException("frameObserver not set.");
        }
        this.cameraThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                VideoCapturerAndroid.this.startCaptureOnCameraThread(width, height, framerate, frameObserver, applicationContext);
            }
        });
    }

    public void setEnableCameragetsuppoted(boolean enable) {
        this.supportedCamraFormats = enable;
    }

    public void setEnableCamera(boolean enable) {
        this.enableCamera = enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCaptureOnCameraThread(final int width, final int height, final int framerate, final VideoCapturer.CapturerObserver frameObserver, final Context applicationContext) {
        RuntimeException error = null;
        this.checkIsOnCameraThread();
        if (this.camera != null) {
            throw new RuntimeException("Camera has already been started.");
        }
        this.applicationContext = applicationContext;
        this.frameObserver = frameObserver;
        this.firstFrameReported = false;
        this.requestedWidth = width;
        this.requestedHeight = height;
        this.requestedFramerate = framerate;
        this.isStartvideo = true;
        if (!this.enableCamera) {
            return;
        }
        if (this.enableExternalVideoData) {
            return;
        }
        try {
            try {
                Object object = this.cameraIdLock;
                synchronized (object) {
                    if (this.eventsHandler != null) {
                        this.eventsHandler.onCameraOpening(this.id);
                    }
                    this.camera = Camera.open((int)this.id);
                    this.info = new Camera.CameraInfo();
                    Camera.getCameraInfo((int)this.id, (Camera.CameraInfo)this.info);
                }
            }
            catch (RuntimeException e2) {
                this.openCameraFail();
                ++this.openCameraAttempts;
                if (this.openCameraAttempts < 3) {
                    Logging.e(TAG, "Camera.open failed, retrying", e2);
                    this.openCameraOnCodecThreadRunner = new Runnable(){

                        @Override
                        public void run() {
                            VideoCapturerAndroid.this.startCaptureOnCameraThread(width, height, framerate, frameObserver, applicationContext);
                        }
                    };
                    this.cameraThreadHandler.postDelayed(this.openCameraOnCodecThreadRunner, 500L);
                    return;
                }
                this.openCameraAttempts = 0;
                throw e2;
            }
            try {
                this.camera.setPreviewTexture(this.surfaceHelper.getSurfaceTexture());
            }
            catch (IOException e3) {
                Logging.e(TAG, "setPreviewTexture failed", error);
                throw new RuntimeException(e3);
            }
            Logging.e(TAG, "Camera orientation: " + this.info.orientation + " .Device orientation: " + this.getDeviceOrientation());
            this.camera.setErrorCallback(this.cameraErrorCallback);
            this.startPreviewOnCameraThread(width, height, framerate);
            frameObserver.onCapturerStarted(true);
            if (this.isCapturingToTexture) {
                this.surfaceHelper.startListening(this);
            }
            this.cameraThreadHandler.postDelayed(this.cameraObserver, 2000L);
            return;
        }
        catch (RuntimeException e4) {
            error = e4;
            Logging.e(TAG, "startCapture failed", error);
            this.stopCaptureOnCameraThread();
            frameObserver.onCapturerStarted(false);
            if (this.eventsHandler != null) {
                this.eventsHandler.onCameraError("Camera can not be started.");
            }
            return;
        }
    }

    private void startPreviewOnCameraThread(int width, int height, int framerate) {
        this.checkIsOnCameraThread();
        Logging.d(TAG, "startPreviewOnCameraThread requested: " + width + "x" + height + "@" + framerate);
        if (this.camera == null) {
            Logging.e(TAG, "Calling startPreviewOnCameraThread on stopped camera.");
            return;
        }
        this.requestedWidth = width;
        this.requestedHeight = height;
        this.requestedFramerate = framerate;
        Camera.Parameters parameters = this.camera.getParameters();
        int[] range = CameraEnumerationAndroid.getFramerateRange(parameters, framerate * 1000);
        Camera.Size previewSize = CameraEnumerationAndroid.getClosestSupportedSize(parameters.getSupportedPreviewSizes(), width, height);
        CameraEnumerationAndroid.CaptureFormat captureFormat = new CameraEnumerationAndroid.CaptureFormat(previewSize.width, previewSize.height, range[0], range[1]);
        if (captureFormat.isSameFormat(this.captureFormat)) {
            return;
        }
        Logging.d(TAG, "isVideoStabilizationSupported: " + parameters.isVideoStabilizationSupported());
        if (parameters.isVideoStabilizationSupported()) {
            parameters.setVideoStabilization(true);
        }
        if (captureFormat.maxFramerate > 0) {
            parameters.setPreviewFpsRange(captureFormat.minFramerate, captureFormat.maxFramerate);
        }
        parameters.setPreviewSize(captureFormat.width, captureFormat.height);
        if (!this.isCapturingToTexture) {
            parameters.setPreviewFormat(captureFormat.imageFormat);
        }
        Camera.Size pictureSize = CameraEnumerationAndroid.getClosestSupportedSize(parameters.getSupportedPictureSizes(), width, height);
        parameters.setPictureSize(pictureSize.width, pictureSize.height);
        if (this.captureFormat != null) {
            this.camera.stopPreview();
            this.dropNextFrame = true;
            this.camera.setPreviewCallbackWithBuffer(null);
        }
        Logging.e(TAG, "Start capturing: " + captureFormat);
        this.captureFormat = captureFormat;
        List focusModes = parameters.getSupportedFocusModes();
        if (focusModes.contains("continuous-video")) {
            parameters.setFocusMode("continuous-video");
        }
        this.camera.setParameters(parameters);
        if (!this.isCapturingToTexture) {
            this.queuedBuffers.clear();
            int frameSize = captureFormat.frameSize();
            for (int i = 0; i < 3; ++i) {
                ByteBuffer buffer = ByteBuffer.allocateDirect(frameSize);
                this.queuedBuffers.add(buffer.array());
                this.camera.addCallbackBuffer(buffer.array());
            }
            this.camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
        }
        this.camera.startPreview();
    }

    @Override
    public void stopCapture() throws InterruptedException {
        Logging.d(TAG, "stopCapture");
        final CountDownLatch barrier = new CountDownLatch(1);
        this.cameraThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                VideoCapturerAndroid.this.stopCaptureOnCameraThread();
                barrier.countDown();
            }
        });
        barrier.await();
        Logging.d(TAG, "stopCapture done");
    }

    private void stopCaptureOnCameraThread() {
        this.checkIsOnCameraThread();
        Logging.d(TAG, "stopCaptureOnCameraThread");
        if (this.openCameraOnCodecThreadRunner != null) {
            this.cameraThreadHandler.removeCallbacks(this.openCameraOnCodecThreadRunner);
        }
        this.openCameraAttempts = 0;
        if (this.camera == null) {
            Logging.e(TAG, "Calling stopCapture() for already stopped camera.");
            return;
        }
        this.surfaceHelper.stopListening();
        this.cameraThreadHandler.removeCallbacks(this.cameraObserver);
        this.cameraStatistics.getAndResetFrameCount();
        Logging.d(TAG, "Stop preview.");
        if (this.enableExternalVideoData) {
            return;
        }
        this.camera.stopPreview();
        this.camera.setPreviewCallbackWithBuffer(null);
        this.queuedBuffers.clear();
        this.captureFormat = null;
        Logging.d(TAG, "Release camera.");
        this.camera.release();
        this.camera = null;
        if (this.eventsHandler != null) {
            this.eventsHandler.onCameraClosed();
        }
    }

    public void enableCameraThread() {
        if (this.enableCamera) {
            return;
        }
        this.enableCamera = true;
        Logging.d(TAG, "enableCameraThread");
        this.cameraThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                VideoCapturerAndroid.this.startCaptureOnCameraThread(VideoCapturerAndroid.this.requestedWidth, VideoCapturerAndroid.this.requestedHeight, VideoCapturerAndroid.this.requestedFramerate, VideoCapturerAndroid.this.frameObserver, VideoCapturerAndroid.this.applicationContext);
            }
        });
        Logging.d(TAG, "enableCameraThread done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchCameraOnCameraThread() {
        this.checkIsOnCameraThread();
        Logging.d(TAG, "switchCameraOnCameraThread");
        this.stopCaptureOnCameraThread();
        Object object = this.cameraIdLock;
        synchronized (object) {
            this.id = (this.id + 1) % Camera.getNumberOfCameras();
        }
        this.dropNextFrame = true;
        this.startCaptureOnCameraThread(this.requestedWidth, this.requestedHeight, this.requestedFramerate, this.frameObserver, this.applicationContext);
        Logging.d(TAG, "switchCameraOnCameraThread done");
    }

    private void onOutputFormatRequestOnCameraThread(int width, int height, int framerate) {
        this.checkIsOnCameraThread();
        if (this.camera == null) {
            Logging.e(TAG, "Calling onOutputFormatRequest() on stopped camera.");
            return;
        }
        Logging.d(TAG, "onOutputFormatRequestOnCameraThread: " + width + "x" + height + "@" + framerate);
        this.frameObserver.onOutputFormatRequest(width, height, framerate);
    }

    Handler getCameraThreadHandler() {
        return this.cameraThreadHandler;
    }

    private int getDeviceOrientation() {
        int orientation = 0;
        WindowManager wm = (WindowManager)this.applicationContext.getSystemService("window");
        switch (wm.getDefaultDisplay().getRotation()) {
            case 1: {
                orientation = 90;
                break;
            }
            case 2: {
                orientation = 180;
                break;
            }
            case 3: {
                orientation = 270;
                break;
            }
            default: {
                orientation = 0;
            }
        }
        return orientation;
    }

    private int getFrameOrientation() {
        int rotation = this.getDeviceOrientation();
        if (this.info.facing == 0) {
            rotation = 360 - rotation;
        }
        return (this.info.orientation + rotation) % 360;
    }

    public void handleZoom(Float isZoomIn) {
        Camera.Parameters params;
        if (this.camera == null) {
            Logging.e(TAG, "camera is not Initialized");
        }
        if ((params = this.camera.getParameters()).isZoomSupported()) {
            int maxZoom = params.getMaxZoom();
            int zoom = params.getZoom();
            int zoomset = isZoomIn.intValue();
            Logging.e(TAG, "handleZoom curzoom:" + zoom + ",last:" + this.lastSetCameraMagnification + " ,factor:" + zoomset);
            zoom = this.lastSetCameraMagnification == 0 ? (zoom *= zoomset) : (this.lastSetCameraMagnification < zoomset ? (zoom *= zoomset / this.lastSetCameraMagnification) : (zoom /= this.lastSetCameraMagnification / zoomset));
            if (zoom > maxZoom) {
                zoom = maxZoom;
            } else if (zoom < 1) {
                zoom = 1;
            }
            params.setZoom(zoom);
            this.camera.setParameters(params);
            this.lastSetCameraMagnification = isZoomIn.intValue();
        } else {
            Logging.e(TAG, "zoom not supported");
        }
    }

    private void transformingPosition(int[] x, int[] y, int[] width, int[] height) {
        int rotation = this.getFrameOrientation();
        if (this.info.facing == 0) {
            if (rotation == 0) {
                x[0] = width[0] * x[0] / 10000;
                y[0] = y[0] * height[0] / 10000;
            } else if (rotation == 90) {
                int temp = width[0];
                width[0] = height[0];
                height[0] = temp;
                temp = x[0];
                x[0] = y[0] * width[0] / 10000;
                y[0] = (10000 - temp) * height[0] / 10000;
            } else if (rotation == 180) {
                x[0] = (10000 - x[0]) * width[0] / 10000;
                y[0] = (10000 - y[0]) * height[0] / 10000;
            } else if (rotation == 270) {
                int temp = width[0];
                width[0] = height[0];
                height[0] = temp;
                temp = x[0];
                x[0] = (10000 - y[0]) * width[0] / 10000;
                y[0] = temp * height[0] / 10000;
            }
        } else if (rotation == 0) {
            x[0] = x[0] * width[0] / 10000;
            y[0] = y[0] * height[0] / 10000;
        } else if (rotation == 90) {
            int temp = width[0];
            width[0] = height[0];
            height[0] = temp;
            temp = x[0];
            x[0] = y[0] * width[0] / 10000;
            y[0] = (10000 - temp) * height[0] / 10000;
        } else if (rotation == 180) {
            x[0] = (10000 - x[0]) * width[0] / 10000;
            y[0] = (10000 - y[0]) * height[0] / 10000;
        } else if (rotation == 270) {
            int temp = width[0];
            width[0] = height[0];
            height[0] = temp;
            temp = x[0];
            x[0] = (10000 - y[0]) * width[0] / 10000;
            y[0] = temp * height[0] / 10000;
        }
    }

    public void handleFocusMetering(int x, int y, int width, int height, int focus, int exposure) {
        int[] wx = new int[]{x};
        int[] hy = new int[]{y};
        int[] widthx = new int[]{width};
        int[] heighty = new int[]{height};
        this.transformingPosition(wx, hy, widthx, heighty);
        x = wx[0];
        y = hy[0];
        width = widthx[0];
        height = heighty[0];
        Logging.e(TAG, "remote focus x:" + x + ", y:" + y + ",width:" + width + ", height:" + height);
        Rect focusRect = VideoCapturerAndroid.calculateTapArea(x, y, 1.0f, width, height);
        Rect meteringRect = VideoCapturerAndroid.calculateTapArea(x, y, 1.5f, width, height);
        Camera.Parameters params = this.camera.getParameters();
        final String currentFocusMode = params.getFocusMode();
        if (params.getMaxNumFocusAreas() > 0) {
            this.camera.cancelAutoFocus();
            ArrayList<Camera.Area> focusAreas = new ArrayList<Camera.Area>();
            focusAreas.add(new Camera.Area(focusRect, 800));
            params.setFocusAreas(focusAreas);
        } else {
            Logging.e(TAG, "focus areas not supported");
        }
        if (params.getMaxNumMeteringAreas() > 0) {
            ArrayList<Camera.Area> meteringAreas = new ArrayList<Camera.Area>();
            meteringAreas.add(new Camera.Area(meteringRect, 800));
            params.setMeteringAreas(meteringAreas);
        } else {
            Logging.e(TAG, "metering areas not supported");
        }
        this.camera.setParameters(params);
        this.camera.autoFocus(new Camera.AutoFocusCallback(){

            public void onAutoFocus(boolean success, Camera camera) {
                Logging.e(VideoCapturerAndroid.TAG, "onAutoFocus ok");
                Camera.Parameters params = camera.getParameters();
                params.setFocusMode(currentFocusMode);
                camera.setParameters(params);
            }
        });
    }

    private static Rect calculateTapArea(float x, float y, float coefficient, int width, int height) {
        float focusAreaSize = 300.0f;
        int areaSize = Float.valueOf(focusAreaSize * coefficient).intValue();
        int centerX = (int)(x / (float)width * 2000.0f - 1000.0f);
        int centerY = (int)(y / (float)height * 2000.0f - 1000.0f);
        int halfAreaSize = areaSize / 2;
        RectF rectF = new RectF((float)VideoCapturerAndroid.clamp(centerX - halfAreaSize, -1000, 1000), (float)VideoCapturerAndroid.clamp(centerY - halfAreaSize, -1000, 1000), (float)VideoCapturerAndroid.clamp(centerX + halfAreaSize, -1000, 1000), (float)VideoCapturerAndroid.clamp(centerY + halfAreaSize, -1000, 1000));
        return new Rect(Math.round(rectF.left), Math.round(rectF.top), Math.round(rectF.right), Math.round(rectF.bottom));
    }

    private static int clamp(int x, int min, int max) {
        if (x > max) {
            return max;
        }
        if (x < min) {
            return min;
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPreviewFrame(byte[] data, Camera callbackCamera) {
        this.checkIsOnCameraThread();
        if (this.camera == null || !this.queuedBuffers.contains(data)) {
            return;
        }
        if (this.camera != callbackCamera) {
            throw new RuntimeException("Unexpected camera in callback!");
        }
        long captureTimeNs = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
        if (this.eventsHandler != null && !this.firstFrameReported) {
            this.eventsHandler.onFirstFrameAvailable();
            this.firstFrameReported = true;
        }
        this.cameraStatistics.addFrame();
        int rotation = this.getFrameOrientation();
        if (this.dataprocessor != null) {
            VideoCapturerDataProcessor videoCapturerDataProcessor = this.dataprocessor;
            synchronized (videoCapturerDataProcessor) {
                this.dataprocessor.onProcessData(data, callbackCamera, this.captureFormat.width, this.captureFormat.height, rotation);
            }
        }
        if (this.isconfigRotation) {
            rotation = this.configRotation;
        }
        this.frameObserver.onByteBufferFrameCaptured(data, this.captureFormat.width, this.captureFormat.height, rotation, captureTimeNs);
        this.camera.addCallbackBuffer(data);
    }

    public void inputExternalVideoData(byte[] data, int width, int height, int rotation) {
        if (!this.isStartvideo || !this.enableExternalVideoData) {
            return;
        }
        long captureTimeNs = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
        if (this.eventsHandler != null && !this.firstFrameReported) {
            this.eventsHandler.onFirstFrameAvailable();
            this.firstFrameReported = true;
        }
        this.cameraStatistics.addFrame();
        if (this.frameObserver != null) {
            this.frameObserver.onByteBufferFrameCaptured(data, width, height, rotation, captureTimeNs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTextureFrameAvailable(int oesTextureId, float[] transformMatrix, long timestampNs) {
        if (this.camera == null) {
            throw new RuntimeException("onTextureFrameAvailable() called after stopCapture().");
        }
        this.checkIsOnCameraThread();
        if (this.dropNextFrame) {
            this.surfaceHelper.returnTextureFrame();
            this.dropNextFrame = false;
            return;
        }
        if (this.eventsHandler != null && !this.firstFrameReported) {
            this.eventsHandler.onFirstFrameAvailable();
            this.firstFrameReported = true;
        }
        int rotation = this.getFrameOrientation();
        if (this.info.facing == 1) {
            transformMatrix = RendererCommon.multiplyMatrices(transformMatrix, RendererCommon.horizontalFlipMatrix());
        }
        if (this.textureProcessor != null) {
            GlTextureProcessor glTextureProcessor = this.textureProcessor;
            synchronized (glTextureProcessor) {
                this.textureProcessor.onDrawFrame(oesTextureId, this.captureFormat.width, this.captureFormat.height, transformMatrix, rotation);
            }
        }
        this.cameraStatistics.addFrame();
        this.frameObserver.onTextureFrameCaptured(this.captureFormat.width, this.captureFormat.height, oesTextureId, transformMatrix, rotation, timestampNs);
    }

    public void handleManualFocus(float x, float y, int width, int height, int viewW, int viewH) {
        if (this.camera == null) {
            Logging.e(TAG, "camera is not Initialized");
            return;
        }
        int[] wx = new int[]{(int)x};
        int[] hy = new int[]{(int)y};
        int[] widthx = new int[]{width};
        int[] heighty = new int[]{height};
        this.transformPosition(wx, hy, widthx, heighty, viewW, viewH);
        x = wx[0];
        y = hy[0];
        width = widthx[0];
        height = heighty[0];
        Logging.e(TAG, "Manual focus x:" + x + ", y:" + y + ", width:" + width + ", height:" + height);
        Rect focusRect = VideoCapturerAndroid.calculateTapArea(x, y, 1.0f, width, height);
        Rect meteringRect = VideoCapturerAndroid.calculateTapArea(x, y, 1.5f, width, height);
        Camera.Parameters params = this.camera.getParameters();
        final String currentFocusMode = params.getFocusMode();
        if (params.getMaxNumFocusAreas() > 0) {
            this.camera.cancelAutoFocus();
            ArrayList<Camera.Area> focusAreas = new ArrayList<Camera.Area>();
            focusAreas.add(new Camera.Area(focusRect, 800));
            params.setFocusAreas(focusAreas);
        } else {
            Logging.e(TAG, "focus areas not supported");
        }
        if (params.getMaxNumMeteringAreas() > 0) {
            ArrayList<Camera.Area> meteringAreas = new ArrayList<Camera.Area>();
            meteringAreas.add(new Camera.Area(meteringRect, 800));
            params.setMeteringAreas(meteringAreas);
        } else {
            Logging.e(TAG, "metering areas not supported");
        }
        this.camera.setParameters(params);
        this.camera.autoFocus(new Camera.AutoFocusCallback(){

            public void onAutoFocus(boolean success, Camera camera) {
                Logging.e(VideoCapturerAndroid.TAG, "onAutoFocus ok");
                Camera.Parameters params = camera.getParameters();
                params.setFocusMode(currentFocusMode);
                camera.setParameters(params);
            }
        });
    }

    private void transformPosition(int[] x, int[] y, int[] width, int[] height, int viewW, int viewH) {
        int rotation = this.getFrameOrientation();
        if (this.info.facing == 1) {
            x[0] = viewW - x[0];
            if (rotation == 0) {
                x[0] = width[0] * x[0] / viewW;
                y[0] = y[0] * height[0] / viewH;
            } else if (rotation == 90) {
                int temp = width[0];
                width[0] = height[0];
                height[0] = temp;
                temp = x[0];
                x[0] = y[0] * width[0] / viewW;
                y[0] = (viewW - temp) * height[0] / viewH;
            } else if (rotation == 180) {
                x[0] = (viewW - x[0]) * width[0] / viewW;
                y[0] = (viewH - y[0]) * height[0] / viewH;
            } else if (rotation == 270) {
                int temp = width[0];
                width[0] = height[0];
                height[0] = temp;
                temp = x[0];
                x[0] = (viewH - y[0]) * width[0] / viewW;
                y[0] = temp * height[0] / viewH;
            }
        } else if (rotation == 0) {
            x[0] = x[0] * width[0] / viewW;
            y[0] = y[0] * height[0] / viewH;
        } else if (rotation == 90) {
            int temp = width[0];
            width[0] = height[0];
            height[0] = temp;
            temp = x[0];
            x[0] = y[0] * width[0] / viewW;
            y[0] = (viewW - temp) * height[0] / viewH;
        } else if (rotation == 180) {
            x[0] = (viewW - x[0]) * width[0] / viewW;
            y[0] = (viewH - y[0]) * height[0] / viewH;
        } else if (rotation == 270) {
            int temp = width[0];
            width[0] = height[0];
            height[0] = temp;
            temp = x[0];
            x[0] = (viewW - y[0]) * width[0] / viewW;
            y[0] = temp * height[0] / viewH;
        }
    }

    public void handleManualZoom(boolean isZoomIn, int zoomScale) {
        if (this.camera == null) {
            Logging.e(TAG, "camera is not Initialized");
            return;
        }
        Camera.Parameters parameters = this.camera.getParameters();
        if (parameters.isZoomSupported()) {
            int maxZoom = parameters.getMaxZoom();
            int zoom = parameters.getZoom();
            zoom = isZoomIn ? (zoom += zoomScale) : (zoom -= zoomScale);
            Logging.e(TAG, String.format("zoom camera max:%s, zoom:%s, scale:%s", maxZoom, zoom, zoomScale));
            if (zoom > maxZoom) {
                zoom = maxZoom;
            } else if (zoom < 0) {
                zoom = 0;
            }
            parameters.setZoom(zoom);
            this.camera.setParameters(parameters);
        } else {
            Logging.e(TAG, "zoom not supported");
        }
    }

    public void handleFlashLight(boolean isOpen) {
        if (this.camera == null) {
            Logging.e(TAG, "camera is not Initialized");
            return;
        }
        Camera.Parameters parameters = this.camera.getParameters();
        if (isOpen) {
            parameters.setFlashMode("torch");
        } else {
            parameters.setFlashMode("off");
        }
        this.camera.setParameters(parameters);
    }

    public void setRtcListener(RtcListener listener) {
        this.rtcListener = listener;
    }

    private void openCameraFail() {
        if (this.rtcListener != null) {
            this.rtcListener.onError(RtcListener.RTCError.OPEN_CAMERA_FAIL);
        }
    }

    public void takeCameraPicture(final RTCCallback callback) {
        Log.d((String)TAG, (String)"takeCameraPicture -- start -1-");
        if (this.camera != null) {
            this.camera.takePicture(new Camera.ShutterCallback(){

                public void onShutter() {
                    Logging.d("ShutterCallback", "...onShutter...");
                }
            }, null, new Camera.PictureCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onPictureTaken(byte[] data, Camera camera) {
                    Log.d((String)VideoCapturerAndroid.TAG, (String)"takeCameraPicture -- start -2-");
                    Logging.d(VideoCapturerAndroid.TAG, "takeCameraPicture -- onPictureTaken start --");
                    int rotation = VideoCapturerAndroid.this.getFrameOrientation();
                    String filepath = Environment.getExternalStorageState().equals("mounted") ? VideoCapturerAndroid.this.applicationContext.getExternalFilesDir("").getAbsolutePath() + "/RTC_Camera_picture.jpg" : VideoCapturerAndroid.this.applicationContext.getFilesDir().getPath() + "/RTC_Camera_picture.jpg";
                    Bitmap source = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
                    Matrix matrix = new Matrix();
                    matrix.reset();
                    matrix.postRotate((float)rotation);
                    Bitmap target = Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)matrix, (boolean)true);
                    File file = new File(filepath);
                    FileOutputStream bos = null;
                    try {
                        bos = new FileOutputStream(file);
                        target.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bos);
                        bos.flush();
                        bos.close();
                        Logging.d(VideoCapturerAndroid.TAG, "takeCameraPicture -- onPictureTaken end --");
                        Log.d((String)VideoCapturerAndroid.TAG, (String)"takeCameraPicture -- end -1-");
                        callback.onDone(filepath);
                    }
                    catch (FileNotFoundException e2) {
                        e2.printStackTrace();
                    }
                    catch (IOException e3) {
                        Logging.d("onPictureTaken", e3.toString());
                    }
                    finally {
                        Log.d((String)VideoCapturerAndroid.TAG, (String)"takeCameraPicture -- end -2-");
                        camera.startPreview();
                    }
                }
            });
        }
    }

    public static interface CameraSwitchHandler {
        public void onCameraSwitchDone(boolean var1);

        public void onCameraSwitchError(String var1);
    }

    public static interface GlTextureProcessor {
        public void onDrawFrame(int var1, int var2, int var3, float[] var4, int var5);
    }

    public static interface VideoCapturerDataProcessor {
        public void onProcessData(byte[] var1, Camera var2, int var3, int var4, int var5);

        public void setResolution(int var1, int var2);
    }

    public static interface CameraEventsHandler {
        public void onCameraError(String var1);

        public void onCameraFreezed(String var1);

        public void onCameraOpening(int var1);

        public void onFirstFrameAvailable();

        public void onCameraClosed();
    }

    private static class CameraStatistics {
        private int frameCount = 0;
        private final ThreadUtils.ThreadChecker threadChecker = new ThreadUtils.ThreadChecker();

        CameraStatistics() {
            this.threadChecker.detachThread();
        }

        public void addFrame() {
            this.threadChecker.checkIsOnValidThread();
            ++this.frameCount;
        }

        public int getAndResetFrameCount() {
            this.threadChecker.checkIsOnValidThread();
            int count = this.frameCount;
            this.frameCount = 0;
            return count;
        }
    }
}

