/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.mediamanager;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.content.pm.FeatureInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import com.superrtc.call.Logging;
import com.superrtc.mediamanager.EMediaDefines;
import com.superrtc.mediamanager.EMediaEntities;
import com.superrtc.mediamanager.EMediaPublishConfiguration;
import com.superrtc.mediamanager.EMediaSession;
import com.superrtc.mediamanager.EMediaSessionInvoker;
import com.superrtc.mediamanager.EMediaStream;
import com.superrtc.mediamanager.EMediaTalker;
import com.superrtc.mediamanager.RTCNetworkReceiver;
import com.superrtc.mediamanager.RtcConnectionExt;
import com.superrtc.mediamanager.SRWebSocketExt;
import com.superrtc.mediamanager.XClientBridger;
import com.superrtc.sdk.RtcConnection;
import com.superrtc.sdk.RtcListener;
import com.superrtc.sdk.VideoViewRenderer;
import com.superrtc.util.LooperExecutor;
import com.superrtc.util.RTCCallback;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class EMediaManager {
    private static final String TAG = "EMediaManager";
    private static LooperExecutor executor;
    private static boolean isInit;
    private EMediaSession.EMediaSessionDelegate sessiondelegate;
    private String sessionticket;
    private static boolean iscreatemediamanager;
    public static EMediaManager instance;
    private ManagerData mgrData;
    private JSONObject ticketDict;
    private EMediaSession session;
    EMediaSessionInvoker invoker;
    static final String letters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    static long idnum;
    private boolean isMute;
    private Timer timer;
    private SRWebSocketExt websockext;
    private static Context applicationContext;
    private AtomicBoolean isInputNext = new AtomicBoolean(true);
    private List<Long> fpsList = new ArrayList<Long>();
    private static final String INVOKE_OP_CONN_OPEN = "connOpened";
    private static final String INVOKE_OP_CONN_FAIL = "connFail";
    private static final String INVOKE_OP_CONN_CLOSE = "connClosed";
    private static final String INVOKE_OP_TIMER = "timerCheck";
    private static final String INVOKE_OP_TRYTKT = "tryTicket";
    private static final String INVOKE_OP_EXITTKT = "exitTicket";
    private static final String INVOKE_OP_SUBSR = "subscribe";
    private static final String INVOKE_OP_USUBSR = "unsubscribe";
    private static final String INVOKE_OP_UP_SUBSR = "upsubscribe";
    private static final String INVOKE_OP_RTC_SETSDP = "setLocalSDP";
    private static final String INVOKE_OP_RTC_SETCAND = "setLocalCand";
    private static final String INVOKE_OP_RTC_CAND_DONE = "candDone";
    private static final String INVOKE_OP_RTC_SETUP = "rtcSetup";
    private static final String INVOKE_OP_RTC_RECONN = "rtcReconn";
    private static final String INVOKE_OP_RTC_DISCONN = "rtcDisconn";
    private static final String INVOKE_OP_RTC_CLOSED = "rtcClosed";
    private static final String INVOKE_OP_RTC_ERROR = "rtcError";
    private static final String INVOKE_OP_RTC_UPDATE = "rtcUpd";
    private static final String INVOKE_OP_RTC_STATIS = "rtcStatis";
    private static final String INVOKE_OP_PUBLISH = "publish";
    private static final String INVOKE_OP_UNPUBLISH = "unpublish";
    private static final String INVOKE_OP_CAMERACTRL = "cameraCtrl";
    private static final String INVOKE_OP_NETCHANGED = "netChanged";
    private static final String INVOKE_OP_ERR_DESC = "errDesc";
    private static final String INVOKE_OP_SEND_CUMSTOM = "sendCustom";
    private static final String INVOKE_OP_SEND_RCTRL = "sendRCtrl";
    private static final String INVOKE_OP_ENABLE_XEST = "enableXest";
    private static final String INVOKE_OP_ENABLE_SUB_AUDIOMIX = "enableSubsrAudioMix";
    private static final int XSESSION_EVENT_OPEN_CONN = 1002;
    private static final int XSESSION_EVENT_ENTER = 1004;
    private static final int XSESSION_EVENT_PASSIVE_EXIT = 1005;
    private static final int XSESSION_EVENT_CLOSE_CONN = 1008;
    private static final int XSESSION_EVENT_CALLING = 1010;
    private static final int XSESSION_EVENT_RINGING = 1012;
    private static final int XSESSION_EVENT_MEMBER_JOIN = 1020;
    private static final int XSESSION_EVENT_MEMBER_EXIT = 1022;
    private static final int XSESSION_EVENT_STREAM_PUB = 1030;
    private static final int XSESSION_EVENT_STREAM_UNPUB = 1032;
    private static final int XSESSION_EVENT_STREAM_UPDATE = 1034;
    private static final int XSESSION_EVENT_OPEN_RTC = 1040;
    private static final int XSESSION_EVENT_SET_RTC_CFG = 1041;
    private static final int XSESSION_EVENT_CLOSE_RTC = 1042;
    private static final int XSESSION_EVENT_SET_MYRTC_MIC = 1043;
    private static final int XSESSION_EVENT_SET_MYRTC = 1044;
    private static final int XSESSION_EVENT_SUBSR = 1046;
    private static final int XSESSION_EVENT_UNSUBSR = 1047;
    private static final int XSESSION_EVENT_PUB_UPDATE = 1048;
    private static final int XSESSION_EVENT_UNPUB = 1049;
    private static final int XSESSION_EVENT_CREATE_OFFER = 1050;
    private static final int XSESSION_EVENT_CREATE_ANSWER = 1051;
    private static final int XSESSION_EVENT_REMOTE_SDP = 1053;
    private static final int XSESSION_EVENT_REMOTE_CAND = 1054;
    private static final int XSESSION_EVENT_CAMERACTRL = 1056;
    private static final int XSESSION_EVENT_NOTIFY = 1058;
    private static int cameraId;
    private boolean isUnpub = false;
    private int unpubCameraId = -1;
    private String specificUrl;
    private String specificCandIP;
    private RtcConnection.Listener rtclistener = new RtcConnection.Listener(){

        @Override
        public void onLocalSdp(final RtcConnection rtc, final String sdp) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (!EMediaManager.this.checkExistSameRtc((RtcConnectionExt)rtc, "didGetLocalSdp")) {
                        return;
                    }
                    JSONObject reqDict = new JSONObject();
                    try {
                        reqDict.put("rtcId", (Object)rtc.name);
                        reqDict.put("sdp", (Object)sdp);
                        reqDict.put("op", (Object)EMediaManager.INVOKE_OP_RTC_SETSDP);
                    }
                    catch (JSONException e2) {
                        e2.printStackTrace();
                    }
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(reqDict.toString(), null);
                }
            });
        }

        @Override
        public void onLocalCandidate(final RtcConnection rtc, final String candidate) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (!EMediaManager.this.checkExistSameRtc((RtcConnectionExt)rtc, "didGetLocalCandidate")) {
                        return;
                    }
                    JSONObject reqDict = new JSONObject();
                    try {
                        reqDict.put("rtcId", (Object)rtc.name);
                        reqDict.put("cand", (Object)candidate);
                        reqDict.put("op", (Object)EMediaManager.INVOKE_OP_RTC_SETCAND);
                    }
                    catch (JSONException e2) {
                        e2.printStackTrace();
                    }
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(reqDict.toString(), null);
                }
            });
        }

        @Override
        public void onConnected(final RtcConnection rtc) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (!EMediaManager.this.checkExistSameRtc((RtcConnectionExt)rtc, "didReconnect")) {
                        return;
                    }
                    JSONObject reqDict = new JSONObject();
                    try {
                        reqDict.put("rtcId", (Object)rtc.name);
                        reqDict.put("op", (Object)EMediaManager.INVOKE_OP_RTC_RECONN);
                    }
                    catch (JSONException e2) {
                        e2.printStackTrace();
                    }
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(reqDict.toString(), null);
                }
            });
        }

        @Override
        public void onConnectionsetup(final RtcConnection rtc) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (!EMediaManager.this.checkExistSameRtc((RtcConnectionExt)rtc, "didSetup")) {
                        return;
                    }
                    JSONObject reqDict = new JSONObject();
                    try {
                        reqDict.put("rtcId", (Object)rtc.name);
                        reqDict.put("op", (Object)EMediaManager.INVOKE_OP_RTC_SETUP);
                    }
                    catch (JSONException e2) {
                        e2.printStackTrace();
                    }
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(reqDict.toString(), null);
                }
            });
        }

        @Override
        public void onDisconnected(final RtcConnection rtc) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (!EMediaManager.this.checkExistSameRtc((RtcConnectionExt)rtc, "didDisconnect")) {
                        return;
                    }
                    JSONObject reqDict = new JSONObject();
                    try {
                        reqDict.put("rtcId", (Object)rtc.name);
                        reqDict.put("op", (Object)EMediaManager.INVOKE_OP_RTC_DISCONN);
                    }
                    catch (JSONException e2) {
                        e2.printStackTrace();
                    }
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(reqDict.toString(), null);
                }
            });
        }

        @Override
        public void onCandidateCompleted(final RtcConnection rtc) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (!EMediaManager.this.checkExistSameRtc((RtcConnectionExt)rtc, "didLocalCandidateComplete")) {
                        return;
                    }
                    JSONObject reqDict = new JSONObject();
                    try {
                        reqDict.put("rtcId", (Object)rtc.name);
                        reqDict.put("op", (Object)EMediaManager.INVOKE_OP_RTC_CAND_DONE);
                    }
                    catch (JSONException e2) {
                        e2.printStackTrace();
                    }
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(reqDict.toString(), null);
                }
            });
        }

        @Override
        public void onClosed(final RtcConnection rtc) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (!EMediaManager.this.checkExistSameRtc((RtcConnectionExt)rtc, "didClose")) {
                        return;
                    }
                    JSONObject reqDict = new JSONObject();
                    try {
                        reqDict.put("rtcId", (Object)rtc.name);
                        reqDict.put("op", (Object)EMediaManager.INVOKE_OP_RTC_CLOSED);
                    }
                    catch (JSONException e2) {
                        e2.printStackTrace();
                    }
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(reqDict.toString(), null);
                }
            });
        }

        @Override
        public void onStats(final RtcConnection rtc, final RtcConnection.RtcStatistics stats) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (!EMediaManager.this.checkExistSameRtc((RtcConnectionExt)rtc, "didGetStats")) {
                        return;
                    }
                    JSONObject reqDict = new JSONObject();
                    try {
                        reqDict.put("rtcId", (Object)rtc.name);
                        reqDict.put("op", (Object)EMediaManager.INVOKE_OP_RTC_STATIS);
                        reqDict.put("conntype", (Object)stats.connectionType);
                        reqDict.put("rtt", stats.localVideoRtt);
                        reqDict.put("llostratev", stats.localVideoPacketsLostrate);
                        reqDict.put("llostratea", stats.localAudioPacketsLostrate);
                        reqDict.put("rlostratev", stats.remoteVideoPacketsLostrate);
                        reqDict.put("rlostratea", stats.remoteAudioPacketsLostrate);
                    }
                    catch (JSONException e2) {
                        e2.printStackTrace();
                    }
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(reqDict.toString(), null);
                    if (rtc != null) {
                        // empty if block
                    }
                    RtcConnectionExt rtcExt = (RtcConnectionExt)rtc;
                    if (rtcExt.ownConn != null && rtcExt.ownConn.enableStati) {
                        if (!TextUtils.isEmpty((CharSequence)rtc.streamId)) {
                            EMediaManager.this.invoker.invokeOnNotice(EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_STATS, rtc.name, rtc.streamId, stats, rtcExt.ownConn);
                        } else if (!TextUtils.isEmpty((CharSequence)rtc.pubStreamId)) {
                            EMediaManager.this.invoker.invokeOnNotice(EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_STATS, rtc.name, rtc.pubStreamId, stats, rtcExt.ownConn);
                        }
                    }
                }
            });
        }

        @Override
        public void onError(final RtcConnection rtc, final String description) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (!EMediaManager.this.checkExistSameRtc((RtcConnectionExt)rtc, "didError")) {
                        return;
                    }
                    logcallback.onLog(logLevel.LS_ERROR.ordinal(), "rtc error: [" + rtc.name + "]->[" + description + "]");
                    JSONObject reqDict = new JSONObject();
                    try {
                        reqDict.put("rtcId", (Object)rtc.name);
                        reqDict.put("op", (Object)EMediaManager.INVOKE_OP_RTC_ERROR);
                    }
                    catch (JSONException e2) {
                        e2.printStackTrace();
                    }
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(reqDict.toString(), null);
                }
            });
        }
    };
    private SRWebSocketExt.SRWebSocketDelegate sockdelegate = new SRWebSocketExt.SRWebSocketDelegate(){

        @Override
        public void invokeConnWithWebsocket(final SRWebSocketExt webSocket, final String op) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    EMediaSession session = EMediaManager.this.checkExistSameWebsocket(webSocket, op);
                    if (session == null) {
                        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "non-exist session [" + webSocket.name + "] for op [" + op + "]");
                        return;
                    }
                    JSONObject reqDict = new JSONObject();
                    try {
                        reqDict.put("connId", (Object)session.instanceId);
                        reqDict.put("op", (Object)op);
                    }
                    catch (JSONException e2) {
                        e2.printStackTrace();
                    }
                    int ret = ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(reqDict.toString(), null);
                    if (ret != 0) {
                        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "invokeConnWithWebsocket : fail with " + ret);
                    }
                }
            });
        }

        @Override
        public void webSocketDidOpen(SRWebSocketExt webSocket) {
            logcallback.onLog(logLevel.LS_INFO.ordinal(), "webSocket: webSocketDidOpen " + webSocket.name);
            this.invokeConnWithWebsocket(webSocket, EMediaManager.INVOKE_OP_CONN_OPEN);
        }

        @Override
        public void didReceiveMessageWithString(final SRWebSocketExt webSocket, final String string) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    EMediaSession session = EMediaManager.this.checkExistSameWebsocket(webSocket, "recvString");
                    if (session == null) {
                        return;
                    }
                    logcallback.onLog(logLevel.LS_INFO.ordinal(), "webSocket: didReceiveMessageWithString " + webSocket.name + " recvmesg:" + string);
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.jsonrecvstring(session.instanceId, string);
                }
            });
        }

        @Override
        public void didReceiveMessageWithData(SRWebSocketExt webSocket, byte[] data) {
            logcallback.onLog(logLevel.LS_INFO.ordinal(), "webSocket: didReceiveMessageWithData");
        }

        @Override
        public void didFailWithError(SRWebSocketExt webSocket, Exception error) {
            logcallback.onLog(logLevel.LS_ERROR.ordinal(), "webSocket: didFailWithError, " + error);
            this.invokeConnWithWebsocket(webSocket, EMediaManager.INVOKE_OP_CONN_FAIL);
        }

        @Override
        public void didCloseWithCode(SRWebSocketExt webSocket, int code, String reason, boolean wasClean) {
            logcallback.onLog(logLevel.LS_INFO.ordinal(), "webSocket: didCloseWithCode, code=[" + code + "], reason=[" + reason + "], wasClean=[" + wasClean + "]");
            this.invokeConnWithWebsocket(webSocket, EMediaManager.INVOKE_OP_CONN_CLOSE);
        }

        @Override
        public void didReceivePong(SRWebSocketExt webSocket, byte[] pongPayload) {
            logcallback.onLog(logLevel.LS_INFO.ordinal(), "WebSocket received pong, " + pongPayload);
        }
    };
    private XClientBridger.XClientBridgerDelegate xdelegate = new XClientBridger.XClientBridgerDelegate(){

        @Override
        public int onJsonSendWithConn(String connId, String msg) {
            EMediaSession session = ((EMediaManager)EMediaManager.this).mgrData.connDict.get(connId);
            session.websocket.send(msg);
            return 0;
        }

        public EMediaDefines.EMediaStreamType wrapStreamType(int onValue) {
            for (EMediaDefines.EMediaStreamType on : EMediaDefines.EMediaStreamType.values()) {
                if (on.val != onValue) continue;
                return on;
            }
            throw new RuntimeException("Json str. error on = " + onValue);
        }

        @Override
        public JSONObject onJsonCallback(JSONObject dict) throws JSONException, URISyntaxException {
            int status = 0;
            JSONObject rspDict = new JSONObject();
            String op = dict.optString("op");
            logcallback.onLog(logLevel.LS_INFO.ordinal(), "onJsonCallback dict::" + dict.toString());
            if (op.equals("onEvent")) {
                long event = dict.optInt("event");
                String connId = dict.optString("connId");
                final EMediaSession session = ((EMediaManager)EMediaManager.this).mgrData.connDict.get(connId);
                if (session == null) {
                    logcallback.onLog(logLevel.LS_ERROR.ordinal(), "onEvent: can't find conn [" + connId + "]");
                } else {
                    logcallback.onLog(logLevel.LS_INFO.ordinal(), "onEvent: connId=[" + connId + "] event=[" + event + "]");
                    String argStr = null;
                    if (dict.has("argStr")) {
                        argStr = dict.getString("argStr");
                    }
                    int argInt = 0;
                    if (dict.has("argInt")) {
                        argInt = dict.getInt("argInt");
                    }
                    if (event == 1002L) {
                        String url = argStr;
                        if (EMediaManager.this.specificUrl != null) {
                            url = EMediaManager.this.specificUrl;
                        }
                        boolean isReopen = false;
                        if (session.websocket != null) {
                            session.websocket.close();
                            session.websocket = null;
                            isReopen = true;
                        }
                        EMediaManager.this.websockext = new SRWebSocketExt(url, EMediaManager.this.sockdelegate, session.instanceId);
                        session.websocket = EMediaManager.this.websockext;
                        logcallback.onLog(logLevel.LS_INFO.ordinal(), "opening websocket [" + session.instanceId + "] -> [" + session.websocket.url + "]");
                        session.websocket.open();
                        if (isReopen) {
                            logcallback.onLog(logLevel.LS_INFO.ordinal(), "reopening websocket [" + session.instanceId + "][" + session.websocket + "] -> [" + url + "%@]");
                        } else {
                            logcallback.onLog(logLevel.LS_INFO.ordinal(), "opening websocket [" + session.instanceId + "][" + session.websocket + "] -> [" + url + "%@]");
                        }
                    } else if (event == 1040L) {
                        String rtcId = argStr;
                        RtcConnectionExt existRtc = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(rtcId);
                        boolean isReopen = false;
                        VideoViewRenderer localView = null;
                        VideoViewRenderer remoteView = null;
                        View pubView = null;
                        if (existRtc != null) {
                            localView = existRtc.localViewRender;
                            remoteView = existRtc.remoteViewRender;
                            pubView = existRtc.pubView;
                            existRtc.hangup();
                            isReopen = true;
                        }
                        RtcConnectionExt rtc = new RtcConnectionExt(rtcId);
                        rtc.ownConn = session;
                        rtc.pubType = -1;
                        rtc.setListener(EMediaManager.this.rtclistener);
                        ((EMediaManager)EMediaManager.this).mgrData.rtcDict.put(rtc.name, rtc);
                        EMediaManager.this.setRtc(rtcId, dict);
                        if (isReopen) {
                            logcallback.onLog(logLevel.LS_INFO.ordinal(), "reopen rtc " + rtc.name);
                            if (localView != null && remoteView != null) {
                                rtc.setViews(localView, remoteView);
                            } else if (remoteView != null) {
                                rtc.setViews(null, remoteView);
                            } else if (localView != null) {
                                rtc.setViews(localView, null);
                            }
                            if (pubView != null) {
                                rtc.pubView = pubView;
                                rtc.setCaptureFromView(pubView);
                            }
                            rtc.streamId = existRtc.streamId;
                            rtc.pubStreamId = existRtc.pubStreamId;
                            rtc.pubType = existRtc.pubType;
                            rtc.csrc = existRtc.csrc;
                            for (String subId : ((EMediaManager)EMediaManager.this).mgrData.subsrDict.keySet()) {
                                EMediaEntities.EMediaStreamSubscription sub = ((EMediaManager)EMediaManager.this).mgrData.subsrDict.get(subId);
                                if (sub.rtc != existRtc) continue;
                                sub.rtc = rtc;
                            }
                        } else {
                            logcallback.onLog(logLevel.LS_INFO.ordinal(), "new rtc " + rtc.name);
                        }
                    } else if (event == 1044L) {
                        ((EMediaManager)EMediaManager.this).mgrData.myRtcId = argStr;
                        logcallback.onLog(logLevel.LS_INFO.ordinal(), "set myRtcId: " + ((EMediaManager)EMediaManager.this).mgrData.myRtcId);
                        if (((EMediaManager)EMediaManager.this).mgrData.myRtcId != null) {
                            RtcConnectionExt rtc;
                            ((EMediaManager)EMediaManager.this).mgrData.pubSession = session;
                            if (((EMediaManager)EMediaManager.this).mgrData.localViewRender != null && (rtc = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(argStr)) != null) {
                                rtc.setListener(EMediaManager.this.rtclistener);
                                rtc.setViews(((EMediaManager)EMediaManager.this).mgrData.localViewRender, null);
                            }
                        } else {
                            ((EMediaManager)EMediaManager.this).mgrData.pubSession = null;
                        }
                    } else if (event == 1043L) {
                        ((EMediaManager)EMediaManager.this).mgrData.myMicRtcId = argStr;
                    } else if (event == 1041L) {
                        String rtcId = argStr;
                        RtcConnectionExt rtc = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(rtcId);
                        String config = dict.optString("config");
                        if (rtc != null && !TextUtils.isEmpty((CharSequence)config)) {
                            rtc.setConfigure(config);
                        }
                    } else if (event == 1050L) {
                        String rtcId = argStr;
                        RtcConnectionExt rtc = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(rtcId);
                        if (rtc != null) {
                            rtc.createOffer();
                        }
                        logcallback.onLog(logLevel.LS_INFO.ordinal(), "creating offer...");
                    } else if (event == 1042L) {
                        RtcConnectionExt rtc = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(argStr);
                        if (rtc != null) {
                            rtc.hangup();
                        }
                        ((EMediaManager)EMediaManager.this).mgrData.rtcDict.remove(argStr);
                        if (rtc.name.equals(((EMediaManager)EMediaManager.this).mgrData.myRtcId)) {
                            ((EMediaManager)EMediaManager.this).mgrData.myRtcId = null;
                            ((EMediaManager)EMediaManager.this).mgrData.pubSession = null;
                        }
                        if (rtc.name.equals(((EMediaManager)EMediaManager.this).mgrData.myMicRtcId)) {
                            ((EMediaManager)EMediaManager.this).mgrData.myMicRtcId = null;
                        }
                    } else if (event == 1008L) {
                        EMediaManager.this.closeSession(session);
                    } else if (event == 1053L || event == 1054L) {
                        String rtcId = null;
                        if (dict.has("rtcId")) {
                            rtcId = dict.getString("rtcId");
                        }
                        String sdp = null;
                        if (dict.has("sdp")) {
                            sdp = dict.getString("sdp");
                        }
                        String cand = null;
                        if (dict.has("cand")) {
                            cand = dict.getString("cand");
                        }
                        RtcConnectionExt rtc = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(rtcId);
                        if (sdp != null && rtc != null) {
                            try {
                                rtc.setRemoteJson(sdp);
                            }
                            catch (Exception e2) {
                                e2.printStackTrace();
                            }
                        }
                        if (cand != null && rtc != null) {
                            if (EMediaManager.this.specificCandIP != null) {
                                String ipReg = "\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}";
                                cand = cand.replaceAll(ipReg, EMediaManager.this.specificCandIP);
                            }
                            try {
                                rtc.setRemoteJson(cand);
                            }
                            catch (Exception e3) {
                                e3.printStackTrace();
                            }
                        }
                    } else if (event == 1004L) {
                        int errorCode = 0;
                        if (argInt != 0) {
                            errorCode = argInt;
                        }
                        if (errorCode == 0) {
                            EMediaManager.this.invoker.invokeBlock(session.joinBlock, argStr, null, session);
                        } else {
                            EMediaManager.this.closeSession(session);
                            EMediaEntities.EMediaError error = EMediaManager.this.newErrorWithCode(errorCode, argStr);
                            EMediaManager.this.invoker.invokeBlock(session.joinBlock, session, error, session);
                        }
                        session.joinBlock = null;
                    } else if (event == 1005L) {
                        int reason = argInt;
                        EMediaManager.this.invoker.invokeOnExitConference(reason, argStr, session);
                    } else if (event == 1020L) {
                        EMediaEntities.EMediaMember member = new EMediaEntities.EMediaMember(argStr, dict.optString("memId"), dict.optString("ext"));
                        EMediaManager.this.invoker.invokeOnMemberJoin(member, session);
                    } else if (event == 1022L) {
                        int reason = 0;
                        if (argInt != 0) {
                            reason = argInt;
                        }
                        EMediaEntities.EMediaMember member = new EMediaEntities.EMediaMember(argStr, dict.optString("memId"), dict.optString("ext"));
                        EMediaManager.this.invoker.invokeOnMemberExit(member, session, reason);
                    } else if (event == 1030L || event == 1032L || event == 1034L) {
                        EMediaStream stream = new EMediaStream(argStr, dict.optString("memName"), this.wrapStreamType(dict.optInt("streamType")), dict.optString("streamName"), dict.optInt("voff") != 0, dict.optInt("aoff") != 0, dict.optString("ext"), dict.optInt("csrc"));
                        if (event == 1030L) {
                            ((EMediaManager)EMediaManager.this).mgrData.streamDict.put(argStr, stream);
                            if (stream.csrc != 0) {
                                ((EMediaManager)EMediaManager.this).mgrData.csrcDict.put(stream.csrc, stream);
                                logcallback.onLog(logLevel.LS_INFO.ordinal(), "add stream csrc " + stream.csrc + ", streamId " + stream.streamId + ", memberName " + stream.memberName);
                            }
                            EMediaManager.this.invoker.invokeOnStreamPublish(stream, session);
                        } else if (event == 1032L) {
                            ((EMediaManager)EMediaManager.this).mgrData.streamDict.remove(argStr);
                            if (stream.csrc != 0) {
                                ((EMediaManager)EMediaManager.this).mgrData.csrcDict.remove(stream.csrc);
                                logcallback.onLog(logLevel.LS_INFO.ordinal(), "remove stream csrc " + stream.csrc + ", streamId " + stream.streamId + ", memberName " + stream.memberName);
                            }
                            EMediaManager.this.invoker.invokeOnStopStream(stream, session);
                        } else if (event == 1034L) {
                            ((EMediaManager)EMediaManager.this).mgrData.streamDict.put(argStr, stream);
                            EMediaStream existStream = ((EMediaManager)EMediaManager.this).mgrData.streamDict.get(argStr);
                            if (existStream != null && existStream.csrc != 0) {
                                ((EMediaManager)EMediaManager.this).mgrData.csrcDict.remove(stream.csrc);
                            }
                            if (stream.csrc != 0) {
                                ((EMediaManager)EMediaManager.this).mgrData.csrcDict.put(stream.csrc, stream);
                            }
                            EMediaManager.this.invoker.invokeOnUpdateStream(stream, session);
                        }
                    } else if (event == 1046L) {
                        String rtcId = argStr;
                        String subsrId = dict.optString("subsrId");
                        String streamId = dict.optString("streamId");
                        ((EMediaManager)EMediaManager.this).mgrData.subscribidRtcid.put(subsrId, rtcId);
                        if (rtcId != null) {
                            RtcConnectionExt rtc = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(rtcId);
                            rtc.setListener(EMediaManager.this.rtclistener);
                            EMediaEntities.EMediaStreamSubscription sub = ((EMediaManager)EMediaManager.this).mgrData.subsrDict.get(subsrId);
                            if (rtc != null && sub != null) {
                                sub.rtc = rtc;
                                rtc.streamId = streamId;
                                rtc.setViews(null, sub.view);
                            }
                        } else {
                            ((EMediaManager)EMediaManager.this).mgrData.subsrDict.remove(subsrId);
                        }
                    } else if (event == 1047L) {
                        RtcConnectionExt rtc;
                        String rtcId = argStr;
                        String subsrId = dict.optString("subsrId");
                        if (!TextUtils.isEmpty((CharSequence)rtcId) && (rtc = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(rtcId)) != null) {
                            rtc.setViews(null, null);
                        }
                        if (!TextUtils.isEmpty((CharSequence)subsrId)) {
                            ((EMediaManager)EMediaManager.this).mgrData.subsrDict.remove(subsrId);
                        }
                    } else if (event == 1056L) {
                        String rtcId = dict.optString("rtcId");
                        int x = dict.optInt("x");
                        int y = dict.optInt("y");
                        int focus = dict.optInt("focus");
                        int expo = dict.optInt("expo");
                        int zoom = dict.optInt("zoom");
                        int pic = dict.optInt("pic");
                        int frz = dict.optInt("frz");
                        int tor = dict.optInt("tor");
                        RtcConnectionExt rtc = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.myRtcId);
                        if (rtcId.endsWith(((EMediaManager)EMediaManager.this).mgrData.myRtcId) && rtc != null) {
                            if (focus >= 0 || expo >= 0) {
                                focus = focus > 0 ? 1 : 0;
                                expo = expo > 0 ? 1 : 0;
                                logcallback.onLog(logLevel.LS_INFO.ordinal(), "remote-camera: interestAt x=[" + x + "], y=[" + y + "], focus=" + focus + ", expo=" + expo);
                                rtc.interestAt(x, y, focus, expo, true);
                            }
                            if (zoom >= 0) {
                                Float factor = Float.valueOf((float)((double)zoom / 10000.0));
                                logcallback.onLog(logLevel.LS_INFO.ordinal(), "remote-camera: zoom factor [" + factor + "]");
                                rtc.zoomWithFactor(factor);
                            }
                            if (pic > 0) {
                                logcallback.onLog(logLevel.LS_DEBUG.ordinal(), "Take picture -- command --");
                                rtc.takeCameraPicture(new RTCCallback(){

                                    @Override
                                    public void onDone(Object object) {
                                        logcallback.onLog(logLevel.LS_DEBUG.ordinal(), "Take picture -- success --" + object);
                                        session.delegate.notice(session, EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_TAKE_CAMERA_PICTURE, null, null, object);
                                    }
                                });
                            }
                            if (frz >= 0) {
                                // empty if block
                            }
                            if (tor >= 0) {
                                if (EMediaManager.this.isSupportFlashLight()) {
                                    boolean isOpen = tor > 0;
                                    rtc.handleFlashLight(isOpen);
                                } else {
                                    status = EMediaDefines.EMediaErrorCode.EMEDIA_ERROR_UNKNOWN.errorcode;
                                }
                            }
                        }
                    } else if (event == 1058L) {
                        String arg2 = dict.optString("arg2");
                        String arg3 = dict.optString("arg3");
                        EMediaManager.this.invoker.invokeOnNotice(EMediaManager.wrapENoticeCode(argInt), argStr, arg2, arg3, session);
                    } else if (event == 1048L) {
                        String rtcId = dict.optString("rtcId");
                        RtcConnectionExt rtc = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(rtcId);
                        String pubStreamId = dict.optString("pubStreamId");
                        if (rtc != null) {
                            rtc.csrc = dict.optInt("csrc");
                            if (TextUtils.isEmpty((CharSequence)rtc.pubStreamId)) {
                                rtc.pubStreamId = pubStreamId;
                                EMediaManager.this.invoker.invokeOnNotice(EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_UPDATE_PUB, rtc.name, rtc.pubStreamId, null, session);
                            }
                        }
                    } else if (event == 1049L) {
                        String rtcId = dict.optString("rtcId");
                        RtcConnectionExt rtc = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(rtcId);
                        String pubStreamId = dict.optString("pubStreamId");
                        if (rtc != null && !TextUtils.isEmpty((CharSequence)rtc.pubStreamId) && rtc.pubStreamId.equals(pubStreamId)) {
                            rtc.csrc = 0;
                            rtc.pubStreamId = null;
                            EMediaManager.this.invoker.invokeOnNotice(EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_UNPUB, rtc.name, pubStreamId, null, session);
                        }
                    }
                }
            }
            rspDict.put("op", (Object)"rsp");
            rspDict.put("status", status);
            return rspDict;
        }
    };
    private static XClientBridger.Logcallbackfunc logcallback;

    public static EMediaDefines.EMediaNoticeCode wrapENoticeCode(int onValue) {
        for (EMediaDefines.EMediaNoticeCode on : EMediaDefines.EMediaNoticeCode.values()) {
            if (on.noticeCode != onValue) continue;
            return on;
        }
        throw new RuntimeException("Json str. error on = " + onValue);
    }

    public void setRtc(String rtcId, JSONObject dict) {
        int pubType;
        int numberUseBack;
        RtcConnectionExt rtc = this.mgrData.rtcDict.get(rtcId);
        if (this.isUnpub) {
            this.isUnpub = false;
            if (this.unpubCameraId != -1) {
                RtcConnectionExt.setCameraFacing(this.unpubCameraId);
            }
        } else {
            RtcConnectionExt.setCameraFacing(cameraId);
        }
        String config = null;
        if (dict.has("config")) {
            config = dict.optString("config");
        }
        if (config != null) {
            rtc.setConfigure(config);
        }
        int numberVOff = dict.optInt("voff");
        boolean voff = false;
        if (numberVOff != 0) {
            voff = true;
            rtc.stopCapture();
        }
        int numberAoff = dict.optInt("aoff");
        boolean aoff = false;
        if (numberAoff != 0) {
            aoff = true;
            rtc.setMute(aoff);
        }
        if ((numberUseBack = dict.optInt("useBackCamera")) != 0) {
            RtcConnectionExt.setCameraFacing(0);
        }
        rtc.pubType = pubType = dict.optInt("pubType");
        if (pubType == EMediaDefines.EMediaStreamType.EMSTREAM_TYPE_DESKTOP.val) {
            Logging.d(TAG, "this is share view Rtc");
            rtc.setEnableExternalVideoData(true);
            this.mgrData.shareRtcId = rtcId;
        }
    }

    public void setVideoViews(final String streamId, final VideoViewRenderer localview, final VideoViewRenderer remoteview, final boolean islocal) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ setVideoViews ,streamId=[" + streamId + "] ,localview=[" + localview + "] ,remoteview=[" + remoteview + "] ,islocal=[" + islocal + "]");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (islocal) {
                    RtcConnectionExt rtc;
                    ((EMediaManager)EMediaManager.this).mgrData.localViewRender = localview;
                    if (((EMediaManager)EMediaManager.this).mgrData.myRtcId != null && (rtc = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.myRtcId)) != null) {
                        rtc.setViews(((EMediaManager)EMediaManager.this).mgrData.localViewRender, null);
                    }
                } else {
                    String subscribeId = EMediaManager.this.getSubcribeId(streamId);
                    if (((EMediaManager)EMediaManager.this).mgrData.subsrDict.get(subscribeId) != null) {
                        if (((EMediaManager)EMediaManager.this).mgrData.subsrDict.get((Object)subscribeId).view != remoteview) {
                            ((EMediaManager)EMediaManager.this).mgrData.subsrDict.remove(subscribeId);
                            String rtcId = ((EMediaManager)EMediaManager.this).mgrData.subscribidRtcid.get(subscribeId);
                            if (rtcId == null) {
                                logcallback.onLog(logLevel.LS_INFO.ordinal(), "rtcId is not exit");
                                return;
                            }
                            RtcConnectionExt rtc = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(rtcId);
                            if (rtc != null) {
                                rtc.setViews(null, remoteview);
                                EMediaEntities.EMediaStreamSubscription sub = new EMediaEntities.EMediaStreamSubscription();
                                sub.subscribeId = subscribeId;
                                sub.view = remoteview;
                                ((EMediaManager)EMediaManager.this).mgrData.subsrDict.put(subscribeId, sub);
                            }
                        }
                    } else {
                        EMediaEntities.EMediaStreamSubscription sub = new EMediaEntities.EMediaStreamSubscription();
                        sub.subscribeId = subscribeId;
                        sub.view = remoteview;
                        ((EMediaManager)EMediaManager.this).mgrData.subsrDict.put(subscribeId, sub);
                    }
                }
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- setVideoViews ");
            }
        });
    }

    private String generateString(int len) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            int index = Math.round(letters.length() - 1);
            builder.append(letters.charAt(index));
        }
        return builder.toString();
    }

    private String generateRTCId() {
        return "rtc-" + ++idnum + "-" + this.generateString(3);
    }

    public EMediaSession newSessionWithTicket(String aTicket, String extension, EMediaSession.EMediaSessionDelegate delgate) throws JSONException {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ newSessionWithTicket ,aTicket=[" + aTicket + "]");
        if (aTicket == null) {
            Log.i((String)TAG, (String)"ticket is null");
        }
        JSONTokener jsonParser = new JSONTokener(aTicket);
        JSONObject ticketDict = (JSONObject)jsonParser.nextValue();
        this.session = new EMediaSession(this, aTicket, ticketDict, extension);
        this.session.delegate = delgate;
        EMediaSession.delegateQueue = executor;
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- newSessionWithTicket ");
        return this.session;
    }

    public void setSession(final EMediaSession session, final String nickName) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                session.nickName = nickName;
            }
        });
    }

    public static EMediaManager getInstance() {
        if (instance == null) {
            instance = new EMediaManager();
        }
        return instance;
    }

    public static boolean isInit() {
        return isInit;
    }

    public static void initGlobal(Context context) {
        if (isInit) {
            return;
        }
        applicationContext = context;
        executor = new LooperExecutor();
        executor.setPriority(10);
        executor.requestStart();
        try {
            RtcConnection.initGlobal(context, executor);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        isInit = true;
        EMediaManager.getInstance();
    }

    public EMediaManager() {
        this.mgrData = new ManagerData();
        this.mgrData.workQueue = executor;
        this.mgrData.bridger = new XClientBridger(this.xdelegate);
        this.mgrData.bridger.setlogfunc(logcallback);
        this.mgrData.myRtcId = null;
        this.invoker = new EMediaSessionInvoker();
        this.setNetworkChangedListener();
        this.setRtcListener();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                JSONObject json = new JSONObject();
                try {
                    json.put("op", (Object)EMediaManager.INVOKE_OP_ENABLE_XEST);
                    json.put("code", 1);
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(json.toString(), null);
                }
                catch (JSONException e2) {
                    e2.printStackTrace();
                }
            }
        });
    }

    public void setNetworkChangedListener() {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "Register network change receiver!");
        RTCNetworkReceiver receiver = new RTCNetworkReceiver();
        receiver.setNetworkListener(new RTCNetworkReceiver.NetworkListener(){

            @Override
            public void onNetworkChanged(int state) {
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "Network changed " + state);
                JSONObject reqDict = new JSONObject();
                try {
                    reqDict.put("netStatus", state);
                    reqDict.put("op", (Object)EMediaManager.INVOKE_OP_NETCHANGED);
                }
                catch (JSONException e2) {
                    e2.printStackTrace();
                }
                ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(reqDict.toString(), null);
            }
        });
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        applicationContext.registerReceiver((BroadcastReceiver)receiver, filter);
    }

    public static void setLoggerDelegate(XClientBridger.Logcallbackfunc callback) {
        logcallback = callback;
        RtcConnection.registerLogListener(new RtcConnection.LogListener(){

            @Override
            public void onLog(int level, String log) {
                logcallback.onLog(level, log);
            }
        });
    }

    public void setLocalPreviewView(final VideoViewRenderer localview) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ setLocalPreviewView  ,localview=[" + localview + "]");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                RtcConnectionExt rtc;
                ((EMediaManager)EMediaManager.this).mgrData.localViewRender = localview;
                if (((EMediaManager)EMediaManager.this).mgrData.myRtcId != null && (rtc = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.myRtcId)) != null) {
                    rtc.setViews(((EMediaManager)EMediaManager.this).mgrData.localViewRender, null);
                }
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- setLocalPreviewView");
            }
        });
    }

    public void join(final EMediaSession session, final EMediaPublishConfiguration config, final EMediaEntities.EMediaIdBlockType block) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ join");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!EMediaManager.this.checkExistSession(session, block, false, "join")) {
                    return;
                }
                JSONObject reqDict = new JSONObject();
                if (config != null) {
                    EMediaManager.this.makePubArg(session, EMediaDefines.EMediaStreamType.EMSTREAM_TYPE_NORMAL, config, reqDict);
                }
                session.joinBlock = block;
                ((EMediaManager)EMediaManager.this).mgrData.connDict.put(session.instanceId, session);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "startTimer");
                EMediaManager.this.startTimer();
                try {
                    reqDict.put("connId", (Object)session.instanceId);
                    reqDict.put("ticket", (Object)session.ticket);
                    if (session.extension != null) {
                        reqDict.put("ext", (Object)session.extension);
                    }
                    if (session.nickName != null) {
                        reqDict.put("nickName", (Object)session.nickName);
                    }
                    reqDict.put("op", (Object)EMediaManager.INVOKE_OP_TRYTKT);
                }
                catch (JSONException e2) {
                    e2.printStackTrace();
                }
                ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(reqDict.toString(), null);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- join");
            }
        });
    }

    public void exit(EMediaSession session, EMediaEntities.EMediaIdBlockType block) {
        this.exit(session, 0, block);
    }

    public void exit(final EMediaSession session, final int reason, final EMediaEntities.EMediaIdBlockType block) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ exit");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!EMediaManager.this.checkExistSession(session, block, true, "exit")) {
                    return;
                }
                JSONObject reqDict = new JSONObject();
                try {
                    reqDict.put("connId", (Object)session.instanceId);
                    reqDict.put("reason", reason);
                    reqDict.put("op", (Object)EMediaManager.INVOKE_OP_EXITTKT);
                }
                catch (JSONException e2) {
                    e2.printStackTrace();
                }
                int ret = ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(reqDict.toString(), null);
                EMediaManager.this.invokeResult(session, ret, session, block);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- exit");
            }
        });
    }

    String getSubcribeId(String streamId) {
        return "rtc-" + streamId;
    }

    private boolean checkExistSession(EMediaSession session, EMediaEntities.EMediaIdBlockType block, boolean exist, String origin) {
        if (session == null) {
            logcallback.onLog(logLevel.LS_ERROR.ordinal(), "null  session , origin=" + origin);
            this.invoker.invokeBlock(block, null, this.newErrorWithCode(EMediaDefines.EMediaErrorCode.EMEDIA_ERROR_INVALID_ARG.errorcode, ""), session);
            return false;
        }
        EMediaSession existSession = this.mgrData.connDict.get(session.instanceId);
        if (existSession == null && exist) {
            logcallback.onLog(logLevel.LS_ERROR.ordinal(), "NOT join session[" + session.instanceId + "]");
            this.invoker.invokeBlock(block, null, this.newErrorWithCode(EMediaDefines.EMediaErrorCode.EMEDIA_ERROR_NO_SESSION.errorcode, null), session);
            return false;
        }
        if (existSession != null && !exist) {
            logcallback.onLog(logLevel.LS_ERROR.ordinal(), "already join session[" + session.instanceId + "]");
            this.invoker.invokeBlock(block, null, this.newErrorWithCode(EMediaDefines.EMediaErrorCode.EMEDIA_ERROR_ALREADY_JOIN.errorcode, null), session);
            return false;
        }
        return true;
    }

    private boolean checkExistSubscribe(EMediaSession session, EMediaEntities.EMediaIdBlockType block, boolean exist, String streamId, String subscribeId) {
        EMediaEntities.EMediaStreamSubscription obj = this.mgrData.subsrDict.get(subscribeId);
        if (obj != null && !exist) {
            logcallback.onLog(logLevel.LS_ERROR.ordinal(), "already subscribed, session[" + session.instanceId + "], streamId[" + streamId + "], subsrId[" + subscribeId + "]");
            this.invoker.invokeBlock(block, session, this.newErrorWithCode(EMediaDefines.EMediaErrorCode.EMEDIA_ERROR_ALREADY_SUBSCRIBE.errorcode, null), session);
            return false;
        }
        if (obj == null && exist) {
            logcallback.onLog(logLevel.LS_ERROR.ordinal(), "NO subscribed, session[" + session.instanceId + "], streamId[" + streamId + "], subsrId[" + subscribeId + "]");
            this.invoker.invokeBlock(block, session, this.newErrorWithCode(EMediaDefines.EMediaErrorCode.EMEDIA_ERROR_NO_SUBSCRIBE.errorcode, null), session);
            return false;
        }
        return true;
    }

    public static EMediaDefines.EMediaErrorCode wrap(int onValue) {
        for (EMediaDefines.EMediaErrorCode on : EMediaDefines.EMediaErrorCode.values()) {
            if (on.errorcode != onValue) continue;
            return on;
        }
        throw new RuntimeException("Json str. error on = " + onValue);
    }

    private EMediaEntities.EMediaError newErrorWithCode(int code, String desc) {
        if (desc == null || desc.length() == 0) {
            JSONObject reqDict = new JSONObject();
            try {
                reqDict.put("code", code);
                reqDict.put("op", (Object)INVOKE_OP_ERR_DESC);
            }
            catch (JSONException e2) {
                e2.printStackTrace();
            }
            String[] response = new String[1];
            this.mgrData.bridger.invokeWithDict(reqDict.toString(), response);
            JSONTokener jsonParser = new JSONTokener(response[0]);
            JSONObject strjeson = null;
            try {
                strjeson = (JSONObject)jsonParser.nextValue();
                desc = strjeson.optString("desc");
            }
            catch (JSONException e2) {
                e2.printStackTrace();
            }
        }
        EMediaEntities.EMediaError error = EMediaEntities.EMediaError.newError(EMediaManager.wrap(code), desc);
        return error;
    }

    private boolean invokeResult(EMediaSession session, int ret, Object uid, EMediaEntities.EMediaIdBlockType block) {
        if (ret != 0) {
            EMediaEntities.EMediaError error = EMediaEntities.EMediaError.newError(EMediaManager.wrap(ret), null);
            this.invoker.invokeBlock(block, null, error, session);
            return false;
        }
        this.invoker.invokeBlock(block, uid, null, session);
        return true;
    }

    private boolean checkExistSameRtc(RtcConnectionExt rtc, String origin) {
        RtcConnectionExt existRtc = this.mgrData.rtcDict.get(rtc.name);
        if (existRtc == rtc) {
            return true;
        }
        logcallback.onLog(logLevel.LS_DEBUG.ordinal(), "NOT same rtc [" + rtc.name + "], origin=[" + origin + "%@]");
        return false;
    }

    private EMediaSession checkExistSameWebsocket(SRWebSocketExt websocket, String origin) {
        EMediaSession session = this.mgrData.connDict.get(websocket.name);
        if (session != null && session.websocket == websocket) {
            return session;
        }
        logcallback.onLog(logLevel.LS_DEBUG.ordinal(), "NOT same websocket [" + websocket.name + "], origin=[" + origin + "%@]");
        return null;
    }

    public void closeSession(EMediaSession session) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi] closeSession");
        this.mgrData.connDict.remove(session.instanceId);
        if (session.websocket != null) {
            logcallback.onLog(logLevel.LS_DEBUG.ordinal(), "close websocket [" + session.instanceId + "] -> [" + session.websocket.url + "]");
            session.websocket.close();
            session.websocket = null;
        }
        if (session == this.mgrData.pubSession) {
            this.mgrData.pubSession = null;
        }
        if (this.mgrData.connDict.size() == 0) {
            this.stopTimer();
        }
    }

    public void makePubArg(EMediaSession session, EMediaDefines.EMediaStreamType type, EMediaPublishConfiguration config, JSONObject reqDict) {
        if (config == null) {
            config = new EMediaPublishConfiguration();
        }
        try {
            reqDict.put("pubtype", type.val);
            reqDict.put("voff", config.videoOff);
            reqDict.put("aoff", config.mute);
            reqDict.put("useBackCamera", config.useBackCamera);
            reqDict.put("vwidth", config.vwidth);
            reqDict.put("vheight", config.vheight);
            reqDict.put("extVideoSrc", config.externalVideoSource);
            if (config.extension != null) {
                reqDict.put("streamExt", (Object)config.extension);
            }
            if (config.name != null) {
                reqDict.put("pubname", (Object)config.name);
            }
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
    }

    private void setInputNext(boolean next) {
        this.isInputNext.getAndSet(next);
    }

    public void inputExternalVideoData(final Bitmap bitmap) {
        if (this.isInputNext.get()) {
            this.computeFrameRate();
            this.setInputNext(false);
            logcallback.onLog(logLevel.LS_DEBUG.ordinal(), "input external video data -0- fps size " + this.fpsList.size());
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    RtcConnectionExt rtc = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.shareRtcId);
                    if (rtc != null) {
                        int width = bitmap.getWidth();
                        int height = bitmap.getHeight();
                        rtc.inputExternalVideoData(rtc.rgb2yuv(bitmap, width, height), width, height, 0);
                    }
                    EMediaManager.this.setInputNext(true);
                    logcallback.onLog(logLevel.LS_DEBUG.ordinal(), "input external video data -1-");
                }
            });
        }
    }

    public void inputExternalVideoData(final byte[] data, final int width, final int height, final int rotation) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                RtcConnectionExt rtc = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.myMicRtcId);
                if (rtc != null) {
                    rtc.inputExternalVideoData(data, width, height, rotation);
                }
            }
        });
    }

    public void computeFrameRate() {
        this.fpsList.add(System.currentTimeMillis());
        long time = this.fpsList.get(this.fpsList.size() - 1) - this.fpsList.get(0);
        if (time > 1000L) {
            this.removeFirst();
            time = this.fpsList.get(this.fpsList.size() - 1) - this.fpsList.get(0);
            float frameRate = (float)this.fpsList.size() / (float)time * 1000.0f;
            logcallback.onLog(logLevel.LS_DEBUG.ordinal(), "Input frame rate: " + frameRate);
        }
    }

    public void removeFirst() {
        this.fpsList.remove(0);
        long time = this.fpsList.get(this.fpsList.size() - 1) - this.fpsList.get(0);
        if (time > 1000L) {
            this.removeFirst();
        }
    }

    public void publish(final EMediaSession session, final EMediaPublishConfiguration config, final EMediaEntities.EMediaIdBlockType block) {
        logcallback.onLog(logLevel.LS_INFO.ordinal(), "publish config=" + config);
        if (!this.checkExistSession(session, block, true, "pub")) {
            return;
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                RtcConnectionExt rtc;
                JSONObject reqDict = new JSONObject();
                EMediaManager.this.makePubArg(session, config.pubType, config, reqDict);
                try {
                    reqDict.put("connId", (Object)session.instanceId);
                    reqDict.put("op", (Object)EMediaManager.INVOKE_OP_PUBLISH);
                }
                catch (JSONException e2) {
                    e2.printStackTrace();
                }
                String[] rspDict = new String[1];
                int ret = ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(reqDict.toString(), rspDict);
                String pubId = "";
                try {
                    JSONObject pubDict = new JSONObject(rspDict[0]);
                    if (pubDict.has("pubId")) {
                        pubId = pubDict.getString("pubId");
                    }
                }
                catch (JSONException e3) {
                    e3.printStackTrace();
                }
                if (ret == 0 && config.isExternalVideoSource() && (rtc = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(pubId)) != null) {
                    rtc.setEnableExternalVideoData(true);
                    if (config.pubView != null) {
                        rtc.pubView = config.pubView;
                        rtc.setCaptureFromView(rtc.pubView);
                    }
                }
                EMediaManager.this.invokeResult(session, ret, pubId, block);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- publish");
            }
        });
    }

    public void unpublish(final EMediaSession session, final String publishId, final EMediaEntities.EMediaIdBlockType block) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ unpublish");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!EMediaManager.this.checkExistSession(session, block, true, "unpub")) {
                    return;
                }
                JSONObject reqDict = new JSONObject();
                try {
                    reqDict.put("rtcId", (Object)publishId);
                    reqDict.put("connId", (Object)session.instanceId);
                    reqDict.put("op", (Object)EMediaManager.INVOKE_OP_UNPUBLISH);
                }
                catch (JSONException e2) {
                    e2.printStackTrace();
                }
                RtcConnectionExt rtc = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.myRtcId);
                if (rtc != null) {
                    EMediaManager.this.isUnpub = true;
                    EMediaManager.this.unpubCameraId = rtc.getCameraFacing();
                }
                String[] rspDict = new String[1];
                int ret = ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(reqDict.toString(), rspDict);
                JSONTokener jsonParser = new JSONTokener(rspDict[0]);
                JSONObject unpubDict = new JSONObject();
                try {
                    unpubDict = (JSONObject)jsonParser.nextValue();
                    EMediaManager.this.invokeResult(session, ret, unpubDict.optString("pubId"), block);
                }
                catch (JSONException e3) {
                    e3.printStackTrace();
                }
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- unpublish");
            }
        });
    }

    public void subscribe(final EMediaSession session, final String streamId, final VideoViewRenderer remoteView, final EMediaEntities.EMediaIdBlockType block) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ subscribe ,streamId=" + streamId + " ,remoteview=[" + remoteView + "]");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                EMediaEntities.EMediaStreamSubscription sub;
                if (!EMediaManager.this.checkExistSession(session, block, true, "sub")) {
                    return;
                }
                String subscribeId = EMediaManager.this.getSubcribeId(streamId);
                logcallback.onLog(logLevel.LS_DEBUG.ordinal(), "subscribing stream [" + streamId + "]with subsrId[" + subscribeId + "]");
                if (!EMediaManager.this.checkExistSubscribe(session, block, false, streamId, subscribeId)) {
                    return;
                }
                if (((EMediaManager)EMediaManager.this).mgrData.subsrDict.get(subscribeId) == null) {
                    sub = new EMediaEntities.EMediaStreamSubscription();
                    sub.subscribeId = subscribeId;
                    sub.view = remoteView;
                    ((EMediaManager)EMediaManager.this).mgrData.subsrDict.put(subscribeId, sub);
                } else {
                    sub = ((EMediaManager)EMediaManager.this).mgrData.subsrDict.get(subscribeId);
                    sub.subscribeId = subscribeId;
                    sub.view = remoteView;
                    ((EMediaManager)EMediaManager.this).mgrData.subsrDict.put(subscribeId, sub);
                }
                boolean subVideo = remoteView != null;
                JSONObject reqDict = new JSONObject();
                try {
                    reqDict.put("subsrId", (Object)subscribeId);
                    reqDict.put("connId", (Object)session.instanceId);
                    reqDict.put("streamId", (Object)streamId);
                    reqDict.put("subSVideo", subVideo);
                    reqDict.put("op", (Object)EMediaManager.INVOKE_OP_SUBSR);
                }
                catch (JSONException e2) {
                    e2.printStackTrace();
                }
                int ret = ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(reqDict.toString(), null);
                if (ret != 0) {
                    ((EMediaManager)EMediaManager.this).mgrData.subsrDict.remove(subscribeId);
                    EMediaManager.this.invokeResult(session, ret, null, block);
                } else {
                    EMediaManager.this.invokeResult(session, ret, subscribeId, block);
                }
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- subscribe");
            }
        });
    }

    public void updateSubscribe(final EMediaSession session, final String streamId, final VideoViewRenderer remoteView, final EMediaEntities.EMediaIdBlockType block) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ update subscribe ,streamId=" + streamId + " ,remoteview=[" + remoteView + "]");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!EMediaManager.this.checkExistSession(session, block, true, "sub")) {
                    return;
                }
                String subscribeId = EMediaManager.this.getSubcribeId(streamId);
                logcallback.onLog(logLevel.LS_DEBUG.ordinal(), "update subscribe stream [" + streamId + "]with subsrId[" + subscribeId + "]");
                if (!EMediaManager.this.checkExistSubscribe(session, block, true, streamId, subscribeId)) {
                    return;
                }
                EMediaEntities.EMediaStreamSubscription sub = ((EMediaManager)EMediaManager.this).mgrData.subsrDict.get(subscribeId);
                if (sub == null || sub.view == remoteView) {
                    logcallback.onLog(logLevel.LS_DEBUG.ordinal(), "update subscribe stream [" + streamId + "]with subsrId[" + subscribeId + "] ignore");
                    EMediaManager.this.invokeResult(session, 0, subscribeId, block);
                    return;
                }
                if (sub.rtc != null) {
                    sub.rtc.setViews(null, remoteView);
                }
                if (sub.view != null && remoteView != null) {
                    logcallback.onLog(logLevel.LS_DEBUG.ordinal(), "update subscribe stream [" + streamId + "]with subsrId[" + subscribeId + "] change it");
                    sub.view = remoteView;
                    EMediaManager.this.invokeResult(session, 0, subscribeId, block);
                    return;
                }
                sub.view = remoteView;
                boolean subVideo = remoteView != null;
                JSONObject reqDict = new JSONObject();
                try {
                    reqDict.put("subsrId", (Object)subscribeId);
                    reqDict.put("connId", (Object)session.instanceId);
                    reqDict.put("streamId", (Object)streamId);
                    reqDict.put("subSVideo", subVideo);
                    reqDict.put("op", (Object)EMediaManager.INVOKE_OP_UP_SUBSR);
                }
                catch (JSONException e2) {
                    e2.printStackTrace();
                }
                int ret = ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(reqDict.toString(), null);
                if (ret != 0) {
                    ((EMediaManager)EMediaManager.this).mgrData.subsrDict.remove(subscribeId);
                    EMediaManager.this.invokeResult(session, ret, null, block);
                } else {
                    EMediaManager.this.invokeResult(session, ret, subscribeId, block);
                }
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- update subscribe");
            }
        });
    }

    public void unsubscribe(final EMediaSession session, final String streamId, final EMediaEntities.EMediaIdBlockType block) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ unsubscribe ,streamId=[" + streamId + "]");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!EMediaManager.this.checkExistSession(session, block, true, "unsub")) {
                    return;
                }
                String subscribeId = EMediaManager.this.getSubcribeId(streamId);
                logcallback.onLog(logLevel.LS_INFO.ordinal(), "unsubscribing  stream [" + streamId + "]with subsrId[" + subscribeId + "]");
                JSONObject reqDict = new JSONObject();
                try {
                    reqDict.put("subsrId", (Object)subscribeId);
                    reqDict.put("connId", (Object)session.instanceId);
                    reqDict.put("op", (Object)EMediaManager.INVOKE_OP_USUBSR);
                }
                catch (JSONException e2) {
                    e2.printStackTrace();
                }
                int ret = ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(reqDict.toString(), null);
                EMediaManager.this.invokeResult(session, ret, subscribeId, block);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- unsubscribe");
            }
        });
    }

    public void switchCamera() {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ switchCamera");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (((EMediaManager)EMediaManager.this).mgrData.myRtcId == null) {
                    return;
                }
                RtcConnectionExt rtc = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.myRtcId);
                if (rtc == null) {
                    return;
                }
                rtc.switchCamera();
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- switchCamera");
            }
        });
    }

    public static void setCameraFacing(final int id) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ setCameraFacing");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (cameraId != id) {
                    cameraId = id;
                }
                RtcConnectionExt.setCameraFacing(id);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- setCameraFacing");
            }
        });
    }

    public int getCameraFacing() {
        RtcConnectionExt rtc = this.mgrData.rtcDict.get(this.mgrData.myRtcId);
        if (rtc == null) {
            return 0;
        }
        return rtc.getCameraFacing();
    }

    public void setMuteEnabled(final boolean enabled) {
        this.isMute = enabled;
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ setMuteEnabled ,enable=[" + enabled + "]");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (TextUtils.isEmpty((CharSequence)((EMediaManager)EMediaManager.this).mgrData.myMicRtcId)) {
                    return;
                }
                RtcConnectionExt rtc = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.myMicRtcId);
                if (rtc == null) {
                    return;
                }
                rtc.setMute(enabled);
                JSONObject reqDict = new JSONObject();
                try {
                    reqDict.put("rtcId", (Object)rtc.name);
                    reqDict.put("aoff", enabled);
                    reqDict.put("op", (Object)EMediaManager.INVOKE_OP_RTC_UPDATE);
                }
                catch (JSONException e2) {
                    e2.printStackTrace();
                }
                ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(reqDict.toString(), null);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- setMuteEnabled");
            }
        });
    }

    public void setVideoEnabled(final boolean enabled) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ setVideoEnabled ,enable=[" + enabled + "]");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (((EMediaManager)EMediaManager.this).mgrData.myRtcId == null) {
                    return;
                }
                RtcConnectionExt rtc = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.myRtcId);
                if (rtc == null) {
                    return;
                }
                if (enabled) {
                    rtc.startCapture();
                } else {
                    rtc.stopCapture();
                }
                JSONObject reqDict = new JSONObject();
                try {
                    reqDict.put("rtcId", (Object)rtc.name);
                    reqDict.put("voff", !enabled);
                    reqDict.put("op", (Object)EMediaManager.INVOKE_OP_RTC_UPDATE);
                }
                catch (JSONException e2) {
                    e2.printStackTrace();
                }
                ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(reqDict.toString(), null);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ setVideoEnabled");
            }
        });
    }

    public void switchTorchOn(final boolean on) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ switchTorchOn ,on=[" + on + "]");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (((EMediaManager)EMediaManager.this).mgrData.myRtcId == null) {
                    return;
                }
                RtcConnectionExt rtc = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.myRtcId);
                if (rtc == null) {
                    return;
                }
                rtc.switchTorchOn(on);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- switchTorchOn");
            }
        });
    }

    public void remoteCamerafocus(final EMediaSession session, final String streamId, final boolean focus, final boolean exposure, final Point point, final EMediaEntities.EMediaIdBlockType block) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ remoteCamerafocus ,streamId=[" + streamId + "] ,focus=[" + focus + "] ,exposure=[" + exposure + "]");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!EMediaManager.this.checkExistSession(session, block, true, "remote-focus")) {
                    return;
                }
                int x = point.x * 10000;
                int y = point.y * 10000;
                int ifocus = focus ? 1 : 0;
                int iexpo = exposure ? 1 : 0;
                JSONObject reqDict = new JSONObject();
                try {
                    reqDict.put("x", x);
                    reqDict.put("y", y);
                    reqDict.put("focus", ifocus);
                    reqDict.put("expo", iexpo);
                    reqDict.put("streamId", (Object)streamId);
                    reqDict.put("connId", (Object)session.instanceId);
                    reqDict.put("op", (Object)EMediaManager.INVOKE_OP_CAMERACTRL);
                }
                catch (JSONException e2) {
                    e2.printStackTrace();
                }
                ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(reqDict.toString(), null);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- remoteCamerafocus");
            }
        });
    }

    public void remoteCameraZoomWith(final EMediaSession session, final String streamId, final float zoomFactor, final EMediaEntities.EMediaIdBlockType block) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ remoteCameraZoomWith ,streamId=[" + streamId + "] ,zoomFactor=[" + zoomFactor + "]");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!EMediaManager.this.checkExistSession(session, block, true, "remote-zoom")) {
                    return;
                }
                int zoom = (int)(zoomFactor * 10000.0f);
                JSONObject reqDict = new JSONObject();
                try {
                    reqDict.put("zoom", zoom);
                    reqDict.put("streamId", (Object)streamId);
                    reqDict.put("connId", (Object)session.instanceId);
                    reqDict.put("op", (Object)EMediaManager.INVOKE_OP_CAMERACTRL);
                }
                catch (JSONException e2) {
                    e2.printStackTrace();
                }
                ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(reqDict.toString(), null);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- remoteCameraZoomWith");
            }
        });
    }

    public String getVersion() {
        return RtcConnection.getVersion();
    }

    public void setDocDirectory(String dirPath) {
        RtcConnection.setDocDirectory(dirPath);
    }

    public boolean startRecordPlayout() {
        return RtcConnection.startRecordPlayout();
    }

    public String stopRecordPlayout() {
        return RtcConnection.stopRecordPlayout();
    }

    public void enableStatistics(EMediaSession session, boolean enable) {
        session.enableStati = enable;
    }

    public void setAudioTalkerInterval(final int noticeInterval, EMediaEntities.EMediaIdBlockType block) {
        if (!this.checkExistSession(this.session, block, true, "set-audio-talker")) {
            return;
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                int interval = noticeInterval;
                if (interval < 50) {
                    interval = 300;
                }
                if (interval > 0 && ((EMediaManager)EMediaManager.this).session.audioVolumeInterval <= 0) {
                    EMediaManager.this.fireNextGetAudioVolume(EMediaManager.this.session, interval);
                }
                ((EMediaManager)EMediaManager.this).session.audioVolumeInterval = interval;
            }
        });
    }

    public void stopAudioTalker() {
        if (this.session != null) {
            this.session.audioVolumeInterval = 0;
        }
    }

    private void fireNextGetAudioVolume(final EMediaSession session, final int interval) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (session.audioVolumeInterval > 0) {
                    try {
                        Thread.sleep(interval);
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                    Map<String, Map<Integer, Integer>> aMap = RtcConnection.getAudioVolumeOfRTCMap(((EMediaManager)EMediaManager.this).mgrData.rtcDict);
                    if (aMap != null && aMap.size() > 0) {
                        EMediaManager.this.parseAudioVolume(session, aMap);
                    }
                    EMediaManager.this.fireNextGetAudioVolume(session, session.audioVolumeInterval);
                }
            }
        });
    }

    private void parseAudioVolume(EMediaSession session, Map<String, Map<Integer, Integer>> aMap) {
        HashMap<String, EMediaTalker> talkers = new HashMap<String, EMediaTalker>();
        for (String key : aMap.keySet()) {
            EMediaTalker tk;
            Map<Integer, Integer> csrcs = aMap.get(key);
            RtcConnectionExt rtc = this.mgrData.rtcDict.get(key);
            if (rtc == null || rtc.ownConn != session) continue;
            int incomingLevel = csrcs.get(-1);
            int outgoingLevel = csrcs.get(-2);
            if (rtc.pubType == EMediaDefines.EMediaStreamType.EMSTREAM_TYPE_AUDIOMIX.val) {
                for (int csrc : csrcs.keySet()) {
                    EMediaTalker tk2;
                    if (csrc < 0) continue;
                    EMediaStream stream = this.mgrData.csrcDict.get(csrc);
                    if (stream != null) {
                        tk2 = new EMediaTalker(stream.streamId);
                        talkers.put(stream.streamId, tk2);
                        continue;
                    }
                    if (rtc.csrc != 0 && rtc.csrc == csrc) {
                        tk2 = new EMediaTalker(rtc.name);
                        talkers.put(rtc.name, tk2);
                        continue;
                    }
                    logcallback.onLog(logLevel.LS_ERROR.ordinal(), String.format("csrc:" + csrc + " incoming:" + incomingLevel, new Object[0]));
                }
                continue;
            }
            EMediaStream stream = this.mgrData.streamDict.get(rtc.streamId);
            if (incomingLevel >= 800 && stream != null) {
                tk = new EMediaTalker(stream.streamId);
                talkers.put(stream.streamId, tk);
            }
            if (this.isMute || outgoingLevel < 800) continue;
            tk = new EMediaTalker(rtc.name);
            talkers.put(rtc.name, tk);
        }
        this.invoker.invokeOnNotice(EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_AUDIO_TALKERS, "", "", talkers, session);
    }

    private void setRtcListener() {
        RtcConnection.setRtcListener(new RtcListener(){

            @Override
            public void onError(RtcListener.RTCError error) {
                switch (error) {
                    case OPEN_CAMERA_FAIL: {
                        ((EMediaManager)EMediaManager.this).session.delegate.notice(EMediaManager.this.session, EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_OPEN_CAMERA_FAIL, null, null, null);
                        break;
                    }
                    case OPEN_MIC_FAIL: {
                        ((EMediaManager)EMediaManager.this).session.delegate.notice(EMediaManager.this.session, EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_OPEN_MIC_FAIL, null, null, null);
                    }
                }
            }
        });
    }

    public void manualFocus(final float x, final float y, final int width, final int height) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "manualFocus -start- x:" + x + ", y:" + y);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                RtcConnectionExt rtc = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.myRtcId);
                if (rtc != null) {
                    rtc.handleManualFocus(x, y, width, height);
                }
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "manualFocus -end- ");
            }
        });
    }

    public void manualZoom(final boolean isZoomIn, final int zoomScale) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "manualZoom -start- zoomIn:" + isZoomIn + ", scale:" + zoomScale);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                RtcConnectionExt rtc = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.myRtcId);
                if (rtc != null) {
                    rtc.handleManualZoom(isZoomIn, zoomScale);
                }
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "manualZoom -start- ");
            }
        });
    }

    public boolean isSupportFlashLight() {
        if (this.getCameraFacing() == 1) {
            return false;
        }
        PackageManager pm = applicationContext.getPackageManager();
        FeatureInfo[] features = pm.getSystemAvailableFeatures();
        if (features != null) {
            for (FeatureInfo f : features) {
                if (f == null || !"android.hardware.camera.flash".equals(f.name)) continue;
                return true;
            }
        }
        return false;
    }

    public void sendCtrlMsgByMemberId(final EMediaSession session, final String memberId, final int code, final Object obj, final String message, final EMediaEntities.EMediaIdBlockType block) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "sendCtrlMsgByMemberId -start- " + memberId);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!EMediaManager.this.checkExistSession(session, block, true, "send-custom")) {
                    return;
                }
                int ctrlOP = code;
                if (code == EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_CUSTOM_MSG.noticeCode) {
                    ctrlOP = 1003;
                } else if (code == EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_CTRL_MSG.noticeCode) {
                    ctrlOP = 1002;
                } else if (code == EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_RESPONSE_MSG.noticeCode) {
                    ctrlOP = 1001;
                }
                JSONObject reqDict = new JSONObject();
                try {
                    reqDict.put("memId", (Object)memberId);
                    reqDict.put("msg", (Object)message);
                    reqDict.put("connId", (Object)session.instanceId);
                    reqDict.put("context", obj);
                    reqDict.put("ctrlOP", ctrlOP);
                    reqDict.put("op", (Object)EMediaManager.INVOKE_OP_SEND_RCTRL);
                }
                catch (JSONException e2) {
                    e2.printStackTrace();
                }
                ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(reqDict.toString(), null);
                EMediaManager.this.invoker.invokeBlock(block, null, null, session);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "sendCtrlMsgByMemberId -end- " + memberId);
            }
        });
    }

    public void sendCtrlMsgByStreamId(final EMediaSession session, final String streamId, final int code, final Object obj, final String message, final EMediaEntities.EMediaIdBlockType block) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "sendCtrlMsgByStreamId -start- " + streamId);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!EMediaManager.this.checkExistSession(session, block, true, "send-custom")) {
                    return;
                }
                int ctrlOP = code;
                if (code == EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_CUSTOM_MSG.noticeCode) {
                    ctrlOP = 1003;
                } else if (code == EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_CTRL_MSG.noticeCode) {
                    ctrlOP = 1002;
                } else if (code == EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_RESPONSE_MSG.noticeCode) {
                    ctrlOP = 1001;
                }
                JSONObject reqDict = new JSONObject();
                try {
                    reqDict.put("streamId", (Object)streamId);
                    reqDict.put("msg", (Object)message);
                    reqDict.put("connId", (Object)session.instanceId);
                    reqDict.put("context", obj);
                    reqDict.put("ctrlOP", ctrlOP);
                    reqDict.put("op", (Object)EMediaManager.INVOKE_OP_SEND_RCTRL);
                }
                catch (JSONException e2) {
                    e2.printStackTrace();
                }
                ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(reqDict.toString(), null);
                EMediaManager.this.invoker.invokeBlock(block, null, null, session);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "sendCtrlMsgByStreamId -end- " + streamId);
            }
        });
    }

    public void setSubscribeAudioMixEnabled(final boolean enable) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                int code = enable ? 1 : 0;
                JSONObject reqDict = new JSONObject();
                try {
                    reqDict.put("op", (Object)EMediaManager.INVOKE_OP_ENABLE_SUB_AUDIOMIX);
                    reqDict.put("code", code);
                }
                catch (JSONException e2) {
                    e2.printStackTrace();
                }
                ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(reqDict.toString(), null);
            }
        });
    }

    public void setSpecificServerUrl(final String url, final String host) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                EMediaManager.this.specificUrl = url;
                EMediaManager.this.specificCandIP = host;
            }
        });
    }

    public void startTimer() {
        if (this.timer == null) {
            this.timer = new Timer();
        }
        try {
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            EMediaManager.this.timerDidFire();
                        }
                    });
                }
            }, 0L, 1000L);
        }
        catch (Exception e2) {
            logcallback.onLog(logLevel.LS_ERROR.ordinal(), "::: Can not schedule statistics timer " + e2);
        }
    }

    public void timerDidFire() {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                JSONObject reqDict = new JSONObject();
                try {
                    reqDict.put("op", (Object)EMediaManager.INVOKE_OP_TIMER);
                }
                catch (JSONException e2) {
                    e2.printStackTrace();
                }
                int ret = ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(reqDict.toString(), null);
                if (ret != 0) {
                    logcallback.onLog(logLevel.LS_ERROR.ordinal(), "::: timerDidFire: fail with " + ret);
                }
            }
        });
    }

    public void stopTimer() {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                logcallback.onLog(logLevel.LS_INFO.ordinal(), "stop timer");
                if (EMediaManager.this.timer != null) {
                    EMediaManager.this.timer.cancel();
                    EMediaManager.this.timer.purge();
                    EMediaManager.this.timer = null;
                }
            }
        });
    }

    static {
        isInit = false;
        iscreatemediamanager = false;
        instance = null;
        idnum = 0L;
        cameraId = -1;
        logcallback = new XClientBridger.Logcallbackfunc(){

            @Override
            public void onLog(int level, String log) {
                Log.i((String)EMediaManager.TAG, (String)log);
            }
        };
    }

    private class ManagerData {
        public String myRtcId;
        public String shareRtcId;
        public String myMicRtcId;
        public VideoViewRenderer localViewRender;
        public XClientBridger bridger;
        public LooperExecutor workQueue;
        public Map<String, RtcConnectionExt> rtcDict = new HashMap<String, RtcConnectionExt>();
        public Map<String, EMediaSession> connDict = new HashMap<String, EMediaSession>();
        public Map<String, EMediaEntities.EMediaStreamSubscription> subsrDict = new HashMap<String, EMediaEntities.EMediaStreamSubscription>();
        public Map<String, String> subscribidRtcid = new HashMap<String, String>();
        public EMediaSession pubSession;
        public Map<String, EMediaStream> streamDict = new HashMap<String, EMediaStream>();
        public Map<Integer, EMediaStream> csrcDict = new HashMap<Integer, EMediaStream>();
    }

    private static enum logLevel {
        LS_INFO,
        LS_DEBUG,
        LS_ERROR;

    }
}

