/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.mediamanager;

import com.superrtc.mediamanager.EMediaDefines;
import com.superrtc.mediamanager.EMediaEntities;
import com.superrtc.mediamanager.EMediaSession;
import com.superrtc.mediamanager.EMediaStream;

public class EMediaSessionInvoker {
    public void invokeBlock(final EMediaEntities.EMediaIdBlockType block, final Object uid, final EMediaEntities.EMediaError error, EMediaSession session) {
        if (block == null) {
            return;
        }
        if (EMediaSession.delegateQueue != null) {
            EMediaSession.delegateQueue.execute(new Runnable(){

                @Override
                public void run() {
                    block.onDone(uid, error);
                }
            });
        } else {
            block.onDone(uid, error);
        }
    }

    public void invokeOnExitConference(final int reason, final String desc, final EMediaSession session) {
        if (session.delegate == null) {
            return;
        }
        if (EMediaSession.delegateQueue != null) {
            EMediaSession.delegateQueue.execute(new Runnable(){

                @Override
                public void run() {
                    session.delegate.passiveCloseReason(session, reason, desc);
                }
            });
        } else {
            session.delegate.passiveCloseReason(session, reason, desc);
        }
    }

    public void invokeOnMemberJoin(final EMediaEntities.EMediaMember member, final EMediaSession session) {
        if (session.delegate == null) {
            return;
        }
        if (EMediaSession.delegateQueue != null) {
            EMediaSession.delegateQueue.execute(new Runnable(){

                @Override
                public void run() {
                    session.delegate.joinMember(session, member);
                }
            });
        } else {
            session.delegate.joinMember(session, member);
        }
    }

    public void invokeOnMemberExit(final EMediaEntities.EMediaMember member, final EMediaSession session, int reason) {
        if (session.delegate == null) {
            return;
        }
        if (EMediaSession.delegateQueue != null) {
            EMediaSession.delegateQueue.execute(new Runnable(){

                @Override
                public void run() {
                    session.delegate.exitMember(session, member);
                }
            });
        } else {
            session.delegate.exitMember(session, member);
        }
    }

    public void invokeOnStreamPublish(final EMediaStream stream, final EMediaSession session) {
        if (session.delegate == null) {
            return;
        }
        if (EMediaSession.delegateQueue != null) {
            EMediaSession.delegateQueue.execute(new Runnable(){

                @Override
                public void run() {
                    session.delegate.addStream(session, stream);
                }
            });
        } else {
            session.delegate.addStream(session, stream);
        }
    }

    public void invokeOnStopStream(final EMediaStream stream, final EMediaSession session) {
        if (session.delegate == null) {
            return;
        }
        if (EMediaSession.delegateQueue != null) {
            EMediaSession.delegateQueue.execute(new Runnable(){

                @Override
                public void run() {
                    session.delegate.removeStream(session, stream);
                }
            });
        } else {
            session.delegate.removeStream(session, stream);
        }
    }

    public void invokeOnUpdateStream(final EMediaStream stream, final EMediaSession session) {
        if (session.delegate == null) {
            return;
        }
        if (EMediaSession.delegateQueue != null) {
            EMediaSession.delegateQueue.execute(new Runnable(){

                @Override
                public void run() {
                    session.delegate.updateStream(session, stream);
                }
            });
        } else {
            session.delegate.updateStream(session, stream);
        }
    }

    public void invokeOnNotice(final EMediaDefines.EMediaNoticeCode code, final String arg1, final String arg2, final Object arg3, final EMediaSession session) {
        if (session.delegate == null) {
            return;
        }
        if (EMediaSession.delegateQueue != null) {
            EMediaSession.delegateQueue.execute(new Runnable(){

                @Override
                public void run() {
                    session.delegate.notice(session, code, arg1, arg2, arg3);
                }
            });
        } else {
            session.delegate.notice(session, code, arg1, arg2, arg3);
        }
    }
}

