/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.mediamanager;

import android.util.Log;
import com.superrtc.mediamanager.SRWebSocket;
import internal.org.java_websocket.drafts.Draft;
import internal.org.java_websocket.drafts.Draft_6455;
import internal.org.java_websocket.handshake.ServerHandshake;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;

public class SRWebSocketExt {
    private SRWebSocket srwebsocket;
    private static final String TAG = "SRWebSocketExt";
    public String url;
    private Draft draft;
    public String name;
    public SRWebSocketDelegate delegate;
    private boolean isopen = false;

    public SRWebSocketExt(String strURI, SRWebSocketDelegate setdelegate, String name) throws URISyntaxException {
        this.name = name;
        this.delegate = setdelegate;
        this.url = strURI;
        this.draft = new Draft_6455();
        this.srwebsocket = new SRWebSocket(new URI(strURI), this.draft){

            @Override
            public void onOpen(ServerHandshake handshakedata) {
                SRWebSocketExt.this.isopen = true;
                SRWebSocketExt.this.delegate.webSocketDidOpen(SRWebSocketExt.this);
            }

            @Override
            public void onMessage(String message) {
                if (!SRWebSocketExt.this.isopen) {
                    Log.e((String)SRWebSocketExt.TAG, (String)"websocket is not open!");
                    return;
                }
                SRWebSocketExt.this.delegate.didReceiveMessageWithString(SRWebSocketExt.this, message);
            }

            @Override
            public void onClose(int code, String reason, boolean remote) {
                SRWebSocketExt.this.isopen = false;
                SRWebSocketExt.this.delegate.didCloseWithCode(SRWebSocketExt.this, code, reason, remote);
            }

            @Override
            public void onError(Exception ex) {
                SRWebSocketExt.this.delegate.didFailWithError(SRWebSocketExt.this, ex);
            }
        };
        if (this.url.indexOf("wss") != -1) {
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, null, null);
                this.srwebsocket.setSocket(sslContext.getSocketFactory().createSocket());
            }
            catch (SSLHandshakeException e2) {
                this.isopen = false;
                this.srwebsocket.close();
            }
            catch (Exception e3) {
                this.isopen = false;
                this.srwebsocket.close();
                e3.printStackTrace();
            }
        }
    }

    public void open() {
        if (this.isopen) {
            return;
        }
        this.srwebsocket.connect();
    }

    public void close() {
        this.isopen = false;
        this.srwebsocket.close();
    }

    public void send(String text) {
        if (this.srwebsocket != null && this.isopen) {
            this.srwebsocket.send(text);
        }
    }

    public static interface SRWebSocketDelegate {
        public void invokeConnWithWebsocket(SRWebSocketExt var1, String var2);

        public void webSocketDidOpen(SRWebSocketExt var1);

        public void didReceiveMessageWithString(SRWebSocketExt var1, String var2);

        public void didReceiveMessageWithData(SRWebSocketExt var1, byte[] var2);

        public void didFailWithError(SRWebSocketExt var1, Exception var2);

        public void didCloseWithCode(SRWebSocketExt var1, int var2, String var3, boolean var4);

        public void didReceivePong(SRWebSocketExt var1, byte[] var2);
    }
}

