/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.mediamanager;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Point;
import android.hardware.display.VirtualDisplay;
import android.media.Image;
import android.media.ImageReader;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import com.superrtc.util.BitmapUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;

@TargetApi(value=21)
public class ScreenCaptureManager {
    public final String TAG = this.getClass().getSimpleName();
    public static final int RECORD_REQUEST_CODE = 1000;
    private static ScreenCaptureManager instance;
    private Activity activity;
    private ScreenCaptureCallback screenCaptureCallback;
    public State state = State.IDLE;
    private MediaProjectionManager projectionManager;
    private MediaProjection mediaProjection;
    private VirtualDisplay virtualDisplay;
    private ImageReader imageReader;
    private Display screenDisplay;
    private long oldTime = 0L;
    private int fps = 5;

    private ScreenCaptureManager() {
    }

    public static ScreenCaptureManager getInstance() {
        if (instance == null) {
            instance = new ScreenCaptureManager();
        }
        return instance;
    }

    public void init(Activity activity) {
        this.activity = activity;
        this.projectionManager = (MediaProjectionManager)activity.getSystemService("media_projection");
        if (this.projectionManager != null && this.state == State.IDLE) {
            activity.startActivityForResult(this.projectionManager.createScreenCaptureIntent(), 1000);
            this.state = State.RUNNING;
            Log.d((String)this.TAG, (String)"Init capture screen success!");
        }
    }

    public void stop() {
        if (this.mediaProjection != null) {
            this.mediaProjection.stop();
        }
        this.state = State.IDLE;
        this.activity = null;
    }

    public void start(int resultCode, Intent intent) {
        if (this.projectionManager != null) {
            this.mediaProjection = this.projectionManager.getMediaProjection(resultCode, intent);
            if (this.mediaProjection != null) {
                this.initVirtualDisplay();
                this.mediaProjection.registerCallback((MediaProjection.Callback)new MediaProjectionStopCallback(), null);
            }
            Log.d((String)this.TAG, (String)"Capture screen start success!");
        } else {
            Log.d((String)this.TAG, (String)"Capture screen start failed! ProjectionManager is null");
        }
    }

    private void initVirtualDisplay() {
        DisplayMetrics metrics = this.activity.getResources().getDisplayMetrics();
        int density = metrics.densityDpi;
        this.screenDisplay = this.activity.getWindowManager().getDefaultDisplay();
        Point size = new Point();
        this.screenDisplay.getSize(size);
        int width = size.x;
        int height = size.y;
        this.imageReader = ImageReader.newInstance((int)width, (int)height, (int)1, (int)1);
        this.imageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)new ImageAvailableListener(), null);
        String virtualDisplayName = "Screenshot";
        int flags = 9;
        this.virtualDisplay = this.mediaProjection.createVirtualDisplay(virtualDisplayName, width, height, density, flags, this.imageReader.getSurface(), null, null);
    }

    public void setFps(int fps) {
        this.fps = fps;
    }

    public void setScreenCaptureCallback(ScreenCaptureCallback callback) {
        this.screenCaptureCallback = callback;
    }

    public static enum State {
        IDLE,
        RUNNING;

    }

    public static interface ScreenCaptureCallback {
        public void onBitmap(Bitmap var1);
    }

    private class MediaProjectionStopCallback
    extends MediaProjection.Callback {
        private MediaProjectionStopCallback() {
        }

        public void onStop() {
            if (ScreenCaptureManager.this.virtualDisplay != null) {
                ScreenCaptureManager.this.virtualDisplay.release();
            }
            if (ScreenCaptureManager.this.imageReader != null) {
                ScreenCaptureManager.this.imageReader.setOnImageAvailableListener(null, null);
            }
            ScreenCaptureManager.this.mediaProjection.unregisterCallback((MediaProjection.Callback)this);
            ScreenCaptureManager.this.state = State.IDLE;
        }
    }

    private class ImageAvailableListener
    implements ImageReader.OnImageAvailableListener {
        private ImageAvailableListener() {
        }

        public void onImageAvailable(ImageReader reader) {
            Image image = reader.acquireNextImage();
            long currTime = System.currentTimeMillis();
            if (currTime - ScreenCaptureManager.this.oldTime > (long)(1000 / ScreenCaptureManager.this.fps)) {
                Log.d((String)"lzan13", (String)"capture next");
                Bitmap bitmap = null;
                if (image != null) {
                    ScreenCaptureManager.this.oldTime = currTime;
                    Image.Plane[] planes = image.getPlanes();
                    ByteBuffer buffer = planes[0].getBuffer();
                    int width = image.getWidth();
                    int height = image.getHeight();
                    int pixelStride = planes[0].getPixelStride();
                    int rowStride = planes[0].getRowStride();
                    int rowPadding = rowStride - pixelStride * width;
                    bitmap = Bitmap.createBitmap((int)(width + rowPadding / pixelStride), (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    bitmap.copyPixelsFromBuffer((Buffer)buffer);
                    Matrix matrix = new Matrix();
                    float s = 1.0f / BitmapUtil.getZoomScale(width, height, 800);
                    matrix.postScale(s, s);
                    bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
                    if (ScreenCaptureManager.this.screenCaptureCallback != null) {
                        ScreenCaptureManager.this.screenCaptureCallback.onBitmap(bitmap);
                    }
                }
            }
            if (image != null) {
                image.close();
            }
        }
    }
}

