/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.mediamanager;

import android.util.Log;
import java.net.URISyntaxException;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class XClientBridger {
    private static final String TAG = "Xsignalclient";
    private String rspData = "";
    private XClientBridgerDelegate delegate;
    private Logcallbackfunc sLogfun = new Logcallbackfunc(){

        @Override
        public void onLog(int level, String log) {
            Log.i((String)XClientBridger.TAG, (String)("LogCallback" + log));
        }
    };

    public int invokeWithDict(String reqDict, String[] prspDict) {
        Object error = null;
        int ret = this.nativejsonreq(reqDict, this.rspData);
        int length = this.rspData.length();
        if (prspDict != null) {
            prspDict[0] = length > 0 ? this.rspData : "";
        }
        if (ret != 0) {
            return ret;
        }
        return 0;
    }

    XClientBridger initWithDelegate(XClientBridgerDelegate delegate) {
        this.delegate = delegate;
        return this;
    }

    public void callbacklog(int level, String log) {
        this.sLogfun.onLog(level, log);
    }

    public XClientBridger(XClientBridgerDelegate Delegate2) {
        this.nativeRegisterXsignalclient();
        this.initWithDelegate(Delegate2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setlogfunc(Logcallbackfunc listener) {
        Class<XClientBridger> clazz = XClientBridger.class;
        synchronized (XClientBridger.class) {
            if (listener != null) {
                this.sLogfun = listener;
                this.nativesetlogfunc();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public int jsonreq(String str, String rsp) {
        return this.nativejsonreq(str, rsp);
    }

    public int jsonrecvstring(String conn_id, String str) {
        return this.nativejsonrecvstring(conn_id, str);
    }

    public String oninvoke(String str, String rsp) {
        Log.i((String)TAG, (String)("oninvoke str::" + str));
        JSONTokener jsonParser = new JSONTokener(str);
        JSONObject strjeson = null;
        try {
            strjeson = (JSONObject)jsonParser.nextValue();
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
        JSONObject rspDict = new JSONObject();
        try {
            try {
                rspDict = this.delegate.onJsonCallback(strjeson);
            }
            catch (JSONException e2) {
                e2.printStackTrace();
            }
        }
        catch (URISyntaxException e3) {
            e3.printStackTrace();
        }
        return rspDict.toString();
    }

    public int onsendstring(String conn_id, String str) {
        Log.i((String)TAG, (String)"onsendstring");
        return this.delegate.onJsonSendWithConn(conn_id, str);
    }

    private native int nativeRegisterXsignalclient();

    private native int nativejsonreq(String var1, String var2);

    private native int nativejsonrecvstring(String var1, String var2);

    private native void nativesetlogfunc();

    static {
        try {
            System.loadLibrary("hyphenate_av");
            System.loadLibrary("xsignal_client");
        }
        catch (Throwable e2) {
            Log.d((String)TAG, (String)("not xsignal_client " + e2.getMessage()));
        }
    }

    public static interface XClientBridgerDelegate {
        public int onJsonSendWithConn(String var1, String var2);

        public JSONObject onJsonCallback(JSONObject var1) throws JSONException, URISyntaxException;
    }

    public static interface Logcallbackfunc {
        public void onLog(int var1, String var2);
    }
}

