/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.sound;

public class EMSoundEffect {
    static EMSoundEffect inst;

    public static EMSoundEffect getInstance() {
        if (inst == null) {
            inst = new EMSoundEffect();
        }
        return inst;
    }

    private EMSoundEffect() {
    }

    public boolean startPlayoutEffect(EffectConfigure config) {
        if (config.pitch <= 0.0f) {
            config.pitch = 0.5f;
        }
        this.nativeNewInstance();
        this.nativeSetPitch(config.pitch);
        int ret = this.nativeStart();
        return ret == 0;
    }

    public boolean stopPlayoutEffect() {
        int ret = this.nativeStop();
        return ret == 0;
    }

    public int updatePlayoutPitch(float pitch) {
        if (pitch <= 0.0f) {
            pitch = 0.5f;
        }
        return this.nativeSetPitch(pitch);
    }

    private native int nativeNewInstance();

    private native int nativeSetPitch(float var1);

    private native int nativeStart();

    private native int nativeStop();

    static {
        try {
            System.loadLibrary("emsoundeffect");
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
        inst = null;
    }

    public static class EffectConfigure {
        public float pitch = 1.0f;
    }
}

