/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.util;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.util.Log;
import com.superrtc.util.AppRTCProximitySensor;
import com.superrtc.util.AppRTCUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class AppRTCAudioManager {
    private static final String TAG = "AppRTCAudioManager";
    private final Context apprtcContext;
    private final Runnable onStateChangeListener;
    private boolean initialized = false;
    private AudioManager audioManager;
    private int savedAudioMode = -2;
    private boolean savedIsSpeakerPhoneOn = false;
    private boolean savedIsMicrophoneMute = false;
    private final AudioDevice defaultAudioDevice = AudioDevice.SPEAKER_PHONE;
    private AppRTCProximitySensor proximitySensor = null;
    private AudioDevice selectedAudioDevice;
    private final Set<AudioDevice> audioDevices = new HashSet<AudioDevice>();
    private BroadcastReceiver wiredHeadsetReceiver;

    private void onProximitySensorChangedState() {
        if (this.audioDevices.size() == 2 && this.audioDevices.contains((Object)AudioDevice.EARPIECE) && this.audioDevices.contains((Object)AudioDevice.SPEAKER_PHONE)) {
            if (this.proximitySensor.sensorReportsNearState()) {
                this.setAudioDevice(AudioDevice.EARPIECE);
            } else {
                this.setAudioDevice(AudioDevice.SPEAKER_PHONE);
            }
        }
    }

    public static AppRTCAudioManager create(Context context, Runnable deviceStateChangeListener) {
        return new AppRTCAudioManager(context, deviceStateChangeListener);
    }

    private AppRTCAudioManager(Context context, Runnable deviceStateChangeListener) {
        this.apprtcContext = context;
        this.onStateChangeListener = deviceStateChangeListener;
        this.audioManager = (AudioManager)context.getSystemService("audio");
        this.proximitySensor = AppRTCProximitySensor.create(context, new Runnable(){

            @Override
            public void run() {
                AppRTCAudioManager.this.onProximitySensorChangedState();
            }
        });
        AppRTCUtils.logDeviceInfo(TAG);
    }

    public void init() {
        Log.d((String)TAG, (String)"init");
        if (this.initialized) {
            return;
        }
        this.savedAudioMode = this.audioManager.getMode();
        this.savedIsSpeakerPhoneOn = this.audioManager.isSpeakerphoneOn();
        this.savedIsMicrophoneMute = this.audioManager.isMicrophoneMute();
        this.audioManager.requestAudioFocus(null, 0, 2);
        this.audioManager.setMode(3);
        this.setMicrophoneMute(false);
        this.updateAudioDeviceState(this.hasWiredHeadset());
        this.registerForWiredHeadsetIntentBroadcast();
        this.initialized = true;
    }

    public void close() {
        Log.d((String)TAG, (String)"close");
        if (!this.initialized) {
            return;
        }
        this.unregisterForWiredHeadsetIntentBroadcast();
        this.setSpeakerphoneOn(this.savedIsSpeakerPhoneOn);
        this.setMicrophoneMute(this.savedIsMicrophoneMute);
        this.audioManager.setMode(this.savedAudioMode);
        this.audioManager.abandonAudioFocus(null);
        if (this.proximitySensor != null) {
            this.proximitySensor.stop();
            this.proximitySensor = null;
        }
        this.initialized = false;
    }

    public void setAudioDevice(AudioDevice device) {
        Log.d((String)TAG, (String)("setAudioDevice(device=" + (Object)((Object)device) + ")"));
        AppRTCUtils.assertIsTrue(this.audioDevices.contains((Object)device));
        switch (device) {
            case SPEAKER_PHONE: {
                this.setSpeakerphoneOn(true);
                this.selectedAudioDevice = AudioDevice.SPEAKER_PHONE;
                break;
            }
            case EARPIECE: {
                this.setSpeakerphoneOn(false);
                this.selectedAudioDevice = AudioDevice.EARPIECE;
                break;
            }
            case WIRED_HEADSET: {
                this.setSpeakerphoneOn(false);
                this.selectedAudioDevice = AudioDevice.WIRED_HEADSET;
                break;
            }
            default: {
                Log.e((String)TAG, (String)"Invalid audio device selection");
            }
        }
        this.onAudioManagerChangedState();
    }

    public Set<AudioDevice> getAudioDevices() {
        return Collections.unmodifiableSet(new HashSet<AudioDevice>(this.audioDevices));
    }

    public AudioDevice getSelectedAudioDevice() {
        return this.selectedAudioDevice;
    }

    private void registerForWiredHeadsetIntentBroadcast() {
        IntentFilter filter = new IntentFilter("android.intent.action.HEADSET_PLUG");
        this.wiredHeadsetReceiver = new BroadcastReceiver(){
            private static final int STATE_UNPLUGGED = 0;
            private static final int STATE_PLUGGED = 1;
            private static final int HAS_NO_MIC = 0;
            private static final int HAS_MIC = 1;

            public void onReceive(Context context, Intent intent) {
                int state = intent.getIntExtra("state", 0);
                int microphone = intent.getIntExtra("microphone", 0);
                String name = intent.getStringExtra("name");
                Log.d((String)AppRTCAudioManager.TAG, (String)("BroadcastReceiver.onReceive" + AppRTCUtils.getThreadInfo() + ": a=" + intent.getAction() + ", s=" + (state == 0 ? "unplugged" : "plugged") + ", m=" + (microphone == 1 ? "mic" : "no mic") + ", n=" + name + ", sb=" + this.isInitialStickyBroadcast()));
                boolean hasWiredHeadset = state == 1;
                switch (state) {
                    case 0: {
                        AppRTCAudioManager.this.updateAudioDeviceState(hasWiredHeadset);
                        break;
                    }
                    case 1: {
                        if (AppRTCAudioManager.this.selectedAudioDevice == AudioDevice.WIRED_HEADSET) break;
                        AppRTCAudioManager.this.updateAudioDeviceState(hasWiredHeadset);
                        break;
                    }
                    default: {
                        Log.e((String)AppRTCAudioManager.TAG, (String)"Invalid state");
                    }
                }
            }
        };
        this.apprtcContext.registerReceiver(this.wiredHeadsetReceiver, filter);
    }

    private void unregisterForWiredHeadsetIntentBroadcast() {
        this.apprtcContext.unregisterReceiver(this.wiredHeadsetReceiver);
        this.wiredHeadsetReceiver = null;
    }

    private void setSpeakerphoneOn(boolean on) {
    }

    private void setMicrophoneMute(boolean on) {
        boolean wasMuted = this.audioManager.isMicrophoneMute();
        if (wasMuted == on) {
            return;
        }
        this.audioManager.setMicrophoneMute(on);
    }

    private boolean hasEarpiece() {
        return this.apprtcContext.getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    @Deprecated
    private boolean hasWiredHeadset() {
        return this.audioManager.isWiredHeadsetOn();
    }

    private void updateAudioDeviceState(boolean hasWiredHeadset) {
        this.audioDevices.clear();
        if (hasWiredHeadset) {
            this.audioDevices.add(AudioDevice.WIRED_HEADSET);
        } else {
            this.audioDevices.add(AudioDevice.SPEAKER_PHONE);
            if (this.hasEarpiece()) {
                this.audioDevices.add(AudioDevice.EARPIECE);
            }
        }
        Log.d((String)TAG, (String)("audioDevices: " + this.audioDevices));
        if (hasWiredHeadset) {
            this.setAudioDevice(AudioDevice.WIRED_HEADSET);
        } else {
            this.setAudioDevice(this.defaultAudioDevice);
        }
    }

    private void onAudioManagerChangedState() {
        Log.d((String)TAG, (String)("onAudioManagerChangedState: devices=" + this.audioDevices + ", selected=" + (Object)((Object)this.selectedAudioDevice)));
        if (this.audioDevices.size() == 2) {
            AppRTCUtils.assertIsTrue(this.audioDevices.contains((Object)AudioDevice.EARPIECE) && this.audioDevices.contains((Object)AudioDevice.SPEAKER_PHONE));
            this.proximitySensor.start();
        } else if (this.audioDevices.size() == 1) {
            this.proximitySensor.stop();
        } else {
            Log.e((String)TAG, (String)"Invalid device list");
        }
        if (this.onStateChangeListener != null) {
            this.onStateChangeListener.run();
        }
    }

    public static enum AudioDevice {
        SPEAKER_PHONE,
        WIRED_HEADSET,
        EARPIECE;

    }
}

