/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.util;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Build;
import android.util.Log;
import com.superrtc.util.AppRTCUtils;

public class AppRTCProximitySensor
implements SensorEventListener {
    private static final String TAG = "AppRTCProximitySensor";
    private final AppRTCUtils.NonThreadSafe nonThreadSafe = new AppRTCUtils.NonThreadSafe();
    private final Runnable onSensorStateListener;
    private final SensorManager sensorManager;
    private Sensor proximitySensor = null;
    private boolean lastStateReportIsNear = false;

    static AppRTCProximitySensor create(Context context, Runnable sensorStateListener) {
        return new AppRTCProximitySensor(context, sensorStateListener);
    }

    private AppRTCProximitySensor(Context context, Runnable sensorStateListener) {
        Log.d((String)TAG, (String)(TAG + AppRTCUtils.getThreadInfo()));
        this.onSensorStateListener = sensorStateListener;
        this.sensorManager = (SensorManager)context.getSystemService("sensor");
    }

    public boolean start() {
        this.checkIfCalledOnValidThread();
        Log.d((String)TAG, (String)("start" + AppRTCUtils.getThreadInfo()));
        if (!this.initDefaultSensor()) {
            return false;
        }
        this.sensorManager.registerListener((SensorEventListener)this, this.proximitySensor, 3);
        return true;
    }

    public void stop() {
        this.checkIfCalledOnValidThread();
        Log.d((String)TAG, (String)("stop" + AppRTCUtils.getThreadInfo()));
        if (this.proximitySensor == null) {
            return;
        }
        this.sensorManager.unregisterListener((SensorEventListener)this, this.proximitySensor);
    }

    public boolean sensorReportsNearState() {
        this.checkIfCalledOnValidThread();
        return this.lastStateReportIsNear;
    }

    public final void onAccuracyChanged(Sensor sensor, int accuracy) {
        this.checkIfCalledOnValidThread();
        AppRTCUtils.assertIsTrue(sensor.getType() == 8);
        if (accuracy == 0) {
            Log.e((String)TAG, (String)"The values returned by this sensor cannot be trusted");
        }
    }

    public final void onSensorChanged(SensorEvent event) {
        this.checkIfCalledOnValidThread();
        AppRTCUtils.assertIsTrue(event.sensor.getType() == 8);
        float distanceInCentimeters = event.values[0];
        if (distanceInCentimeters < this.proximitySensor.getMaximumRange()) {
            Log.d((String)TAG, (String)"Proximity sensor => NEAR state");
            this.lastStateReportIsNear = true;
        } else {
            Log.d((String)TAG, (String)"Proximity sensor => FAR state");
            this.lastStateReportIsNear = false;
        }
        if (this.onSensorStateListener != null) {
            this.onSensorStateListener.run();
        }
        Log.d((String)TAG, (String)("onSensorChanged" + AppRTCUtils.getThreadInfo() + ": accuracy=" + event.accuracy + ", timestamp=" + event.timestamp + ", distance=" + event.values[0]));
    }

    private boolean initDefaultSensor() {
        if (this.proximitySensor != null) {
            return true;
        }
        this.proximitySensor = this.sensorManager.getDefaultSensor(8);
        if (this.proximitySensor == null) {
            return false;
        }
        this.logProximitySensorInfo();
        return true;
    }

    private void logProximitySensorInfo() {
        if (this.proximitySensor == null) {
            return;
        }
        StringBuilder info = new StringBuilder("Proximity sensor: ");
        info.append("name=" + this.proximitySensor.getName());
        info.append(", vendor: " + this.proximitySensor.getVendor());
        info.append(", power: " + this.proximitySensor.getPower());
        info.append(", resolution: " + this.proximitySensor.getResolution());
        info.append(", max range: " + this.proximitySensor.getMaximumRange());
        if (Build.VERSION.SDK_INT >= 9) {
            info.append(", min delay: " + this.proximitySensor.getMinDelay());
        }
        if (Build.VERSION.SDK_INT >= 20) {
            info.append(", type: " + this.proximitySensor.getStringType());
        }
        if (Build.VERSION.SDK_INT >= 21) {
            info.append(", max delay: " + this.proximitySensor.getMaxDelay());
            info.append(", reporting mode: " + this.proximitySensor.getReportingMode());
            info.append(", isWakeUpSensor: " + this.proximitySensor.isWakeUpSensor());
        }
        Log.d((String)TAG, (String)info.toString());
    }

    private void checkIfCalledOnValidThread() {
        if (!this.nonThreadSafe.calledOnValidThread()) {
            throw new IllegalStateException("Method is not called on valid thread");
        }
    }
}

