/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.util;

import android.util.Log;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Scanner;

public class CpuMonitor {
    private static final int SAMPLE_SAVE_NUMBER = 10;
    private int[] percentVec = new int[10];
    private int sum3 = 0;
    private int sum10 = 0;
    private static final String TAG = "CpuMonitor";
    private long[] cpuFreq;
    private int cpusPresent;
    private double lastPercentFreq = -1.0;
    private int cpuCurrent;
    private int cpuAvg3;
    private int cpuAvgAll;
    private boolean initialized = false;
    private String[] maxPath;
    private String[] curPath;
    ProcStat lastProcStat;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        try (FileReader fin = new FileReader("/sys/devices/system/cpu/present");){
            BufferedReader rdr = new BufferedReader(fin);
            Scanner scanner = new Scanner(rdr).useDelimiter("[-\n]");
            scanner.nextInt();
            this.cpusPresent = 1 + scanner.nextInt();
            scanner.close();
        }
        catch (FileNotFoundException e2) {
            Log.e((String)TAG, (String)"Cannot do CPU stats since /sys/devices/system/cpu/present is missing");
        }
        catch (IOException e3) {
            Log.e((String)TAG, (String)"Error closing file");
        }
        this.cpuFreq = new long[this.cpusPresent];
        this.maxPath = new String[this.cpusPresent];
        this.curPath = new String[this.cpusPresent];
        for (int i = 0; i < this.cpusPresent; ++i) {
            this.cpuFreq[i] = 0L;
            this.maxPath[i] = "/sys/devices/system/cpu/cpu" + i + "/cpufreq/cpuinfo_max_freq";
            this.curPath[i] = "/sys/devices/system/cpu/cpu" + i + "/cpufreq/scaling_cur_freq";
        }
        this.lastProcStat = new ProcStat(0L, 0L);
        this.initialized = true;
    }

    public boolean sampleCpuUtilization() {
        long lastSeenMaxFreq = 0L;
        long cpufreqCurSum = 0L;
        long cpufreqMaxSum = 0L;
        if (!this.initialized) {
            this.init();
        }
        for (int i = 0; i < this.cpusPresent; ++i) {
            if (this.cpuFreq[i] == 0L) {
                long cpufreqMax = this.readFreqFromFile(this.maxPath[i]);
                if (cpufreqMax > 0L) {
                    lastSeenMaxFreq = cpufreqMax;
                    this.cpuFreq[i] = cpufreqMax;
                    this.maxPath[i] = null;
                }
            } else {
                lastSeenMaxFreq = this.cpuFreq[i];
            }
            long cpufreqCur = this.readFreqFromFile(this.curPath[i]);
            cpufreqCurSum += cpufreqCur;
            cpufreqMaxSum += lastSeenMaxFreq;
        }
        if (cpufreqMaxSum == 0L) {
            Log.e((String)TAG, (String)"Could not read max frequency for any CPU");
            return false;
        }
        double newPercentFreq = 100.0 * (double)cpufreqCurSum / (double)cpufreqMaxSum;
        double percentFreq = this.lastPercentFreq > 0.0 ? (this.lastPercentFreq + newPercentFreq) * 0.5 : newPercentFreq;
        this.lastPercentFreq = newPercentFreq;
        ProcStat procStat = this.readIdleAndRunTime();
        if (procStat == null) {
            return false;
        }
        long diffRunTime = procStat.runTime - this.lastProcStat.runTime;
        long diffIdleTime = procStat.idleTime - this.lastProcStat.idleTime;
        this.lastProcStat = procStat;
        long allTime = diffRunTime + diffIdleTime;
        int percent = allTime == 0L ? 0 : (int)Math.round(percentFreq * (double)diffRunTime / (double)allTime);
        percent = Math.max(0, Math.min(percent, 100));
        this.sum3 += percent - this.percentVec[2];
        this.sum10 += percent - this.percentVec[9];
        for (int i = 9; i > 0; --i) {
            this.percentVec[i] = this.percentVec[i - 1];
        }
        this.percentVec[0] = percent;
        this.cpuCurrent = percent;
        this.cpuAvg3 = this.sum3 / 3;
        this.cpuAvgAll = this.sum10 / 10;
        return true;
    }

    public int getCpuCurrent() {
        return this.cpuCurrent;
    }

    public int getCpuAvg3() {
        return this.cpuAvg3;
    }

    public int getCpuAvgAll() {
        return this.cpuAvgAll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readFreqFromFile(String fileName) {
        long number = 0L;
        try (FileReader fin2 = new FileReader(fileName);){
            BufferedReader rdr = new BufferedReader(fin2);
            Scanner scannerC = new Scanner(rdr);
            number = scannerC.nextLong();
            scannerC.close();
        }
        catch (FileNotFoundException fin2) {
        }
        catch (IOException e2) {
            Log.e((String)TAG, (String)"Error closing file");
        }
        return number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcStat readIdleAndRunTime() {
        long runTime = 0L;
        long idleTime = 0L;
        FileReader fin = new FileReader("/proc/stat");
        try {
            BufferedReader rdr = new BufferedReader(fin);
            Scanner scanner = new Scanner(rdr);
            scanner.next();
            long user = scanner.nextLong();
            long nice = scanner.nextLong();
            long sys = scanner.nextLong();
            runTime = user + nice + sys;
            idleTime = scanner.nextLong();
            scanner.close();
        }
        catch (Exception e2) {
            ProcStat procStat;
            try {
                Log.e((String)TAG, (String)"Problems parsing /proc/stat");
                procStat = null;
            }
            catch (Throwable throwable) {
                try {
                    fin.close();
                    throw throwable;
                }
                catch (FileNotFoundException e3) {
                    Log.e((String)TAG, (String)"Cannot open /proc/stat for reading");
                    return null;
                }
                catch (IOException e4) {
                    Log.e((String)TAG, (String)"Problems reading /proc/stat");
                    return null;
                }
            }
            fin.close();
            return procStat;
        }
        fin.close();
        return new ProcStat(runTime, idleTime);
    }

    private class ProcStat {
        final long runTime;
        final long idleTime;

        ProcStat(long aRunTime, long aIdleTime) {
            this.runTime = aRunTime;
            this.idleTime = aIdleTime;
        }
    }
}

