/*
 * Decompiled with CFR 0.152.
 */
package internal.org.apache.http.entity.mime.content;

import internal.org.apache.http.entity.mime.content.AbstractContentBody;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class StringBody
extends AbstractContentBody {
    private final byte[] content;
    private final Charset charset;

    public static StringBody create(String string, String string2, Charset charset) throws IllegalArgumentException {
        try {
            return new StringBody(string, string2, charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Charset " + charset + " is not supported", unsupportedEncodingException);
        }
    }

    public static StringBody create(String string, Charset charset) throws IllegalArgumentException {
        return StringBody.create(string, null, charset);
    }

    public static StringBody create(String string) throws IllegalArgumentException {
        return StringBody.create(string, null, null);
    }

    public StringBody(String string, String string2, Charset charset) throws UnsupportedEncodingException {
        super(string2);
        if (string == null) {
            throw new IllegalArgumentException("Text may not be null");
        }
        if (charset == null) {
            charset = Charset.forName("US-ASCII");
        }
        this.content = string.getBytes(charset.name());
        this.charset = charset;
    }

    public StringBody(String string, Charset charset) throws UnsupportedEncodingException {
        this(string, "text/plain", charset);
    }

    public StringBody(String string) throws UnsupportedEncodingException {
        this(string, "text/plain", null);
    }

    public Reader getReader() {
        return new InputStreamReader((InputStream)new ByteArrayInputStream(this.content), this.charset);
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        int n;
        if (outputStream == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.content);
        byte[] byArray = new byte[4096];
        while ((n = byteArrayInputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
    }

    @Override
    public String getTransferEncoding() {
        return "8bit";
    }

    @Override
    public String getCharset() {
        return this.charset.name();
    }

    @Override
    public long getContentLength() {
        return this.content.length;
    }

    @Override
    public String getFilename() {
        return null;
    }
}

