/*
 * Decompiled with CFR 0.152.
 */
package com.chinamobile.ysx;

import android.content.Context;
import android.os.CountDownTimer;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import com.chinamobile.ysx.R;
import com.chinamobile.ysx.YSXDialOutStatusListener;
import com.chinamobile.ysx.YSXInstantMeetingOptions;
import com.chinamobile.ysx.YSXJoinMeetingOptions;
import com.chinamobile.ysx.YSXJoinMeetingParams;
import com.chinamobile.ysx.YSXMeetingCountCallBackListener;
import com.chinamobile.ysx.YSXMeetingService;
import com.chinamobile.ysx.YSXMeetingServiceListener;
import com.chinamobile.ysx.YSXMeetingStatus;
import com.chinamobile.ysx.YSXMessageListener;
import com.chinamobile.ysx.YSXSdk;
import com.chinamobile.ysx.YSXStartMeetingOptions;
import com.chinamobile.ysx.YSXStartMeetingParams;
import com.chinamobile.ysx.YSXStartMeetingParams4APIUser;
import com.chinamobile.ysx.YSXStartMeetingParams4NormalUser;
import com.chinamobile.ysx.YSXStartMeetingParamsWithoutLogin;
import com.chinamobile.ysx.okhttp.Call;
import com.chinamobile.ysx.okhttp.Callback;
import com.chinamobile.ysx.okhttp.Response;
import com.chinamobile.ysx.utils.AppUtil;
import com.chinamobile.ysx.utils.OkHttpManage;
import java.io.IOException;
import java.util.HashMap;
import us.zoom.sdk.DialOutStatusListener;
import us.zoom.sdk.InstantMeetingOptions;
import us.zoom.sdk.JoinMeetingOptions;
import us.zoom.sdk.JoinMeetingParams;
import us.zoom.sdk.MeetingOptions;
import us.zoom.sdk.MeetingService;
import us.zoom.sdk.MeetingServiceListener;
import us.zoom.sdk.MeetingStatus;
import us.zoom.sdk.StartMeetingOptions;
import us.zoom.sdk.StartMeetingParams;
import us.zoom.sdk.StartMeetingParams4APIUser;
import us.zoom.sdk.StartMeetingParams4NormalUser;
import us.zoom.sdk.StartMeetingParamsWithoutLogin;
import us.zoom.sdk.ZoomSDK;

public class YSXMeetingServiceImpl
implements YSXMeetingService,
MeetingServiceListener,
DialOutStatusListener {
    private static final String TAG = YSXMeetingServiceImpl.class.getName();
    YSXSdk mYsxSDK = null;
    YSXMeetingServiceListener ysxMeetingServiceListener;
    YSXDialOutStatusListener zmDialOutStatusListener;
    YSXMessageListener ysxMessageListener;
    Handler handler = new Handler();
    int limitCount = 2;
    String meetingId;
    String meetingNo;
    int meetingType;
    String topic;
    String participants;
    String meetingTy;
    private final String INSTANCEMEETING = "instance";
    private final String STARTMEETING = "start";
    private final String JOINMEETING = "join";
    CountDownTimer countDownTimer;
    private boolean isFirstShow = true;
    private HashMap<String, Object> notifyMap;
    private HashMap<String, Object> creatInstanceMap;
    private HashMap<String, Object> postInviteMap;

    public YSXMeetingServiceImpl(YSXSdk ysxSdk) {
        this.mYsxSDK = ysxSdk;
    }

    private MeetingService getMeetingService() {
        ZoomSDK zoomSDK = ZoomSDK.getInstance();
        MeetingService meetingService = null;
        if (zoomSDK.isInitialized()) {
            meetingService = zoomSDK.getMeetingService();
        }
        return meetingService;
    }

    private StartMeetingOptions getStartMeetingOpts(YSXStartMeetingOptions options) {
        StartMeetingOptions opts = new StartMeetingOptions();
        if (options != null) {
            ((Object)((Object)options)).getClass();
            opts.no_driving_mode = false;
            opts.no_invite = options.no_invite;
            opts.no_meeting_end_message = options.no_meeting_end_message;
            opts.no_meeting_error_message = options.no_meeting_error_message;
            opts.no_titlebar = options.no_titlebar;
            opts.no_bottom_toolbar = options.no_bottom_toolbar;
            ((Object)((Object)options)).getClass();
            opts.no_dial_in_via_phone = false;
            ((Object)((Object)options)).getClass();
            opts.no_dial_out_to_phone = false;
            opts.no_disconnect_audio = options.no_disconnect_audio;
            opts.no_share = options.no_share;
            opts.no_video = options.no_video;
            opts.invite_options = options.invite_options;
            opts.meeting_views_options = options.meeting_views_options;
            opts.participant_id = options.participant_id;
            opts.custom_meeting_id = options.custom_meeting_id;
            opts.no_audio = options.no_audio;
        }
        return opts;
    }

    private StartMeetingParams4NormalUser getStartMeetingParamsNormalUser(YSXStartMeetingParams params) {
        StartMeetingParams4NormalUser startMeetingParams = new StartMeetingParams4NormalUser();
        startMeetingParams.meetingNo = params.meetingNo;
        startMeetingParams.vanityID = params.vanityID;
        return startMeetingParams;
    }

    private StartMeetingParams4APIUser getStartMeetingParams4APIUser(YSXStartMeetingParams params) {
        if (params instanceof YSXStartMeetingParams4APIUser) {
            StartMeetingParams4APIUser startMeetingParams4APIUser = new StartMeetingParams4APIUser();
            startMeetingParams4APIUser.meetingNo = params.meetingNo;
            startMeetingParams4APIUser.vanityID = params.vanityID;
            startMeetingParams4APIUser.displayName = ((YSXStartMeetingParams4APIUser)params).displayName;
            startMeetingParams4APIUser.userId = ((YSXStartMeetingParams4APIUser)params).userId;
            startMeetingParams4APIUser.zoomToken = ((YSXStartMeetingParams4APIUser)params).zoomToken;
            return startMeetingParams4APIUser;
        }
        return null;
    }

    private StartMeetingParamsWithoutLogin getStartMeetingParamsWithoutLogin(YSXStartMeetingParams params) {
        if (params instanceof YSXStartMeetingParamsWithoutLogin) {
            StartMeetingParamsWithoutLogin startMeetingParamsWithoutLogin = new StartMeetingParamsWithoutLogin();
            startMeetingParamsWithoutLogin.meetingNo = params.meetingNo;
            startMeetingParamsWithoutLogin.vanityID = params.vanityID;
            startMeetingParamsWithoutLogin.displayName = ((YSXStartMeetingParamsWithoutLogin)params).displayName;
            startMeetingParamsWithoutLogin.userId = ((YSXStartMeetingParamsWithoutLogin)params).userId;
            startMeetingParamsWithoutLogin.userType = ((YSXStartMeetingParamsWithoutLogin)params).userType;
            startMeetingParamsWithoutLogin.zoomAccessToken = ((YSXStartMeetingParamsWithoutLogin)params).zoomAccessToken;
            startMeetingParamsWithoutLogin.zoomToken = ((YSXStartMeetingParamsWithoutLogin)params).zoomToken;
            return startMeetingParamsWithoutLogin;
        }
        return null;
    }

    private InstantMeetingOptions getInstantMeetingOpts(YSXInstantMeetingOptions options) {
        InstantMeetingOptions opts = new InstantMeetingOptions();
        if (options != null) {
            opts.no_driving_mode = options.no_driving_mode;
            opts.no_invite = options.no_invite;
            opts.no_meeting_end_message = options.no_meeting_end_message;
            opts.no_meeting_error_message = options.no_meeting_error_message;
            opts.no_titlebar = options.no_titlebar;
            opts.no_bottom_toolbar = options.no_bottom_toolbar;
            opts.no_dial_in_via_phone = options.no_dial_in_via_phone;
            opts.no_dial_out_to_phone = options.no_dial_out_to_phone;
            opts.no_disconnect_audio = options.no_disconnect_audio;
            opts.no_share = options.no_share;
            opts.no_video = options.no_video;
            opts.invite_options = options.invite_options;
            opts.meeting_views_options = options.meeting_views_options;
            opts.participant_id = options.participant_id;
            opts.custom_meeting_id = options.custom_meeting_id;
        }
        return opts;
    }

    private InstantMeetingOptions getInstantMeetingOptsFromStartOptions(YSXStartMeetingOptions options) {
        InstantMeetingOptions opts = new InstantMeetingOptions();
        if (options != null) {
            ((Object)((Object)options)).getClass();
            opts.no_driving_mode = false;
            opts.no_invite = options.no_invite;
            opts.no_meeting_end_message = options.no_meeting_end_message;
            opts.no_meeting_error_message = options.no_meeting_error_message;
            opts.no_titlebar = options.no_titlebar;
            opts.no_bottom_toolbar = options.no_bottom_toolbar;
            ((Object)((Object)options)).getClass();
            opts.no_dial_in_via_phone = false;
            ((Object)((Object)options)).getClass();
            opts.no_dial_out_to_phone = false;
            opts.no_disconnect_audio = options.no_disconnect_audio;
            opts.no_share = options.no_share;
            opts.no_video = options.no_video;
            opts.invite_options = options.invite_options;
            opts.meeting_views_options = options.meeting_views_options;
            opts.participant_id = options.participant_id;
            opts.custom_meeting_id = options.custom_meeting_id;
        }
        return opts;
    }

    private JoinMeetingOptions getJoinMeetingOptions(YSXJoinMeetingOptions options) {
        JoinMeetingOptions opts = new JoinMeetingOptions();
        if (options != null) {
            opts.no_driving_mode = options.no_driving_mode;
            opts.no_invite = options.no_invite;
            opts.no_meeting_end_message = options.no_meeting_end_message;
            opts.no_meeting_error_message = options.no_meeting_error_message;
            opts.no_titlebar = options.no_titlebar;
            opts.no_bottom_toolbar = options.no_bottom_toolbar;
            ((Object)((Object)options)).getClass();
            opts.no_dial_in_via_phone = false;
            ((Object)((Object)options)).getClass();
            opts.no_dial_out_to_phone = false;
            opts.no_disconnect_audio = options.no_disconnect_audio;
            opts.no_share = options.no_share;
            opts.no_video = options.no_video;
            opts.invite_options = options.invite_options;
            opts.meeting_views_options = options.meeting_views_options;
            opts.participant_id = options.participant_id;
            opts.custom_meeting_id = options.custom_meeting_id;
            opts.no_audio = options.no_audio;
            opts.webinar_token = options.webinar_token;
        }
        return opts;
    }

    @Override
    public void addListener(YSXMeetingServiceListener listener) {
        this.ysxMeetingServiceListener = listener;
        MeetingService meetingService = this.getMeetingService();
        if (meetingService != null) {
            meetingService.addListener((MeetingServiceListener)this);
        }
    }

    @Override
    public void removeListener(YSXMeetingServiceListener listener) {
        this.ysxMeetingServiceListener = listener;
        MeetingService meetingService = this.getMeetingService();
        if (meetingService != null) {
            meetingService.removeListener((MeetingServiceListener)this);
        }
    }

    @Override
    public void addDialOutListener(YSXDialOutStatusListener listener) {
        this.zmDialOutStatusListener = listener;
        MeetingService meetingService = this.getMeetingService();
        if (meetingService != null) {
            meetingService.addDialOutListener((DialOutStatusListener)this);
        }
    }

    @Override
    public void removeDialOutListener(YSXDialOutStatusListener listener) {
        this.zmDialOutStatusListener = listener;
        MeetingService meetingService = this.getMeetingService();
        if (meetingService != null) {
            meetingService.removeDialOutListener((DialOutStatusListener)this);
        }
    }

    @Override
    public int startMeeting(final Context context, String meetingId, final int userType, int meetingType, final String meetingNo, final String displayName, final YSXStartMeetingOptions opts, final YSXMessageListener ysxMessageListener) {
        this.ysxMessageListener = ysxMessageListener;
        this.meetingId = meetingId;
        this.meetingNo = meetingNo;
        this.meetingType = meetingType;
        this.meetingTy = "start";
        if (TextUtils.isEmpty((CharSequence)meetingId)) {
            Toast.makeText((Context)context, (CharSequence)context.getResources().getString(R.string.needmeetingid), (int)0).show();
            return -1;
        }
        if (TextUtils.isEmpty((CharSequence)meetingNo)) {
            Toast.makeText((Context)context, (CharSequence)context.getResources().getString(R.string.needmeetingnum), (int)0).show();
            return -1;
        }
        if (AppUtil.getInstance().getYSXUser().isTrial()) {
            OkHttpManage.getInstance().queryNotVipCount(new YSXMeetingCountCallBackListener(){

                @Override
                public void countCallBackSuccess(int count) {
                    if (count < YSXMeetingServiceImpl.this.limitCount) {
                        MeetingService meetingService = YSXMeetingServiceImpl.this.getMeetingService();
                        if (meetingService != null) {
                            int rec = meetingService.startMeeting(context, AppUtil.getInstance().getYSXUser().getUserId(), AppUtil.getInstance().getYSXUser().getToken(), userType, meetingNo, displayName, (MeetingOptions)YSXMeetingServiceImpl.this.getStartMeetingOpts(opts));
                            ysxMessageListener.onCallBack(rec, "");
                        }
                    } else {
                        ysxMessageListener.onCallBack(601, context.getResources().getString(R.string.limittwo));
                    }
                }

                @Override
                public void countCallBackFail(int code, String msg) {
                    ysxMessageListener.onCallBack(602, context.getResources().getString(R.string.cannotgettimes));
                }
            });
        } else {
            MeetingService meetingService = this.getMeetingService();
            if (meetingService != null) {
                int rec = meetingService.startMeeting(context, AppUtil.getInstance().getYSXUser().getUserId(), AppUtil.getInstance().getYSXUser().getToken(), userType, String.valueOf(meetingNo), displayName, (MeetingOptions)this.getStartMeetingOpts(opts));
                ysxMessageListener.onCallBack(rec, "");
            }
        }
        return -1;
    }

    @Override
    public int startMeetingWithParams(final Context context, String meetingId, int meetingType, String meetingNo, final YSXStartMeetingParams params, final YSXStartMeetingOptions options, final YSXMessageListener ysxMessageListener) {
        this.ysxMessageListener = ysxMessageListener;
        this.meetingId = meetingId;
        this.meetingNo = meetingNo;
        this.meetingType = meetingType;
        this.meetingTy = "start";
        if (TextUtils.isEmpty((CharSequence)meetingId)) {
            Toast.makeText((Context)context, (CharSequence)context.getResources().getString(R.string.needmeetingid), (int)0).show();
            return -1;
        }
        if (TextUtils.isEmpty((CharSequence)meetingNo)) {
            Toast.makeText((Context)context, (CharSequence)context.getResources().getString(R.string.needmeetingnum), (int)0).show();
            return -1;
        }
        if (AppUtil.getInstance().getYSXUser().isTrial()) {
            OkHttpManage.getInstance().queryNotVipCount(new YSXMeetingCountCallBackListener(){

                @Override
                public void countCallBackSuccess(int count) {
                    if (count < YSXMeetingServiceImpl.this.limitCount) {
                        MeetingService meetingService = YSXMeetingServiceImpl.this.getMeetingService();
                        if (meetingService != null) {
                            int rec = -1;
                            if (params instanceof YSXStartMeetingParams || params instanceof YSXStartMeetingParams4NormalUser) {
                                rec = meetingService.startMeetingWithParams(context, (StartMeetingParams)YSXMeetingServiceImpl.this.getStartMeetingParamsNormalUser(params), YSXMeetingServiceImpl.this.getStartMeetingOpts(options));
                            }
                            if (params instanceof YSXStartMeetingParamsWithoutLogin) {
                                rec = meetingService.startMeetingWithParams(context, (StartMeetingParams)YSXMeetingServiceImpl.this.getStartMeetingParamsWithoutLogin(params), YSXMeetingServiceImpl.this.getStartMeetingOpts(options));
                            }
                            if (params instanceof YSXStartMeetingParams4APIUser) {
                                rec = meetingService.startMeetingWithParams(context, (StartMeetingParams)YSXMeetingServiceImpl.this.getStartMeetingParams4APIUser(params), YSXMeetingServiceImpl.this.getStartMeetingOpts(options));
                            }
                            ysxMessageListener.onCallBack(rec, "");
                        }
                    } else {
                        ysxMessageListener.onCallBack(601, context.getResources().getString(R.string.limittwo));
                    }
                }

                @Override
                public void countCallBackFail(int code, String msg) {
                    ysxMessageListener.onCallBack(602, context.getResources().getString(R.string.cannotgettimes));
                }
            });
        } else {
            MeetingService meetingService = this.getMeetingService();
            if (meetingService != null) {
                int rec = -1;
                if (params instanceof YSXStartMeetingParams || params instanceof YSXStartMeetingParams4NormalUser) {
                    rec = meetingService.startMeetingWithParams(context, (StartMeetingParams)this.getStartMeetingParamsNormalUser(params), this.getStartMeetingOpts(options));
                }
                if (params instanceof YSXStartMeetingParamsWithoutLogin) {
                    rec = meetingService.startMeetingWithParams(context, (StartMeetingParams)this.getStartMeetingParamsWithoutLogin(params), this.getStartMeetingOpts(options));
                }
                if (params instanceof YSXStartMeetingParams4APIUser) {
                    rec = meetingService.startMeetingWithParams(context, (StartMeetingParams)this.getStartMeetingParams4APIUser(params), this.getStartMeetingOpts(options));
                }
                ysxMessageListener.onCallBack(rec, "");
            }
        }
        return -1;
    }

    @Override
    public int startInstantMeeting(final Context context, String topic, String participant, final YSXInstantMeetingOptions opts, final YSXMessageListener messageListener) {
        this.ysxMessageListener = messageListener;
        this.topic = topic;
        this.participants = participant;
        this.meetingTy = "instance";
        if (TextUtils.isEmpty((CharSequence)topic)) {
            Toast.makeText((Context)context, (CharSequence)context.getResources().getString(R.string.pleaseinputtopic), (int)0).show();
            return -1;
        }
        if (AppUtil.getInstance().getYSXUser().isTrial()) {
            OkHttpManage.getInstance().queryNotVipCount(new YSXMeetingCountCallBackListener(){

                @Override
                public void countCallBackSuccess(int count) {
                    if (count < YSXMeetingServiceImpl.this.limitCount) {
                        MeetingService meetingService = YSXMeetingServiceImpl.this.getMeetingService();
                        if (meetingService != null) {
                            int rec = meetingService.startInstantMeeting(context, (MeetingOptions)YSXMeetingServiceImpl.this.getInstantMeetingOpts(opts));
                            messageListener.onCallBack(rec, "");
                        }
                    } else {
                        messageListener.onCallBack(601, context.getResources().getString(R.string.limittwo));
                    }
                }

                @Override
                public void countCallBackFail(int code, String msg) {
                    messageListener.onCallBack(602, context.getResources().getString(R.string.cannotgettimes));
                }
            });
        } else {
            MeetingService meetingService = this.getMeetingService();
            if (meetingService != null) {
                int rec = meetingService.startInstantMeeting(context, (MeetingOptions)this.getInstantMeetingOpts(opts));
                messageListener.onCallBack(rec, "");
            }
        }
        return -1;
    }

    @Override
    public int joinMeeting(final Context context, String meetingId, final String meetingNo, int meetingType, final String displayName, final String password, final YSXJoinMeetingOptions opts, final YSXMessageListener ysxMessageListener) {
        this.ysxMessageListener = ysxMessageListener;
        this.meetingId = meetingId;
        this.meetingNo = meetingNo;
        this.meetingType = meetingType;
        this.meetingTy = "join";
        if (TextUtils.isEmpty((CharSequence)meetingId)) {
            Toast.makeText((Context)context, (CharSequence)context.getResources().getString(R.string.needmeetingid), (int)0).show();
            return -1;
        }
        if (TextUtils.isEmpty((CharSequence)meetingNo)) {
            Toast.makeText((Context)context, (CharSequence)context.getResources().getString(R.string.needmeetingnum), (int)0).show();
            return -1;
        }
        if (AppUtil.getInstance().getYSXUser().isTrial()) {
            OkHttpManage.getInstance().queryNotVipCount(new YSXMeetingCountCallBackListener(){

                @Override
                public void countCallBackSuccess(int count) {
                    if (count < YSXMeetingServiceImpl.this.limitCount) {
                        MeetingService meetingService = YSXMeetingServiceImpl.this.getMeetingService();
                        if (meetingService != null) {
                            int rec = meetingService.joinMeeting(context, meetingNo, displayName, password, (MeetingOptions)YSXMeetingServiceImpl.this.getJoinMeetingOptions(opts));
                            ysxMessageListener.onCallBack(rec, "");
                        }
                    } else {
                        ysxMessageListener.onCallBack(601, context.getResources().getString(R.string.limittwo));
                    }
                }

                @Override
                public void countCallBackFail(int code, String msg) {
                    ysxMessageListener.onCallBack(602, context.getResources().getString(R.string.cannotgettimes));
                }
            });
        } else {
            MeetingService meetingService = this.getMeetingService();
            if (meetingService != null) {
                int rec = meetingService.joinMeeting(context, meetingNo, displayName, password, (MeetingOptions)this.getJoinMeetingOptions(opts));
                ysxMessageListener.onCallBack(rec, "");
            }
        }
        return -1;
    }

    @Override
    public int joinMeetingWithParams(final Context context, String meetingId, String meetingNo, int meetingType, final YSXJoinMeetingParams params, final YSXJoinMeetingOptions options, final YSXMessageListener ysxMessageListener) {
        this.ysxMessageListener = ysxMessageListener;
        this.meetingId = meetingId;
        this.meetingNo = meetingNo;
        this.meetingType = meetingType;
        this.meetingTy = "join";
        if (TextUtils.isEmpty((CharSequence)meetingId)) {
            Toast.makeText((Context)context, (CharSequence)context.getResources().getString(R.string.needmeetingid), (int)0).show();
            return -1;
        }
        if (TextUtils.isEmpty((CharSequence)meetingNo)) {
            Toast.makeText((Context)context, (CharSequence)context.getResources().getString(R.string.needmeetingnum), (int)0).show();
            return -1;
        }
        if (AppUtil.getInstance().getYSXUser().isTrial()) {
            OkHttpManage.getInstance().queryNotVipCount(new YSXMeetingCountCallBackListener(){

                @Override
                public void countCallBackSuccess(int count) {
                    if (count < YSXMeetingServiceImpl.this.limitCount) {
                        MeetingService meetingService = YSXMeetingServiceImpl.this.getMeetingService();
                        if (meetingService != null) {
                            int rec = meetingService.joinMeetingWithParams(context, (JoinMeetingParams)params, YSXMeetingServiceImpl.this.getJoinMeetingOptions(options));
                            ysxMessageListener.onCallBack(rec, "");
                        }
                    } else {
                        ysxMessageListener.onCallBack(601, context.getResources().getString(R.string.limittwo));
                    }
                }

                @Override
                public void countCallBackFail(int code, String msg) {
                    ysxMessageListener.onCallBack(602, context.getResources().getString(R.string.cannotgettimes));
                }
            });
        } else {
            MeetingService meetingService = this.getMeetingService();
            if (meetingService != null) {
                int rec = meetingService.joinMeetingWithParams(context, (JoinMeetingParams)params, this.getJoinMeetingOptions(options));
                ysxMessageListener.onCallBack(rec, "");
            }
        }
        return -1;
    }

    @Override
    public YSXMeetingStatus getMeetingStatus() {
        MeetingService meetingService = this.getMeetingService();
        if (meetingService != null) {
            return this.transferMeetingStatus(meetingService.getMeetingStatus());
        }
        return null;
    }

    @Override
    public void leaveCurrentMeeting(boolean endIfPossible) {
        MeetingService meetingService = this.getMeetingService();
        if (meetingService != null) {
            meetingService.leaveCurrentMeeting(endIfPossible);
        }
    }

    @Override
    public void pauseCurrentMeeting() {
        MeetingService meetingService = this.getMeetingService();
        if (meetingService != null) {
            meetingService.pauseCurrentMeeting();
        }
    }

    @Override
    public void resumeCurrentMeeting() {
        MeetingService meetingService = this.getMeetingService();
        if (meetingService != null) {
            meetingService.resumeCurrentMeeting();
        }
    }

    @Override
    public void returnToMeeting(Context context) {
        MeetingService meetingService = this.getMeetingService();
        if (meetingService != null) {
            meetingService.returnToMeeting(context);
        }
    }

    @Override
    public String getCurrentMeetingID() {
        MeetingService meetingService = this.getMeetingService();
        if (meetingService != null) {
            return meetingService.getCurrentRtcMeetingID();
        }
        return "";
    }

    @Override
    public long getCurrentMeetingNumber() {
        MeetingService meetingService = this.getMeetingService();
        if (meetingService != null) {
            return meetingService.getCurrentRtcMeetingNumber();
        }
        return 0L;
    }

    @Override
    public String getCurrentMeetingUrl() {
        MeetingService meetingService = this.getMeetingService();
        if (meetingService != null) {
            return meetingService.getCurrentMeetingUrl();
        }
        return null;
    }

    @Override
    public boolean isCurrentMeetingLocked() {
        MeetingService meetingService = this.getMeetingService();
        if (meetingService != null) {
            return meetingService.isCurrentMeetingLocked();
        }
        return false;
    }

    @Override
    public boolean isCurrentMeetingHost() {
        MeetingService meetingService = this.getMeetingService();
        if (meetingService != null) {
            return meetingService.isCurrentMeetingHost();
        }
        return false;
    }

    @Override
    public boolean dialOutUser(String number, String userName, boolean isCallMe) {
        MeetingService meetingService = this.getMeetingService();
        if (meetingService != null) {
            return meetingService.dialOutUser(number, userName, isCallMe);
        }
        return false;
    }

    @Override
    public boolean cancelDialOut(boolean isCallMe) {
        MeetingService meetingService = this.getMeetingService();
        if (meetingService != null) {
            return meetingService.cancelDialOut(isCallMe);
        }
        return false;
    }

    @Override
    public boolean isDialOutInProgress() {
        MeetingService meetingService = this.getMeetingService();
        if (meetingService != null) {
            return meetingService.isDialOutInProgress();
        }
        return false;
    }

    @Override
    public boolean isDialoutSupported() {
        MeetingService meetingService = this.getMeetingService();
        if (meetingService != null) {
            return meetingService.isDialoutSupported();
        }
        return false;
    }

    @Override
    public boolean isInviteRoomSystemSupported() {
        MeetingService meetingService = this.getMeetingService();
        if (meetingService != null) {
            return meetingService.isInviteRoomSystemSupported();
        }
        return false;
    }

    @Override
    public boolean tryRetrieveMicrophone() {
        MeetingService meetingService = this.getMeetingService();
        if (meetingService != null) {
            return meetingService.tryRetrieveMicrophone();
        }
        return false;
    }

    public void onDialOutStatusChanged(int status) {
        this.zmDialOutStatusListener.onDialOutStatusChanged(status);
    }

    private void notifyMeetingStatusChange(int status, String meetingId, String meetingNo) {
        if (this.notifyMap == null) {
            this.notifyMap = new HashMap();
        }
        this.notifyMap.put("Status", status);
        this.notifyMap.put("Token", AppUtil.getInstance().getYSXUser().getToken());
        this.notifyMap.put("MeetingId", meetingId);
        this.notifyMap.put("MeetingNo", Long.parseLong(meetingNo));
        OkHttpManage.getInstance().notifyMeetingStatusChange("https://api.125339.com.cn/message/meetingStatusChange", this.notifyMap, new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                Log.e((String)"ex", (String)e.toString());
            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                Log.e((String)"response", (String)response.body().string());
            }
        });
    }

    private void createInstanceMeeting(String topic, String participants) {
        if (this.creatInstanceMap == null) {
            this.creatInstanceMap = new HashMap();
        }
        this.creatInstanceMap.put("MeetingId", this.meetingId);
        this.creatInstanceMap.put("Topic", topic);
        this.creatInstanceMap.put("Participants", participants);
        this.creatInstanceMap.put("MeetingNo", Long.parseLong(this.meetingNo));
        this.creatInstanceMap.put("OpenHostVideo", true);
        this.creatInstanceMap.put("Token", AppUtil.getInstance().getYSXUser().getToken());
        OkHttpManage.getInstance().createInstanceMeeting("https://api.125339.com.cn/meeting/createInstantMeeting", this.creatInstanceMap, new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                YSXMeetingServiceImpl.this.notifyMeetingStatusChange(3, YSXMeetingServiceImpl.this.meetingId, YSXMeetingServiceImpl.this.meetingNo);
            }
        });
    }

    private void postInviteMeeting(int action) {
        if (this.postInviteMap == null) {
            this.postInviteMap = new HashMap();
        }
        this.postInviteMap.put("Ticket", AppUtil.getInstance().getYSXUser().getApiTicket());
        this.postInviteMap.put("MeetingId", this.meetingId);
        this.postInviteMap.put("MeetingNo", Long.parseLong(this.meetingNo));
        this.postInviteMap.put("Action", action);
        this.postInviteMap.put("Token", AppUtil.getInstance().getYSXUser().getToken());
        OkHttpManage.getInstance().postInviteMeeting("https://api.125339.com.cn/message/inviteAnswer", this.postInviteMap, new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                Log.e((String)"ex", (String)e.toString());
            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                Log.e((String)"response", (String)response.body().string());
            }
        });
    }

    @Override
    public void postInviteAnswer(String meetingId, String meetingNo, int action) {
        if (this.postInviteMap == null) {
            this.postInviteMap = new HashMap();
        }
        this.postInviteMap.put("Ticket", AppUtil.getInstance().getYSXUser().getApiTicket());
        this.postInviteMap.put("MeetingId", meetingId);
        this.postInviteMap.put("MeetingNo", Long.parseLong(meetingNo));
        this.postInviteMap.put("Action", action);
        this.postInviteMap.put("Token", AppUtil.getInstance().getYSXUser().getToken());
        OkHttpManage.getInstance().postInviteMeeting("https://api.125339.com.cn/message/inviteAnswer", this.postInviteMap, new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                Log.e((String)"ex", (String)e.toString());
            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                Log.e((String)"response", (String)response.body().string());
            }
        });
    }

    private YSXMeetingStatus transferMeetingStatus(MeetingStatus status) {
        if (MeetingStatus.MEETING_STATUS_IDLE == status) {
            return YSXMeetingStatus.MEETING_STATUS_IDLE;
        }
        if (MeetingStatus.MEETING_STATUS_CONNECTING == status) {
            return YSXMeetingStatus.MEETING_STATUS_CONNECTING;
        }
        if (MeetingStatus.MEETING_STATUS_WAITINGFORHOST == status) {
            return YSXMeetingStatus.MEETING_STATUS_WAITINGFORHOST;
        }
        if (MeetingStatus.MEETING_STATUS_INMEETING == status) {
            return YSXMeetingStatus.MEETING_STATUS_INMEETING;
        }
        if (MeetingStatus.MEETING_STATUS_DISCONNECTING == status) {
            return YSXMeetingStatus.MEETING_STATUS_DISCONNECTING;
        }
        if (MeetingStatus.MEETING_STATUS_RECONNECTING == status) {
            return YSXMeetingStatus.MEETING_STATUS_RECONNECTING;
        }
        if (MeetingStatus.MEETING_STATUS_FAILED == status) {
            return YSXMeetingStatus.MEETING_STATUS_FAILED;
        }
        if (MeetingStatus.MEETING_STATUS_IN_WAITING_ROOM == status) {
            return YSXMeetingStatus.MEETING_STATUS_IN_WAITING_ROOM;
        }
        return YSXMeetingStatus.MEETING_STATUS_UNKNOWN;
    }

    public void onMeetingStatusChanged(MeetingStatus meetingStatus, int errorCode, int internalErrorCode) {
        Log.i((String)TAG, (String)("onMeetingEvent, meetingEvent=" + meetingStatus + ", errorCode=" + errorCode + ", internalErrorCode=" + internalErrorCode));
        if (AppUtil.getInstance().getYSXUser().isTrial()) {
            if (meetingStatus == MeetingStatus.MEETING_STATUS_INMEETING) {
                if (meetingStatus == MeetingStatus.MEETING_STATUS_DISCONNECTING) {
                    if (this.countDownTimer != null) {
                        this.countDownTimer.cancel();
                    }
                } else {
                    this.isFirstShow = true;
                    if (this.countDownTimer == null) {
                        this.countDownTimer = new CountDownTimer(1800000L, 5000L){

                            public void onTick(long millisUntilFinished) {
                                if (millisUntilFinished <= 300000L && YSXMeetingServiceImpl.this.isFirstShow) {
                                    if (YSXMeetingServiceImpl.this.ysxMessageListener != null) {
                                        YSXMeetingServiceImpl.this.ysxMessageListener.onCallBack(603, "Leave the meeting in five minutes");
                                    }
                                    YSXMeetingServiceImpl.this.isFirstShow = false;
                                }
                            }

                            public void onFinish() {
                                YSXMeetingServiceImpl.this.getMeetingService().leaveCurrentMeeting(false);
                            }
                        };
                    }
                    this.countDownTimer.cancel();
                    this.countDownTimer.start();
                }
            }
        }
        if (meetingStatus == MeetingStatus.MEETING_STATUS_DISCONNECTING && this.countDownTimer != null) {
            this.countDownTimer.cancel();
        }
        int status = 0;
        if (MeetingStatus.MEETING_STATUS_INMEETING == meetingStatus) {
            status = 3;
            ZoomSDK zoomSDK = ZoomSDK.getInstance();
            MeetingService service = zoomSDK.getMeetingService();
            if (this.meetingTy.equals("instance")) {
                this.meetingNo = String.valueOf(service.getCurrentRtcMeetingNumber());
                this.meetingId = service.getCurrentRtcMeetingID();
                this.createInstanceMeeting(this.topic, this.participants);
            } else {
                this.notifyMeetingStatusChange(status, this.meetingId, this.meetingNo);
            }
            if (this.meetingTy.equals("join") && this.meetingType == 1) {
                this.postInviteMeeting(1);
            }
        }
        if (MeetingStatus.MEETING_STATUS_FAILED == meetingStatus) {
            status = 6;
            this.notifyMeetingStatusChange(status, this.meetingId, this.meetingNo);
        }
        if (MeetingStatus.MEETING_STATUS_DISCONNECTING == meetingStatus) {
            status = 7;
            this.notifyMeetingStatusChange(status, this.meetingId, this.meetingNo);
        }
        this.ysxMeetingServiceListener.onMeetingStatusChanged(this.transferMeetingStatus(meetingStatus), errorCode, internalErrorCode);
    }
}

