/*
 * Decompiled with CFR 0.152.
 */
package com.chinamobile.ysx.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import com.chinamobile.ysx.bean.Company;
import com.chinamobile.ysx.bean.Department;
import com.chinamobile.ysx.bean.Employee;
import com.chinamobile.ysx.db.DbUpdateCallback;
import com.chinamobile.ysx.utils.AppUtil;
import com.chinamobile.ysx.utils.PinYin;
import com.chinamobile.ysx.utils.StringUtil;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class DBOpenHelper
extends SQLiteOpenHelper {
    private static DBOpenHelper databaseHelper = null;
    public static final String EMPLOYEE = "employee";
    public static final String DEPARTMENT = "department";
    public static final String COMPANY = "company";
    public static final String companyName = "companyName";
    public static final String companyId = "companyId";
    public static final String companyDepartmentNum = "conpanyDepartmentNum";
    public static final String companyUserNum = "conpanyUserNum";
    public static final String departsName = "departName";
    public static final String departsId = "departId";
    public static final String departsSuperiorDepartmentId = "departsSuperiorDepartmentId";
    public static final String departsStatus = "departsStatus";
    public static final String departsUserNum = "departsUserNum";
    public static final String employeeName = "employeeName";
    public static final String employeeId = "employeeId";
    public static final String employeeMobile = "employeeMobile";
    public static final String employeeBelongCompanyId = "belongCompanyId";
    public static final String employeeBelongDepartmentId = "belongDepartmentId";
    public static final String employeeHeadPath = "headPath";
    public static final String employeeStatus = "employeeStatus";
    public static final String employeeAuthority = "Authority";
    public static final String pinyin = "pinyin";
    static String companyStr = "companyName,conpanyDepartmentNum,conpanyUserNum";
    static String departmentStr = "companyId,companyName,departName,departsSuperiorDepartmentId,departsStatus,departsUserNum";
    static String employeeStr = "companyId,companyName,departId,departName,employeeName,employeeMobile,belongCompanyId,belongDepartmentId,headPath,employeeStatus,Authority,pinyin";
    public static final String[] companyTableArray = DBOpenHelper.getTableArray(companyStr);
    public static final String[] departmentTableArray = DBOpenHelper.getTableArray(departmentStr);
    public static final String[] employeeTableArray = DBOpenHelper.getTableArray(employeeStr);
    public static final String[] companyColumArray = DBOpenHelper.getColumArray("companyId," + companyStr);
    public static final String[] departmentColumArray = DBOpenHelper.getColumArray("departId," + departmentStr);
    public static final String[] employeeColumArray = DBOpenHelper.getColumArray("employeeId," + employeeStr);
    public static final String employee = DBOpenHelper.createTable("employee", DBOpenHelper.getTableStr(employeeTableArray), "employeeId");
    public static final String department = DBOpenHelper.createTable("department", DBOpenHelper.getTableStr(departmentTableArray), "departId");
    public static final String company = DBOpenHelper.createTable("company", DBOpenHelper.getTableStr(companyTableArray), "companyId");
    static int version = 4;
    public static boolean isDbNameChange = false;

    private static String createTable(String table, String tableFields, String key) {
        return "create table IF NOT EXISTS " + table + "(" + key + " varchar(50) PRIMARY KEY ," + tableFields + ")";
    }

    private static String[] getTableArray(String str) {
        if (StringUtil.isEmptyOrNull(str)) {
            return null;
        }
        String[] array = str.split(",");
        return array;
    }

    private static String getTableStr(String[] array) {
        if (array == null || array.length <= 0) {
            return "";
        }
        String str = "";
        for (int i = 0; i < array.length; ++i) {
            if (i == 0) {
                str = array[i] + " varchar(50)";
                continue;
            }
            if (i == array.length - 1) {
                str = str + "," + array[i] + " varchar(50)";
                continue;
            }
            if (i <= 0 || i == array.length - 1) continue;
            str = str + "," + array[i] + " varchar(50)";
        }
        return str;
    }

    private static String[] getColumArray(String str) {
        if (StringUtil.isEmptyOrNull(str)) {
            return null;
        }
        str = "_id," + str;
        String[] array = str.split(",");
        return array;
    }

    public static synchronized DBOpenHelper getInstance(Context context) {
        if (databaseHelper == null) {
            databaseHelper = new DBOpenHelper(context);
        }
        String dataPath = databaseHelper.getWritableDatabase().getPath();
        Log.e((String)"dataPath...............", (String)(AppUtil.getInstance().getCompanyId() + " dataPath: " + dataPath));
        if (!StringUtil.isEmptyOrNull(AppUtil.getInstance().getCompanyId()) && dataPath != null && dataPath.indexOf(AppUtil.getInstance().getCompanyId()) < 0) {
            databaseHelper.close();
            databaseHelper = new DBOpenHelper(context);
            isDbNameChange = true;
            Log.e((String)"dataPath", (String)".........new ......");
        } else {
            isDbNameChange = false;
        }
        return databaseHelper;
    }

    public DBOpenHelper(Context context) {
        super(context, AppUtil.getInstance().getCompanyId() + "_db.db", null, version);
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL(employee);
        db.execSQL(department);
        db.execSQL(company);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        Log.e((String)"Upgrading ", (String)(oldVersion + " to " + newVersion + ", which will destroy all old data"));
        DbUpdateCallback.getInstance().onDBUpdate(oldVersion, newVersion);
        db.execSQL("DROP TABLE IF EXISTS employee");
        db.execSQL("DROP TABLE IF EXISTS department");
        db.execSQL("DROP TABLE IF EXISTS company");
        db.execSQL(employee);
        db.execSQL(department);
        db.execSQL(company);
    }

    public synchronized void onInsert(Company company, List<Department> departmentList, List<Employee> employeeList) {
        int status;
        if (company == null) {
            return;
        }
        ContentValues companyValues = this.getCompanyValues(company);
        this.onUpdate(COMPANY, companyValues, "companyId =? ", new String[]{company.getCompanyId()});
        if (departmentList != null && departmentList.size() > 0) {
            for (int i = 0; i < departmentList.size(); ++i) {
                Department depart = departmentList.get(i);
                if (depart == null) continue;
                ContentValues departValues = this.getDepartValues(company, depart);
                status = depart.getStatus();
                if (status == 0) {
                    this.onDelete(DEPARTMENT, "departId =? ", new String[]{depart.getDepartsId()});
                    continue;
                }
                if (status == 1) {
                    this.onUpdate(DEPARTMENT, departValues, null, null);
                    this.subDepart(company, depart);
                    continue;
                }
                if (status != 2) continue;
                this.onUpdate(DEPARTMENT, departValues, "departId =? ", new String[]{depart.getDepartsId()});
            }
        }
        if (employeeList != null && employeeList.size() > 0) {
            for (int j = 0; j < employeeList.size(); ++j) {
                Employee employee = employeeList.get(j);
                if (employee == null) continue;
                ContentValues employeeValues = this.getEmployeeValues(employee);
                status = employee.getStatus();
                if (status == 0) {
                    this.onDelete(EMPLOYEE, "employeeId =? ", new String[]{employee.getEmployeeId()});
                    continue;
                }
                if (status == 1) {
                    this.onUpdate(EMPLOYEE, employeeValues, null, null);
                    continue;
                }
                if (status != 2) continue;
                this.onUpdate(EMPLOYEE, employeeValues, "employeeId =? ", new String[]{employee.getEmployeeId()});
            }
        }
    }

    private ContentValues getCompanyValues(Company company) {
        if (company == null) {
            return null;
        }
        ContentValues values = new ContentValues();
        values.put(companyId, company.getCompanyId());
        values.put(companyName, company.getCompanyName());
        values.put(companyDepartmentNum, Integer.valueOf(company.getDepartmentNum()));
        values.put(companyUserNum, Integer.valueOf(company.getUserNum()));
        return values;
    }

    private ContentValues getDepartValues(Company company, Department department) {
        if (department == null) {
            return null;
        }
        ContentValues values = new ContentValues();
        values.put(departsId, department.getDepartsId());
        values.put(companyId, company.getCompanyId());
        values.put(companyName, company.getCompanyName());
        values.put(departsName, department.getDepartsName());
        values.put(departsSuperiorDepartmentId, department.getSuperiorDepartmentId());
        values.put(departsStatus, Integer.valueOf(department.getStatus()));
        values.put(departsUserNum, Integer.valueOf(department.getUserNum()));
        return values;
    }

    private void subDepart(Company company, Department department) {
        List<Department> subDepartsList = department.getSubDepartsList();
        if (subDepartsList != null && subDepartsList.size() > 0) {
            for (int i = 0; i < subDepartsList.size(); ++i) {
                Department depart = subDepartsList.get(i);
                if (depart == null) continue;
                ContentValues departValues = this.getDepartValues(company, depart);
                int status = depart.getStatus();
                if (status == 0) {
                    this.onDelete(DEPARTMENT, "departId =? ", new String[]{depart.getDepartsId()});
                } else if (status == 1) {
                    this.onUpdate(DEPARTMENT, departValues, null, null);
                } else if (status == 2) {
                    this.onUpdate(DEPARTMENT, departValues, "departId =? ", new String[]{depart.getDepartsId()});
                }
                this.subDepart(company, depart);
            }
        }
    }

    private ContentValues getEmployeeValues(Employee employee) {
        if (employee == null) {
            return null;
        }
        ContentValues values = new ContentValues();
        values.put(employeeId, employee.getEmployeeId());
        values.put(companyId, employee.getCompanyId());
        values.put(companyName, employee.getCompanyName());
        values.put(departsId, employee.getDepartsId());
        values.put(departsName, employee.getDepartsName());
        values.put(employeeName, employee.getEmployeeName());
        values.put(employeeMobile, employee.getEmployeeMobile());
        values.put(employeeBelongCompanyId, employee.getBelongCompanyId());
        values.put(employeeBelongDepartmentId, employee.getBelongDepartmentId());
        values.put(employeeHeadPath, employee.getHeadPath());
        values.put(employeeStatus, Integer.valueOf(employee.getStatus()));
        values.put(employeeAuthority, employee.getAuthority());
        String employeeName = employee.getEmployeeName();
        values.put(pinyin, PinYin.getPinYin(employeeName) + employeeName);
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onUpdate(String table, ContentValues values, String whereClause, String[] whereArgs) {
        if (values == null) {
            return;
        }
        SQLiteDatabase sqlite = databaseHelper.getWritableDatabase();
        if (sqlite == null) {
            return;
        }
        try {
            long ret = sqlite.replace(table, null, values);
            Log.e((String)"onUpdate():ret:", (String)("" + ret));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sqlite.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpdate(String sql, Object[] bindArgs) {
        if (sql == null || sql.equals("") || bindArgs == null || bindArgs.length <= 0) {
            return;
        }
        for (int i = 0; i < bindArgs.length; ++i) {
            Log.e((String)"onUpdate():--sql=", (String)(sql + "  " + bindArgs[i]));
        }
        SQLiteDatabase sqlite = databaseHelper.getWritableDatabase();
        if (sqlite == null) {
            return;
        }
        try {
            sqlite.execSQL(sql, bindArgs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sqlite.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onInsert(String table, ContentValues values) {
        if (values == null) {
            Log.e((String)"onInsert(table values)", (String)"--:values is null");
            return;
        }
        SQLiteDatabase sqlite = databaseHelper.getWritableDatabase();
        if (sqlite == null) {
            return;
        }
        try {
            sqlite.insert(table, null, values);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sqlite.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onDelete(String table, String whereClause, String[] whereArgs) {
        SQLiteDatabase sqlite = databaseHelper.getWritableDatabase();
        if (sqlite == null) {
            Log.e((String)"DBOpenHelper..", (String)":--sqlite is null !");
            return;
        }
        Log.e((String)"DBOpenHelper..", (String)("onDelete():--whereClause=" + table + "  : " + whereClause));
        try {
            sqlite.delete(table, whereClause, whereArgs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sqlite.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Cursor onQueryDepartsById(String id) {
        SQLiteDatabase sqlite = databaseHelper.getWritableDatabase();
        if (sqlite == null) {
            return null;
        }
        MatrixCursor c = new MatrixCursor(departmentColumArray);
        Cursor cursor = null;
        try {
            String selection = "departId=" + id;
            cursor = sqlite.query(DEPARTMENT, null, selection, null, null, null, null);
            if (cursor == null || cursor.getCount() <= 0) {
                Cursor cursor2 = null;
                return cursor2;
            }
            while (cursor.moveToNext()) {
                Object[] columnValues = new String[departmentColumArray.length];
                for (int i = 0; i < departmentColumArray.length; ++i) {
                    if (i < 1) continue;
                    columnValues[i] = cursor.getString(cursor.getColumnIndex(departmentColumArray[i]));
                }
                c.addRow(columnValues);
            }
            if (cursor != null) {
                cursor.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            sqlite.close();
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized JSONObject onQueryDeparts(boolean needUser, String[] columns, String selection, String[] selectionArgs) {
        SQLiteDatabase sqlite = databaseHelper.getWritableDatabase();
        if (sqlite == null) {
            return null;
        }
        MatrixCursor c = new MatrixCursor(departmentColumArray);
        Cursor cursor = null;
        JSONObject obj = new JSONObject();
        if (needUser) {
            JSONObject jsonObject = this.onQueryAllData();
            return jsonObject;
        }
        try {
            selection = "departsSuperiorDepartmentId is null  OR departsSuperiorDepartmentId='' OR departsSuperiorDepartmentId='0'";
            cursor = sqlite.query(DEPARTMENT, columns, selection, selectionArgs, null, null, null);
            if (cursor == null || cursor.getCount() <= 0) {
                JSONObject jsonObject = obj;
                return jsonObject;
            }
            JSONArray jsonArray = new JSONArray();
            String companyId = "";
            String companyName = "";
            while (cursor.moveToNext()) {
                String[] columnValues = new String[departmentColumArray.length];
                for (int i = 0; i < departmentColumArray.length; ++i) {
                    if (i < 1) continue;
                    columnValues[i] = cursor.getString(cursor.getColumnIndex(departmentColumArray[i]));
                }
                companyId = columnValues[2];
                companyName = columnValues[3];
                JSONObject jsonObject = new JSONObject();
                String departId = columnValues[1];
                jsonObject.put("Id", (Object)departId);
                jsonObject.put("Name", (Object)columnValues[4]);
                JSONArray subDepart = this.onQuerySubDeparts(needUser, departId);
                if (subDepart == null) {
                    subDepart = new JSONArray();
                }
                jsonObject.put("SubDeparts", (Object)subDepart);
                jsonArray.put((Object)jsonObject);
            }
            obj.put("Id", (Object)companyId);
            obj.put("Name", (Object)companyName);
            obj.put("Departs", (Object)jsonArray);
            if (cursor != null) {
                cursor.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            sqlite.close();
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized JSONArray onQuerySubDeparts(boolean needUser, String superiorDepartmentId) {
        SQLiteDatabase sqlite = databaseHelper.getWritableDatabase();
        if (sqlite == null) {
            return null;
        }
        MatrixCursor c = new MatrixCursor(departmentColumArray);
        Cursor cursor = null;
        JSONObject obj = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        if (needUser) {
            // empty if block
        }
        try {
            String selection = "departsSuperiorDepartmentId=" + superiorDepartmentId;
            cursor = sqlite.query(DEPARTMENT, null, selection, null, null, null, null);
            if (cursor == null || cursor.getCount() <= 0) {
                JSONArray jSONArray = null;
                return jSONArray;
            }
            while (cursor.moveToNext()) {
                String[] columnValues = new String[departmentColumArray.length];
                for (int i = 0; i < departmentColumArray.length; ++i) {
                    if (i < 1) continue;
                    columnValues[i] = cursor.getString(cursor.getColumnIndex(departmentColumArray[i]));
                }
                JSONObject jsonObject = new JSONObject();
                String departId = columnValues[1];
                jsonObject.put("Id", (Object)departId);
                jsonObject.put("Name", (Object)columnValues[4]);
                JSONArray sub = this.onQuerySubDeparts(needUser, departId);
                if (sub == null) {
                    sub = new JSONArray();
                }
                jsonObject.put("SubDeparts", (Object)sub);
                jsonArray.put((Object)jsonObject);
            }
            obj.put("SubDeparts", (Object)jsonArray);
            if (cursor != null) {
                cursor.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            sqlite.close();
        }
        return jsonArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized JSONObject onQueryEmployeeByDepartId(String departId) {
        SQLiteDatabase sqlite = databaseHelper.getWritableDatabase();
        if (sqlite == null) {
            return null;
        }
        MatrixCursor c = new MatrixCursor(employeeColumArray);
        Cursor cursor = null;
        JSONObject obj = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        String depart_Id = "";
        String depart_Name = "";
        try {
            Cursor departCur;
            String selection = "belongDepartmentId='" + departId + "'";
            cursor = sqlite.query(EMPLOYEE, null, selection, null, null, null, null);
            if (cursor != null && cursor.getCount() > 0) {
                while (cursor.moveToNext()) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("Id", (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[1])));
                    jsonObject.put("Name", (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[6])));
                    jsonObject.put("Mobile", (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[7])));
                    jsonObject.put("BelongCompanyId", (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[8])));
                    jsonObject.put("BelongDepartmentId", (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[9])));
                    jsonObject.put("HeadPath", (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[10])));
                    jsonObject.put("Status", (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[11])));
                    jsonObject.put(employeeAuthority, (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[12])));
                    jsonArray.put((Object)jsonObject);
                }
            }
            if ((departCur = this.onQueryDepartsById(departId)) != null && departCur.moveToNext()) {
                depart_Id = departCur.getString(cursor.getColumnIndex(employeeColumArray[4]));
                depart_Name = departCur.getString(cursor.getColumnIndex(employeeColumArray[5]));
            }
            obj.put("Id", (Object)depart_Id);
            obj.put("Name", (Object)depart_Name);
            obj.put("Users", (Object)jsonArray);
            JSONArray subDepartArray = this.onQuerySubDeparts(false, departId);
            if (subDepartArray == null) {
                subDepartArray = new JSONArray();
            }
            obj.put("SubDeparts", (Object)subDepartArray);
            if (cursor != null) {
                cursor.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            sqlite.close();
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized JSONArray onQueryEmployeeArrayByDepartId(String departId) {
        SQLiteDatabase sqlite = databaseHelper.getWritableDatabase();
        if (sqlite == null) {
            return null;
        }
        MatrixCursor c = new MatrixCursor(employeeColumArray);
        Cursor cursor = null;
        JSONObject obj = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        try {
            String selection = "belongDepartmentId='" + departId + "'";
            cursor = sqlite.query(EMPLOYEE, null, selection, null, null, null, null);
            if (cursor == null || cursor.getCount() <= 0) {
                JSONArray jSONArray = null;
                return jSONArray;
            }
            while (cursor.moveToNext()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("Id", (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[1])));
                jsonObject.put("Name", (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[6])));
                jsonObject.put("Mobile", (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[7])));
                jsonObject.put("BelongCompanyId", (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[8])));
                jsonObject.put("BelongDepartmentId", (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[9])));
                jsonObject.put("HeadPath", (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[10])));
                jsonObject.put("Status", (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[11])));
                jsonObject.put(employeeAuthority, (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[12])));
                jsonArray.put((Object)jsonObject);
            }
            if (cursor != null) {
                cursor.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            sqlite.close();
        }
        return jsonArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized JSONObject onQueryEmployeeByEmployeeId(String id) {
        SQLiteDatabase sqlite = databaseHelper.getWritableDatabase();
        if (sqlite == null) {
            return null;
        }
        MatrixCursor c = new MatrixCursor(employeeColumArray);
        Cursor cursor = null;
        JSONObject jsonObject = new JSONObject();
        try {
            String selection = "employeeId='" + id + "'";
            cursor = sqlite.query(EMPLOYEE, null, selection, null, null, null, null);
            if (cursor == null || cursor.getCount() <= 0) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONArray jsonArray = new JSONArray();
            while (cursor.moveToNext()) {
                jsonObject.put("Id", (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[1])));
                jsonObject.put("Name", (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[6])));
                jsonObject.put("Mobile", (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[7])));
                jsonObject.put("BelongCompanyId", (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[8])));
                jsonObject.put("BelongDepartmentId", (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[9])));
                jsonObject.put("HeadPath", (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[10])));
                jsonObject.put("Status", (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[11])));
                jsonObject.put(employeeAuthority, (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[12])));
            }
            if (cursor != null) {
                cursor.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            sqlite.close();
        }
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized JSONObject onQueryEmployeeByFuzzySearch(String searchStr) {
        SQLiteDatabase sqlite = databaseHelper.getWritableDatabase();
        if (sqlite == null) {
            return null;
        }
        MatrixCursor c = new MatrixCursor(employeeColumArray);
        Cursor cursor = null;
        JSONObject obj = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        try {
            String selection = "pinyin like '%" + searchStr + "%' OR " + employeeMobile + " like '%" + searchStr + "%'";
            cursor = sqlite.query(EMPLOYEE, null, selection, null, null, null, null);
            if (cursor == null || cursor.getCount() <= 0) {
                obj.put("Users", (Object)jsonArray);
                JSONObject jSONObject = obj;
                return jSONObject;
            }
            while (cursor.moveToNext()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("Id", (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[1])));
                jsonObject.put("Name", (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[6])));
                jsonObject.put("Mobile", (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[7])));
                jsonObject.put("BelongCompanyId", (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[8])));
                jsonObject.put("BelongDepartmentId", (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[9])));
                jsonObject.put("HeadPath", (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[10])));
                jsonObject.put("Status", (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[11])));
                jsonObject.put(employeeAuthority, (Object)cursor.getString(cursor.getColumnIndex(employeeColumArray[12])));
                jsonArray.put((Object)jsonObject);
            }
            obj.put("Users", (Object)jsonArray);
            if (cursor != null) {
                cursor.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            sqlite.close();
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized JSONObject onQueryAllData() {
        SQLiteDatabase sqlite = databaseHelper.getWritableDatabase();
        if (sqlite == null) {
            return null;
        }
        MatrixCursor c = new MatrixCursor(departmentColumArray);
        Cursor cursor = null;
        JSONObject obj = new JSONObject();
        try {
            cursor = sqlite.query(DEPARTMENT, null, null, null, null, null, null);
            if (cursor == null || cursor.getCount() <= 0) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONArray jsonArray = new JSONArray();
            String companyId = "";
            String companyName = "";
            while (cursor.moveToNext()) {
                String[] columnValues = new String[departmentColumArray.length];
                for (int i = 0; i < departmentColumArray.length; ++i) {
                    if (i < 1) continue;
                    columnValues[i] = cursor.getString(cursor.getColumnIndex(departmentColumArray[i]));
                }
                companyId = columnValues[2];
                companyName = columnValues[3];
                Log.e((String)"onQueryAllData()\uff1a", (String)("companyId:" + companyId + " companyName:" + companyName + " columnValues[0]:" + columnValues[0] + " columnValues[3]:" + columnValues[4]));
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("Id", (Object)columnValues[1]);
                jsonObject.put("Name", (Object)columnValues[4]);
                JSONArray employeeObj = this.onQueryEmployeeArrayByDepartId(columnValues[1]);
                jsonObject.put("Users", (Object)employeeObj);
                jsonArray.put((Object)jsonObject);
            }
            obj.put("Id", (Object)companyId);
            obj.put("Name", (Object)companyName);
            obj.put("Departs", (Object)jsonArray);
            if (cursor != null) {
                cursor.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            sqlite.close();
        }
        return obj;
    }
}

