/*
 * Decompiled with CFR 0.152.
 */
package com.chinamobile.ysx.db;

import android.util.Log;
import com.chinamobile.ysx.db.IDBListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DbUpdateCallback {
    private static DbUpdateCallback mDbUpdateCallback;
    private List<IDBListener> mDbUpdateListeners = new ArrayList<IDBListener>();

    public static synchronized DbUpdateCallback getInstance() {
        if (mDbUpdateCallback == null) {
            mDbUpdateCallback = new DbUpdateCallback();
        }
        return mDbUpdateCallback;
    }

    public void addDbUpdateListener(IDBListener listener) {
        Log.d((String)"", (String)"addDbUpdateListener :addDbUpdateListener()");
        this.mDbUpdateListeners.add(listener);
    }

    public void reDbUpdateListener(IDBListener listener) {
        IDBListener iListener;
        Iterator<IDBListener> iterator = this.mDbUpdateListeners.iterator();
        do {
            if (iterator.hasNext()) continue;
            return;
        } while ((iListener = iterator.next()) != listener);
        iterator.remove();
    }

    public void onDBUpdate(int oldVersion, int newVersion) {
        for (IDBListener listener : this.mDbUpdateListeners) {
            listener.onDBUpdate(oldVersion, newVersion);
        }
    }
}

