/*
 * Decompiled with CFR 0.152.
 */
package com.chinamobile.ysx.utils;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.Base64;
import com.chinamobile.ysx.auther.bean.User;
import com.chinamobile.ysx.auther.bean.YSXUser;
import com.chinamobile.ysx.utils.PreferenceUtil;
import com.chinamobile.ysx.utils.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;

public class AppUtil {
    private static AppUtil instance = null;

    private AppUtil() {
    }

    public static synchronized AppUtil getInstance() {
        if (instance == null) {
            instance = new AppUtil();
        }
        return instance;
    }

    public String getToken() {
        User user = this.getUser();
        return user == null ? null : user.getApiTicket();
    }

    public String getCompanyId() {
        return PreferenceUtil.readStringValue("company_id", "");
    }

    public void saveYSXUser(YSXUser user) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(user);
            String user_Base64 = new String(Base64.encode((byte[])baos.toByteArray(), (int)0));
            PreferenceUtil.saveStringValue("user_info", user_Base64);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public YSXUser getYSXUser() {
        YSXUser user = null;
        String userStr = PreferenceUtil.readStringValue("user_info", "");
        if (StringUtil.isEmptyOrNull(userStr)) {
            return null;
        }
        byte[] base64 = Base64.decode((byte[])userStr.getBytes(), (int)0);
        ByteArrayInputStream bais = new ByteArrayInputStream(base64);
        try {
            ObjectInputStream bis = new ObjectInputStream(bais);
            try {
                user = (YSXUser)bis.readObject();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        catch (StreamCorruptedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return user;
    }

    public User getUser() {
        User user = null;
        String userStr = PreferenceUtil.readStringValue("user_info", "");
        if (StringUtil.isEmptyOrNull(userStr)) {
            return null;
        }
        byte[] base64 = Base64.decode((byte[])userStr.getBytes(), (int)0);
        ByteArrayInputStream bais = new ByteArrayInputStream(base64);
        try {
            ObjectInputStream bis = new ObjectInputStream(bais);
            try {
                user = (User)bis.readObject();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        catch (StreamCorruptedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return user;
    }

    public void sendMsg(Context context, String phoneNum, String message) {
        if (phoneNum == null || phoneNum.equals("")) {
            // empty if block
        }
        Intent intent = new Intent();
        intent.setAction("android.intent.action.SENDTO");
        intent.setData(Uri.parse((String)("smsto:" + phoneNum)));
        intent.putExtra("sms_body", message);
        context.startActivity(intent);
    }
}

