/*
 * Decompiled with CFR 0.152.
 */
package com.chinamobile.ysx.utils;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.widget.Toast;
import com.chinamobile.ysx.utils.StringUtil;
import com.zipow.cmmlib.AppUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.MessageDigest;
import java.text.NumberFormat;

public class FileUtil {
    private static final int KELO_BYTE = 1024;
    private static final int MEGA_BYTE = 0x100000;
    private static final int GIGA_BYTE = 0x40000000;

    public static boolean checkSDCard() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    @TargetApi(value=18)
    public static long getAvailableInternalMemorySize() {
        File path = Environment.getDataDirectory();
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSizeLong();
        long availableBlocks = stat.getAvailableBlocksLong();
        return availableBlocks * blockSize;
    }

    @TargetApi(value=18)
    public static long getAvailableExternalMemorySize() {
        File path = Environment.getExternalStorageDirectory();
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSizeLong();
        long availableBlocks = stat.getAvailableBlocksLong();
        return availableBlocks * blockSize;
    }

    public static String saveFile(Context context, String dirName, Bitmap bmp, String mFileName, boolean isToSdcard) {
        try {
            if (isToSdcard) {
                if (FileUtil.checkSDCard()) {
                    long sdFreeSpace = FileUtil.getAvailableExternalMemorySize();
                    if (sdFreeSpace < 0x100000L) {
                        Toast.makeText((Context)context, (CharSequence)"sd\u5361\u7a7a\u95f4\u4e0d\u8db3", (int)0).show();
                        return null;
                    }
                    String dirPath = Environment.getExternalStorageDirectory().getPath() + dirName;
                    if (dirPath == null) {
                        return null;
                    }
                    File file = new File(dirPath);
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    if (mFileName == null || mFileName.equals("")) {
                        return null;
                    }
                    String filePath = file.getAbsolutePath() + "/" + mFileName;
                    if (bmp != null) {
                        File fileName = new File(filePath);
                        try {
                            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(fileName));
                            bmp.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)bos);
                            bos.flush();
                            bos.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return filePath;
                }
                Toast.makeText((Context)context, (CharSequence)"sd\u4e0d\u5b58\u5728", (int)0).show();
                return null;
            }
            long freeSpace = FileUtil.getAvailableInternalMemorySize();
            if (freeSpace < 0x100000L) {
                Toast.makeText((Context)context, (CharSequence)"\u7a7a\u95f4\u4e0d\u8db3", (int)0).show();
                return null;
            }
            String dirPath = context.getFilesDir() + dirName;
            if (dirPath == null) {
                return null;
            }
            File file = new File(dirPath);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (mFileName == null || mFileName.equals("")) {
                return null;
            }
            String filePath = file.getAbsolutePath() + "/" + mFileName;
            if (bmp != null) {
                File fileName = new File(filePath);
                try {
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(fileName));
                    bmp.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)bos);
                    bos.flush();
                    bos.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return filePath;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFileContent(String filePath, String content) {
        FileOutputStream fop = null;
        try {
            fop = new FileOutputStream(filePath);
            byte[] contentInBytes = content.getBytes();
            fop.write(contentInBytes);
            fop.flush();
            fop.close();
            System.out.println("Done");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fop != null) {
                    fop.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    public static String getPathFromUri(Context context, Uri uri) {
        if (context != null && uri != null) {
            boolean isKitKat;
            String path = null;
            boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
            path = isKitKat ? (DocumentsContract.isDocumentUri((Context)context, (Uri)uri) ? FileUtil.getPathFromUri_KitKat(context, uri) : FileUtil.getPathFromUri_Normal(context, uri)) : FileUtil.getPathFromUri_Normal(context, uri);
            return path;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(String srcFile, String destFile) {
        if (srcFile != null && destFile != null) {
            FileChannel inputChannel = null;
            AbstractInterruptibleChannel outputChannel = null;
            try {
                inputChannel = new FileInputStream(srcFile).getChannel();
                outputChannel = new FileOutputStream(destFile).getChannel();
                long e = inputChannel.size();
                long size = ((FileChannel)outputChannel).transferFrom(inputChannel, 0L, e);
                if (size != e) {
                    boolean bl = false;
                    return bl;
                }
            }
            catch (Exception var22) {
                var22.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (inputChannel != null) {
                        inputChannel.close();
                    }
                }
                catch (IOException var21) {
                    var21.printStackTrace();
                }
                try {
                    if (outputChannel != null) {
                        outputChannel.close();
                    }
                }
                catch (IOException var20) {
                    var20.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                String var9;
                int e = cursor.getColumnIndexOrThrow("_data");
                String string2 = var9 = cursor.getString(e);
                return string2;
            }
        }
        catch (Exception var12) {
            var12.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    @TargetApi(value=19)
    private static String getPathFromUri_KitKat(Context context, Uri uri) {
        if (FileUtil.isExternalStorageDocument(uri)) {
            String docId = DocumentsContract.getDocumentId((Uri)uri);
            String[] split = docId.split(":");
            String type = split[0];
            return "primary".equalsIgnoreCase(type) ? Environment.getExternalStorageDirectory() + "/" + split[1] : null;
        }
        if (FileUtil.isDownloadsDocument(uri)) {
            String docId = DocumentsContract.getDocumentId((Uri)uri);
            Uri split1 = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(docId));
            return FileUtil.getDataColumn(context, split1, null, null);
        }
        if (FileUtil.isMediaDocument(uri)) {
            String docId = DocumentsContract.getDocumentId((Uri)uri);
            String[] split = docId.split(":");
            String type = split[0];
            Uri contentUri = null;
            if ("image".equals(type)) {
                contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            } else if ("video".equals(type)) {
                contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
            } else if ("audio".equals(type)) {
                contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
            }
            String selection = "_id=?";
            String[] selectionArgs = new String[]{split[1]};
            return FileUtil.getDataColumn(context, contentUri, "_id=?", selectionArgs);
        }
        return null;
    }

    private static String getPathFromUri_Normal(Context context, Uri uri) {
        String path = null;
        path = "content".equalsIgnoreCase(uri.getScheme()) ? (FileUtil.isGooglePhotosUri(uri) ? uri.getLastPathSegment() : FileUtil.getDataColumn(context, uri, null, null)) : ("file".equalsIgnoreCase(uri.getScheme()) ? uri.getPath() : uri.toString());
        return path;
    }

    private static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    private static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    private static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    private static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMD5(File file) {
        if (!file.exists()) {
            return null;
        }
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        FileInputStream is = null;
        try {
            String var13;
            int var23;
            MessageDigest e = MessageDigest.getInstance("MD5");
            boolean readLen = false;
            byte[] buff = new byte[10240];
            is = new FileInputStream(file);
            do {
                if ((var23 = is.read(buff)) <= 0) continue;
                e.update(buff, 0, var23);
            } while (var23 > 0);
            byte[] md = e.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            String string2 = var13 = new String(str);
            return string2;
        }
        catch (Exception var21) {
            var21.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException var20) {
                var20.printStackTrace();
            }
        }
        return null;
    }

    public static boolean isSameFile(File file1, File file2) {
        String md51 = FileUtil.getMD5(file1);
        String md52 = FileUtil.getMD5(file2);
        return StringUtil.isSameString(md51, md52);
    }

    private static String getFileSizeString(double totalSize) {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(2);
        return format.format(totalSize);
    }

    public static String getTempPath(Context context) {
        return FileUtil.getDataPath(context, true, false);
    }

    public static String getDataPath(Context context, boolean createIfNotExist, boolean isPrivate) {
        File dir;
        File path;
        StringBuffer fn = new StringBuffer();
        String state = Environment.getExternalStorageState();
        boolean success = false;
        if (!isPrivate && state != null && state.equals("mounted")) {
            path = context.getExternalFilesDir(null);
            if (path != null) {
                fn.append(path.getParent());
                fn.append("/data");
                success = true;
            } else {
                dir = new File((fn = fn.append("/sdcard/Android/data/").append(AppUtil.getAppPackageName()).append("/data")).toString());
                if (!(dir.exists() && dir.isDirectory() || dir.mkdirs())) {
                    fn.delete(0, fn.length());
                } else {
                    success = true;
                }
            }
        }
        if (!success) {
            path = context.getFilesDir();
            if (path != null) {
                fn.append(path.getParent());
            } else {
                fn.append("/data/data/" + context.getPackageName());
            }
            fn.append("/data");
        }
        String path1 = fn.toString();
        dir = new File(path1);
        if (createIfNotExist && !dir.exists()) {
            dir.mkdirs();
        }
        return path1;
    }
}

