/*
 * Decompiled with CFR 0.152.
 */
package com.chinamobile.ysx.utils;

import com.chinamobile.ysx.YSXMeetingCountCallBackListener;
import com.chinamobile.ysx.okhttp.Call;
import com.chinamobile.ysx.okhttp.Callback;
import com.chinamobile.ysx.okhttp.FormBody;
import com.chinamobile.ysx.okhttp.MediaType;
import com.chinamobile.ysx.okhttp.OkHttpClient;
import com.chinamobile.ysx.okhttp.Request;
import com.chinamobile.ysx.okhttp.RequestBody;
import com.chinamobile.ysx.okhttp.Response;
import com.chinamobile.ysx.utils.AppUtil;
import java.io.IOException;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class OkHttpManage {
    private OkHttpClient okHttpClient;
    private JSONObject jsonObject;

    public static OkHttpManage getInstance() {
        return OkhttpConstruct.okhttpManage;
    }

    public void queryNotVipCount(final YSXMeetingCountCallBackListener countCallBackListener) {
        if (this.okHttpClient == null) {
            this.okHttpClient = new OkHttpClient();
        }
        FormBody requestBody = new FormBody.Builder().add("Token", AppUtil.getInstance().getYSXUser().getToken()).build();
        Request request = new Request.Builder().url("https://api.125339.com.cn/meeting/getJoinMeetingCount").post(requestBody).build();
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                countCallBackListener.countCallBackFail(-1, e.toString());
            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                block5: {
                    if (response.code() == 200) {
                        String json = response.body().string();
                        try {
                            JSONObject jsonObject = new JSONObject(json);
                            if (jsonObject.optInt("Code") == 0) {
                                int num = jsonObject.optInt("Data");
                                countCallBackListener.countCallBackSuccess(num);
                                break block5;
                            }
                            countCallBackListener.countCallBackFail(-1, jsonObject.optString("Message"));
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            countCallBackListener.countCallBackFail(-1, e.toString());
                        }
                    } else {
                        countCallBackListener.countCallBackFail(response.code(), response.message());
                    }
                }
            }
        });
    }

    private void baseHttpRequest(String url, Map<String, Object> map, Callback callback) {
        if (this.okHttpClient == null) {
            this.okHttpClient = new OkHttpClient();
        }
        this.jsonObject = new JSONObject();
        for (Map.Entry<String, Object> item : map.entrySet()) {
            try {
                this.jsonObject.put(item.getKey(), item.getValue());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        RequestBody requestBody = RequestBody.create(MediaType.parse("application/json; charset=utf-8"), this.jsonObject.toString());
        Request request = new Request.Builder().url(url).post(requestBody).build();
        this.okHttpClient.newCall(request).enqueue(callback);
    }

    public void createInstanceMeeting(String url, Map<String, Object> map, Callback callback) {
        this.baseHttpRequest(url, map, callback);
    }

    public void notifyMeetingStatusChange(String url, Map<String, Object> map, Callback callback) {
        this.baseHttpRequest(url, map, callback);
    }

    public void postInviteMeeting(String url, Map<String, Object> map, Callback callback) {
        this.baseHttpRequest(url, map, callback);
    }

    private static class OkhttpConstruct {
        private static OkHttpManage okhttpManage = new OkHttpManage();

        private OkhttpConstruct() {
        }
    }
}

