/*
 * Decompiled with CFR 0.152.
 */
package com.chinamobile.ysx.utils;

import android.text.TextPaint;
import android.util.Base64;
import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class StringUtil {
    private static final String TAG = StringUtil.class.getSimpleName();
    public static final int MID_FORMAT_TYPE_DEFAULT = 0;
    public static final int MID_FORMAT_TYPE_34X = 1;
    public static final int MID_FORMAT_TYPE_43X = 2;

    public static boolean isEmptyOrNull(String str) {
        return str == null || str.equals("null") || str.equals("NULL") || str.length() == 0;
    }

    public static boolean isSameString(String str1, String str2) {
        return str1 == null && str2 == null || (str1 == null || str2 != null) && (str1 != null || str2 == null) && str1 != null && str2 != null && str1.equals(str2);
    }

    public static String strTrim(String str) {
        String s1 = "";
        for (int i = 0; i < str.length(); ++i) {
            if (str.substring(i, i + 1).equals(" ")) continue;
            s1 = s1 + str.substring(i, i + 1);
        }
        return s1;
    }

    public static Map<String, String> parseNameValues(String str) {
        String[] pairs;
        if (str == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String[] var6 = pairs = str.split("\\s*;\\s*");
        int var5 = pairs.length;
        for (int var4 = 0; var4 < var5; ++var4) {
            String pair = var6[var4];
            String[] parts = pair.split("=");
            if (parts.length != 2) continue;
            map.put(parts[0], parts[1]);
        }
        return map;
    }

    public static Object bytes2String(byte[] data) {
        String str = null;
        try {
            str = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException var3) {
            Log.w((String)TAG, (String)"bytes2String failed!", (Throwable)var3);
        }
        return str;
    }

    public static String formatConfNumber(String confNumber) {
        return StringUtil.formatConfNumber(confNumber, 0);
    }

    public static String formatConfNumber(String confNumber, int formatType) {
        return StringUtil.formatConfNumber(confNumber, '-', formatType);
    }

    public static String formatConfNumber(String confNumber, char sectionChar) {
        return StringUtil.formatConfNumber(confNumber, sectionChar, 0);
    }

    public static String formatConfNumber(String confNumber, char sectionChar, int formatType) {
        StringBuilder str = new StringBuilder(confNumber);
        while (str.length() < 9) {
            str.insert(0, '0');
        }
        switch (formatType) {
            default: {
                if (str.length() <= 10) {
                    str.insert(6, sectionChar);
                    str.insert(3, sectionChar);
                    break;
                }
                str.insert(7, sectionChar);
                str.insert(3, sectionChar);
                break;
            }
            case 1: {
                str.insert(7, sectionChar);
                str.insert(3, sectionChar);
                break;
            }
            case 2: {
                str.insert(7, sectionChar);
                str.insert(4, sectionChar);
            }
        }
        return str.toString();
    }

    public static String formatConfNumber(long confNumber) {
        return StringUtil.formatConfNumber(confNumber, 0);
    }

    public static String formatConfNumber(long confNumber, int formatType) {
        return StringUtil.formatConfNumber(confNumber, '-', formatType);
    }

    public static String formatConfNumber(long confNumber, char sectionChar) {
        return StringUtil.formatConfNumber(confNumber, sectionChar, 0);
    }

    public static String formatConfNumber(long confNumber, char sectionChar, int formatType) {
        return StringUtil.formatConfNumber(String.valueOf(confNumber), sectionChar, formatType);
    }

    public static String ellipseString(String str, int maxWidth, TextPaint paint) {
        while (paint.measureText(str) > (float)maxWidth) {
            if (str.length() <= 3) {
                return str;
            }
            str = str.substring(0, str.length() - 4);
            str = str + "...";
        }
        return str;
    }

    public static boolean isValidEmailAddress(String email) {
        return email != null && email.matches("([a-zA-Z0-9_]|\\-|\\.|\\+)+@(([a-zA-Z0-9_]|\\-)+\\.)+[a-zA-Z]{2,}");
    }

    public static boolean containsAsianCharacter(String str) {
        if (str == null) {
            return false;
        }
        try {
            if (str.length() != str.getBytes("UTF-8").length) {
                return true;
            }
        }
        catch (UnsupportedEncodingException var2) {
            var2.printStackTrace();
        }
        return false;
    }

    public static boolean endsWithAsianCharacter(String str) {
        return StringUtil.containsAsianCharacter(str.substring(str.length() - 1));
    }

    public static boolean startsWithAsianCharacter(String str) {
        return StringUtil.containsAsianCharacter(str.substring(0, 1));
    }

    public static String formatPersonName(String firstName, String lastName) {
        return StringUtil.formatPersonName(firstName, lastName, null);
    }

    public static String formatPersonName(String firstName, String lastName, String regionCode) {
        String first = firstName == null ? "" : firstName;
        String last = lastName == null ? "" : lastName;
        first = first.trim();
        return (last = last.trim()).length() == 0 ? first : (first.length() == 0 ? last : (Locale.CHINA.getCountry().equalsIgnoreCase(regionCode) ? (!StringUtil.containsAsianCharacter(first) && !StringUtil.containsAsianCharacter(last) ? first + " " + last : (!StringUtil.endsWithAsianCharacter(lastName) && !StringUtil.startsWithAsianCharacter(firstName) ? last + " " + first : last + first)) : first + " " + last));
    }

    public static String safeString(String str) {
        return str == null ? "" : str;
    }

    public static boolean isAllAssii(String s) {
        char[] array;
        char[] var5 = array = s.toCharArray();
        int var4 = array.length;
        for (int var3 = 0; var3 < var4; ++var3) {
            char c = var5[var3];
            if (c >= '\u0000' && c <= '\u00ff') continue;
            return false;
        }
        return true;
    }

    public static byte[] getStringToByte(String value) {
        if (value != null && !value.equals("")) {
            byte[] responseBufferP = null;
            responseBufferP = value.trim().getBytes();
            return responseBufferP;
        }
        return null;
    }

    public static final String readUnsignedLong(String mcaddr) {
        if (mcaddr != null && !mcaddr.equals("")) {
            BigDecimal toValue;
            long value = Long.parseLong(mcaddr);
            if (value >= 0L) {
                toValue = new BigDecimal(value);
            } else {
                long lowValue = value & Long.MAX_VALUE;
                toValue = BigDecimal.valueOf(lowValue).add(BigDecimal.valueOf(Long.MAX_VALUE)).add(BigDecimal.valueOf(1L));
            }
            if (toValue == null) {
                return "";
            }
            return toValue.toString();
        }
        return "";
    }

    public static final long readLong(String value) {
        if (!StringUtil.isEmptyOrNull(value)) {
            long longValue = Long.parseLong(value);
            return longValue;
        }
        return 0L;
    }

    public static List StringToList(String SceneListString) {
        if (StringUtil.isEmptyOrNull(SceneListString)) {
            return null;
        }
        byte[] mobileBytes = Base64.decode((byte[])SceneListString.getBytes(), (int)0);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(mobileBytes);
        List SceneList = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            SceneList = (List)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (StreamCorruptedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return SceneList;
    }

    public static String ListToString(List SceneList) {
        if (SceneList == null || SceneList.size() <= 0) {
            return "";
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String SceneListString = "";
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(SceneList);
            SceneListString = new String(Base64.encode((byte[])byteArrayOutputStream.toByteArray(), (int)0));
            objectOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return SceneListString;
    }

    public static String ObjectToString(Object obj) {
        if (obj == null) {
            return "";
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String SceneListString = "";
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(obj);
            SceneListString = new String(Base64.encode((byte[])byteArrayOutputStream.toByteArray(), (int)0));
            objectOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return SceneListString;
    }

    public static boolean isPeculiar(String txt) {
        String regEx = "[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(txt);
        return m.find();
    }

    private static boolean isPhoneNumberValid(String phoneNumber) {
        Pattern p = Pattern.compile("^(13[0-9]|15[0-3]|15[5-9]|180|18[23]|18[5-9])\\d{8}$");
        Matcher m = p.matcher(phoneNumber);
        return m.matches();
    }

    private static boolean isNameVaslid(String name) {
        Pattern p = Pattern.compile("^[\u4e00-\u9fa5a-zA-Z0-9_-]{2,16}$");
        Matcher m = p.matcher(name);
        return m.matches();
    }

    public static boolean emailFilter(String str) throws PatternSyntaxException {
        Pattern p = Pattern.compile("[\\w\\.\\-]+@([\\w\\-]+\\.)+[\\w\\-]+", 2);
        Matcher m = p.matcher(str);
        return m.matches();
    }
}

