/*
 * Decompiled with CFR 0.152.
 */
package com.chinamobile.ysx.utils;

import android.content.Context;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import android.util.Log;
import com.chinamobile.ysx.utils.TimeFormatUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimeUtil {
    public static final long ONE_DAY_IN_MILLISECONDS = 86400000L;

    public static long getDuration(long endTime, long startTime) {
        try {
            long interval = Math.abs(endTime - startTime) / 1000L;
            long day = interval / 86400L;
            long hour = interval % 86400L / 3600L;
            long minute = interval % 3600L / 60L;
            long second = interval % 60L;
            String duration = "";
            if (day > 0L) {
                duration = day + "\u5929";
            }
            if (hour > 0L) {
                duration = duration + hour + "\u5c0f\u65f6";
            }
            if (minute > 0L) {
                duration = duration + minute + "\u5206\u949f";
            }
            Log.e((String)"", (String)("\u4e24\u4e2a\u65f6\u95f4\u76f8\u5dee\uff1a" + day + "\u5929" + hour + "\u5c0f\u65f6" + minute + "\u5206" + second + "\u79d2"));
            return interval / 60L;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static boolean isHuanxinImNotify(long startTime) {
        String curTime = TimeFormatUtil.formatDateTimes(new Date());
        long curTimeL = TimeUtil.formatTime(curTime);
        try {
            long interval = Math.abs(curTimeL - startTime) / 1000L;
            long minute = interval / 60L;
            long seconds = interval % 60L;
            Log.e((String)"", (String)("isHuanxinImNotify  minute:" + Math.abs(minute) + "\u79d2  seconds:" + seconds));
            if (Math.abs(minute) <= 5L) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static long formatTime(String time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return sdf.parse(time).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static String formatTime(Context context, long time) {
        return DateUtils.formatDateTime((Context)context, (long)time, (int)2561);
    }

    public static String formatTimeCap(Context context, long time) {
        return DateUtils.formatDateTime((Context)context, (long)time, (int)2817);
    }

    public static String formatDateTime(Context context, long time) {
        return DateUtils.formatDateTime((Context)context, (long)time, (int)2577);
    }

    public static String formatDateTimeCap(Context context, long time) {
        return DateUtils.formatDateTime((Context)context, (long)time, (int)2833);
    }

    public static String formatDate(Context context, long time) {
        return DateUtils.formatDateTime((Context)context, (long)time, (int)32794);
    }

    public static String formatDateWithYear(Context context, long time) {
        return DateUtils.formatDateTime((Context)context, (long)time, (int)32790);
    }

    public static boolean isSameDate(long time1, long time2) {
        Date date1 = new Date(time1);
        Date date2 = new Date(time2);
        return date1.getYear() == date2.getYear() && date1.getMonth() == date2.getMonth() && date1.getDate() == date2.getDate();
    }

    public static int dateDiff(long time1, long time2) {
        long zeroTime1 = TimeUtil.getDayZeroTime(time1);
        long zeroTime2 = TimeUtil.getDayZeroTime(time2);
        return (int)((zeroTime1 - zeroTime2) / 86400000L);
    }

    public static long getDayZeroTime(long time) {
        long offset = TimeZone.getDefault().getRawOffset();
        return (time + offset) / 86400000L * 86400000L - offset;
    }

    private static String format(java.text.DateFormat formatter, Calendar calendar) {
        if (formatter != null && calendar != null) {
            formatter.setCalendar(calendar);
            return formatter.format(calendar.getTime());
        }
        return null;
    }

    public static String formatDate(Context context, Calendar calendar) {
        java.text.DateFormat formatter = context == null ? java.text.DateFormat.getDateInstance() : DateFormat.getDateFormat((Context)context);
        return TimeUtil.format(formatter, calendar);
    }

    public static String formatDateTime(Context context, Calendar calendar) {
        return TimeUtil.format(java.text.DateFormat.getDateTimeInstance(), calendar);
    }

    public static String formatTime(Context context, Calendar calendar) {
        java.text.DateFormat formatter = context == null ? java.text.DateFormat.getTimeInstance() : DateFormat.getTimeFormat((Context)context);
        return TimeUtil.format(formatter, calendar);
    }

    private static String format(java.text.DateFormat formatter, Date date, TimeZone timeZone) {
        if (formatter != null && date != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            if (timeZone != null) {
                cal.setTimeZone(timeZone);
            }
            return TimeUtil.format(formatter, cal);
        }
        return null;
    }

    public static String formatDate(Context context, Date date, TimeZone timezone) {
        java.text.DateFormat formatter = context == null ? java.text.DateFormat.getDateInstance() : DateFormat.getDateFormat((Context)context);
        return TimeUtil.format(formatter, date, timezone);
    }

    public static String formatDateTime(Context context, Date date, TimeZone timezone) {
        return TimeUtil.format(java.text.DateFormat.getDateTimeInstance(), date, timezone);
    }

    public static String formatTime(Context context, Date date, TimeZone timezone) {
        java.text.DateFormat formatter = context == null ? java.text.DateFormat.getTimeInstance() : DateFormat.getTimeFormat((Context)context);
        return TimeUtil.format(formatter, date, timezone);
    }
}

