/*
 * Decompiled with CFR 0.152.
 */
package com.chinamobile.ysx.utils;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.res.Resources;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.chinamobile.ysx.R;

public class WarningDialog
extends Dialog {
    public static final int TYPE_SHOW_OK_BUTTON = 1;
    public static final int TYPE_SHOW_NO_BUTTON = 2;
    private TextView mMsgView;
    private ImageView mTitleDriver;
    private LinearLayout mBtnPanel;
    private Button btn1;
    private Button btn2;
    private Button btn3;
    private View.OnClickListener clickListener = new View.OnClickListener(){

        public void onClick(View v) {
            WarningDialog.this.dismiss();
        }
    };

    public WarningDialog(Context context, int theme) {
        super(context, theme);
    }

    public WarningDialog(Context context, int theme, int type) {
        super(context, theme);
        Window window = this.getWindow();
        WindowManager.LayoutParams params = window.getAttributes();
        int width = this.getDensity(context);
        params.height = -2;
        params.width = width * 1 / 2 + 100;
        window.setAttributes(params);
        this.setContentView(R.layout.m_warning_layout);
        this.btn1 = (Button)this.findViewById(R.id.button1);
        this.btn2 = (Button)this.findViewById(R.id.button2);
        this.btn3 = (Button)this.findViewById(R.id.button3);
        this.mTitleDriver = (ImageView)this.findViewById(R.id.titleDivider);
        this.mBtnPanel = (LinearLayout)this.findViewById(R.id.buttonPanel);
        this.mMsgView = (TextView)this.findViewById(R.id.alertTitle);
        if (type == 1) {
            this.btn1.setVisibility(4);
            this.btn2.setVisibility(4);
            this.btn3.setVisibility(0);
            this.btn3.setText((CharSequence)context.getString(R.string.ok));
            this.btn3.setOnClickListener(this.clickListener);
        } else if (type == 2) {
            this.mTitleDriver.setVisibility(8);
            this.mBtnPanel.setVisibility(8);
        }
    }

    public void setMsg(String msg) {
        this.mMsgView.setText((CharSequence)msg);
    }

    public void showDelayDismiss() {
        this.show();
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                WarningDialog.this.dismiss();
            }
        }, 2000L);
    }

    public void showDelayDismiss(final Activity activity, final boolean isfinish) {
        this.show();
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                WarningDialog.this.dismiss();
                if (isfinish) {
                    activity.finish();
                }
            }
        }, 2000L);
    }

    private int getDensity(Context context) {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        return metrics.widthPixels;
    }
}

