/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.authorization_server.intercepter;

import com.ebaiyihui.authorization_server.token.AccessTokenService;
import com.ebaiyihui.authorization_server.utils.CommonsUtils;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.ui.ModelMap;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.WebRequestInterceptor;

@Component
public class ApiAccessInterceptor
implements WebRequestInterceptor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private AccessTokenService tokenService;

    public void preHandle(WebRequest webRequest) throws Exception {
        String token = webRequest.getHeader("accessToken");
        if (StringUtils.isEmpty((CharSequence)token)) {
            HttpServletRequest request = CommonsUtils.currentRequest();
            this.log.info("\u8fdb\u5165\u6743\u9650\u6821\u9a8c,\u8bf7\u6c42\u5934\u4e2d\u672a\u83b7\u53d6\u5230token\u4fe1\u606f====>URL:{}", (Object)request.getRequestURL());
            throw new RuntimeException("request header 'accessToken' is  missing ");
        }
        if (!this.tokenService.validateAccessToken(token).booleanValue()) {
            HttpServletRequest request = CommonsUtils.currentRequest();
            this.log.info("\u8fdb\u5165\u6743\u9650\u6821\u9a8c,token\u6821\u9a8c\u4e0d\u901a\u8fc7====>URL:{}", (Object)request.getRequestURL());
            throw new RuntimeException("Token checked no pass");
        }
    }

    public void postHandle(WebRequest webRequest, ModelMap modelMap) throws Exception {
    }

    public void afterCompletion(WebRequest webRequest, Exception e) throws Exception {
    }
}

