/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.authorization_server.token;

import com.ebaiyihui.authorization_server.enums.LoginDeviceType;
import com.ebaiyihui.authorization_server.exception.TokenParseException;
import com.ebaiyihui.authorization_server.token.TokenBody;
import com.ebaiyihui.authorization_server.token.TokenJson;
import com.ebaiyihui.authorization_server.token.Tokenutil;
import com.ebaiyihui.authorization_server.utils.RedisUtil;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AccessTokenService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RedisUtil redisUtil;

    public Boolean validateAccessToken(String accessToken) {
        TokenBody tokenBody;
        if (StringUtils.isEmpty((CharSequence)accessToken)) {
            this.log.error("Token\u53c2\u6570\u89e3\u6790\u5931\u8d25\uff0caccessToken\u4e3a\u7a7a");
            return false;
        }
        try {
            tokenBody = Tokenutil.parseGetTokenBody(accessToken, "hxgy-ehospital");
        }
        catch (Exception e) {
            this.log.error("Token\u53c2\u6570\u89e3\u6790\u5931\u8d25\uff0cToken\u4fe1\u606f[{}]", (Object)accessToken, (Object)e);
            return false;
        }
        if (!tokenBody.expire()) {
            this.log.error("Token\u5df2\u8fc7\u671f\uff0cToken\u4fe1\u606f[{}]", (Object)tokenBody);
            return false;
        }
        TokenJson tokenJson = tokenBody.getTokenJson();
        String tokenKey = AccessTokenService.genTokenKey(tokenJson.getUserId(), tokenJson.getAppCode(), tokenJson.getDeviceType());
        String cacheToken = this.getCacheToken(tokenKey);
        if (StringUtils.isEmpty((CharSequence)cacheToken)) {
            this.log.error("Token\u767b\u5f55\u4fe1\u606f\u5df2\u5931\u6548\uff0cToken\u4fe1\u606f[{}]", (Object)tokenBody);
            return false;
        }
        if (!accessToken.equals(cacheToken)) {
            this.log.error("Token\u767b\u5f55\u4fe1\u606f\u5df2\u5931\u6548\uff0c\u7528\u6237\u5728\u5176\u4ed6\u8bbe\u5907\u5df2\u91cd\u65b0\u767b\u5f55,Token\u4fe1\u606f[{}]", (Object)accessToken);
            return false;
        }
        return true;
    }

    public String genLoginToken(TokenJson tokenJson) {
        String loginToken = Tokenutil.gen(tokenJson, "hxgy-ehospital");
        String tokenKey = AccessTokenService.genTokenKey(tokenJson.getUserId(), tokenJson.getAppCode(), tokenJson.getDeviceType());
        if (LoginDeviceType.WEB.toString().equalsIgnoreCase(tokenJson.getDeviceType())) {
            this.redisUtil.set(tokenKey, loginToken, 4L, TimeUnit.HOURS);
        } else {
            this.redisUtil.set(tokenKey, loginToken, 30L, TimeUnit.DAYS);
        }
        return loginToken;
    }

    public String getCacheToken(String tokenKey) {
        return tokenKey == null ? null : (String)this.redisUtil.get(tokenKey);
    }

    public TokenBody parseEffectiveToken(String accessToken) {
        try {
            TokenBody tokenBody = Tokenutil.parseGetTokenBody(accessToken, "hxgy-ehospital");
            if (tokenBody.getTtl().before(new Date())) {
                this.log.warn("token\u5df2\u8fc7\u671f \u8fd4\u56denull");
                return null;
            }
            return tokenBody;
        }
        catch (TokenParseException | ExpiredJwtException | MalformedJwtException | SignatureException e) {
            this.log.error("token\u89e3\u6790\u5f02\u5e38\uff0caccessToken{}", (Object)accessToken);
            return null;
        }
    }

    public void deleteAllToken(String userId, String appCode) {
        for (LoginDeviceType loginDeviceType : LoginDeviceType.values()) {
            String tokenKey = AccessTokenService.genTokenKey(userId, appCode, loginDeviceType.toString());
            this.redisUtil.del(tokenKey);
        }
    }

    public static String genTokenKey(String userId, String appCode, String deviceType) {
        return userId + "_" + appCode + "_" + deviceType;
    }
}

