/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.authorization_server.token;

import com.ebaiyihui.authorization_server.common.AuthContants;
import com.ebaiyihui.authorization_server.exception.TokenParseException;
import com.ebaiyihui.authorization_server.token.JwtUtil;
import com.ebaiyihui.authorization_server.token.TokenBody;
import com.ebaiyihui.authorization_server.token.TokenJson;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jsonwebtoken.Claims;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class Tokenutil {
    private static String SPACE_MARK = "***";
    private static final ObjectMapper om = new ObjectMapper();

    public static String gen(TokenJson tokenJson) {
        return Tokenutil.gen(tokenJson, AuthContants.DEFAULT_SECRYKEY);
    }

    public static String gen(TokenJson tokenJson, String secryKey) {
        Objects.requireNonNull(tokenJson, "\u751f\u6210token\u53c2\u6570tokenJson\u4e0d\u80fd\u4e3anull");
        String id = tokenJson.getUserId() + tokenJson.getDevicenumber();
        long timeTolive = 30L;
        String genJwt = JwtUtil.genJwt(id, tokenJson, timeTolive, TimeUnit.DAYS, secryKey);
        return genJwt + SPACE_MARK + tokenJson.getAppCode();
    }

    public static boolean validateToken(String accesstoken, String secryKey) {
        try {
            TokenBody tokenBody = Tokenutil.parseGetTokenBody(accesstoken, secryKey);
            return tokenBody.expire();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getTokenAppCode(String token) {
        return token.substring(token.indexOf(SPACE_MARK) + 3);
    }

    public static TokenBody parseGetTokenBody(String token, String secryKey) {
        TokenJson tokenJson;
        int i = token.indexOf(SPACE_MARK);
        if (i > 0) {
            token = token.substring(0, i);
        }
        Claims parseJWT = JwtUtil.parseJWT(token, secryKey);
        String subject = parseJWT.getSubject();
        try {
            tokenJson = (TokenJson)om.readValue(subject, TokenJson.class);
        }
        catch (Exception e) {
            throw new TokenParseException(e);
        }
        Date expiration = parseJWT.getExpiration();
        TokenBody tokenBody = new TokenBody();
        tokenBody.setTokenJson(tokenJson);
        tokenBody.setTtl(expiration);
        return tokenBody;
    }
}

