/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.pojo.dto.AssayReportDetailQueryResDTO;
import com.ebaiyihui.his.pojo.dto.AssayReportQueryItemResDTO;
import com.ebaiyihui.his.pojo.dto.AssayReportQueryResDTO;
import com.ebaiyihui.his.pojo.dto.CheckReportResDTO;
import com.ebaiyihui.his.pojo.dto.InspectionReportListDTO;
import com.ebaiyihui.his.pojo.dto.InspectionReportQueryResDTO;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.report.GetReportListsReq;
import com.ebaiyihui.his.pojo.vo.report.GetReportListsRes;
import com.ebaiyihui.his.pojo.vo.report.LisReportItemResData;
import com.ebaiyihui.his.pojo.vo.report.LisReportListReq;
import com.ebaiyihui.his.pojo.vo.report.LisReportListRes;
import com.ebaiyihui.his.pojo.vo.report.PacsReportItemRes;
import com.ebaiyihui.his.pojo.vo.report.PacsReportListReq;
import com.ebaiyihui.his.pojo.vo.report.PacsReportListRes;
import com.ebaiyihui.his.pojo.vo.report.datas.GetReportListsData;
import com.ebaiyihui.his.service.ElectronicReportService;
import com.ebaiyihui.his.service.HisRemoteService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ElectronicReportServiceImpl
implements ElectronicReportService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int MAP_SIZE = 1;
    public static final String CHECK_TYPE = "1";
    public static final String INSPECTION_TYPE = "2";
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<GetReportListsRes> getReportLists(FrontRequest<GetReportListsReq> param) {
        List<Object> getReportList = new ArrayList();
        GetReportListsRes getReportListsRes = new GetReportListsRes();
        if (CHECK_TYPE.equals(((GetReportListsReq)param.getBody()).getReportType())) {
            ((GetReportListsReq)param.getBody()).setReportType(INSPECTION_TYPE);
        } else {
            ((GetReportListsReq)param.getBody()).setReportType(CHECK_TYPE);
        }
        HashMap<String, Object> reportQueryReqMap = new HashMap<String, Object>(1);
        reportQueryReqMap.put(EntityKeyEnum.REPORT_LIST_QUERY.getValue(), param.getBody());
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.REPORT_LIST_QUERY.getValue(), reportQueryReqMap, AssayReportQueryResDTO.class);
        if (null == response) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        if (!"0".equals(((AssayReportQueryResDTO)response.getBody()).getResultCode())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        List reportQueryItemResDTOList = ((AssayReportQueryResDTO)response.getBody()).getItem();
        if (CollectionUtils.isEmpty((Collection)reportQueryItemResDTOList)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        for (AssayReportQueryItemResDTO assayReportQueryItemResDTO : reportQueryItemResDTOList) {
            GetReportListsData getReportListsData = new GetReportListsData();
            BeanUtils.copyProperties((Object)assayReportQueryItemResDTO, (Object)getReportListsData);
            getReportListsData.setReportType(((GetReportListsReq)param.getBody()).getReportType());
            getReportList.add(getReportListsData);
        }
        getReportList = getReportList.stream().sorted(Comparator.comparing(GetReportListsData::getReportDate).reversed()).collect(Collectors.toList());
        getReportListsRes.setDatas(getReportList);
        getReportListsRes.setPatientNo(((AssayReportQueryItemResDTO)reportQueryItemResDTOList.get(0)).getCardNo());
        getReportListsRes.setPatientName(((AssayReportQueryItemResDTO)reportQueryItemResDTOList.get(0)).getPatientName());
        getReportListsRes.setPatientID(((AssayReportQueryItemResDTO)reportQueryItemResDTOList.get(0)).getPatientId());
        return FrontResponse.success((String)response.getTransactionId(), (Object)getReportListsRes);
    }

    public FrontResponse<LisReportListRes> lisReportList(FrontRequest<LisReportListReq> param) {
        HashMap<String, Object> assayReportDetailQueryMap = new HashMap<String, Object>(1);
        assayReportDetailQueryMap.put(EntityKeyEnum.ASSAY_REPORT_DETAIL_QUERY.getValue(), param.getBody());
        FrontResponse assayReportDetailQueryRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.ASSAY_REPORT_DETAIL_QUERY.getValue(), assayReportDetailQueryMap, AssayReportDetailQueryResDTO.class);
        AssayReportDetailQueryResDTO assayReportDetailQueryResDTO = (AssayReportDetailQueryResDTO)assayReportDetailQueryRes.getBody();
        if (null == assayReportDetailQueryResDTO) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)assayReportDetailQueryRes.getMessage());
        }
        if (!"0".equals(assayReportDetailQueryResDTO.getResult())) {
            return FrontResponse.error((String)assayReportDetailQueryRes.getTransactionId(), (String)"0", (String)assayReportDetailQueryRes.getMessage());
        }
        if (CollectionUtils.isEmpty((Collection)assayReportDetailQueryResDTO.getInspectionReportListDTO())) {
            return FrontResponse.success((String)assayReportDetailQueryRes.getTransactionId(), null);
        }
        List item = assayReportDetailQueryResDTO.getInspectionReportListDTO();
        LisReportListRes lisReportListRes = new LisReportListRes();
        ArrayList<LisReportItemResData> list = new ArrayList<LisReportItemResData>();
        for (InspectionReportListDTO inspectionReportListDTO : item) {
            LisReportItemResData lisReportItemResData = new LisReportItemResData();
            BeanUtils.copyProperties((Object)inspectionReportListDTO, (Object)lisReportItemResData);
            list.add(lisReportItemResData);
        }
        lisReportListRes.setItem(list);
        return FrontResponse.success((String)assayReportDetailQueryRes.getTransactionId(), (Object)lisReportListRes);
    }

    public FrontResponse<PacsReportListRes> pacsReportList(FrontRequest<PacsReportListReq> param) {
        HashMap<String, Object> inspectionDetailReportQueryMap = new HashMap<String, Object>(1);
        inspectionDetailReportQueryMap.put(EntityKeyEnum.CHECK_REPORT_DETAIL.getValue(), param.getBody());
        FrontResponse inspectionReportQueryRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.CHECK_REPORT_DETAIL.getValue(), inspectionDetailReportQueryMap, InspectionReportQueryResDTO.class);
        if (Objects.isNull(inspectionReportQueryRes)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", null);
        }
        if (Objects.isNull(inspectionReportQueryRes.getBody())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)inspectionReportQueryRes.getMessage());
        }
        InspectionReportQueryResDTO inspectionReportQueryResDTO = (InspectionReportQueryResDTO)inspectionReportQueryRes.getBody();
        if (!"0".equals(inspectionReportQueryResDTO.getResultCode())) {
            return FrontResponse.error((String)inspectionReportQueryRes.getTransactionId(), (String)"0", (String)inspectionReportQueryRes.getMessage());
        }
        if (CollectionUtils.isEmpty((Collection)inspectionReportQueryResDTO.getCheckReportResDTO())) {
            return FrontResponse.success((String)inspectionReportQueryRes.getTransactionId(), null);
        }
        PacsReportListRes pacsReportListRes = new PacsReportListRes();
        List item = inspectionReportQueryResDTO.getCheckReportResDTO();
        ArrayList<PacsReportItemRes> list = new ArrayList<PacsReportItemRes>();
        for (CheckReportResDTO checkReportResDTO : item) {
            PacsReportItemRes pacsReportItemRes = new PacsReportItemRes();
            BeanUtils.copyProperties((Object)checkReportResDTO, (Object)pacsReportItemRes);
            list.add(pacsReportItemRes);
        }
        pacsReportListRes.setItemRes(list);
        return FrontResponse.success((String)inspectionReportQueryRes.getTransactionId(), (Object)pacsReportListRes);
    }
}

