/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.pojo.dto.RegisteredRecordResDTO;
import com.ebaiyihui.his.pojo.vo.ReferralRefoundReqVo;
import com.ebaiyihui.his.pojo.vo.ReferralRefoundResVo;
import com.ebaiyihui.his.pojo.vo.ReferralRegisterReqVo;
import com.ebaiyihui.his.pojo.vo.ReferralRegisterResVo;
import com.ebaiyihui.his.pojo.vo.RegisteredRecordReqVo;
import com.ebaiyihui.his.pojo.vo.RegisteredRecordResVo;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.ReferralService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ReferralServiceImpl
implements ReferralService {
    private static final Logger log = LoggerFactory.getLogger(ReferralServiceImpl.class);
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<List<RegisteredRecordResVo>> getRegisteredRecord(FrontRequest<RegisteredRecordReqVo> registeredRecordRequest) {
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put(EntityKeyEnum.GET_REGISTERED_RECORD.getValue(), registeredRecordRequest.getBody());
        FrontResponse registeredRecordResponse = this.hisRemoteService.requestHis(registeredRecordRequest.getTransactionId(), MethodCodeEnum.GET_REGISTERED_RECORD.getValue(), map, RegisteredRecordResDTO.class);
        RegisteredRecordResDTO registeredRecordResDTO = (RegisteredRecordResDTO)registeredRecordResponse.getBody();
        if (null == registeredRecordResDTO) {
            return FrontResponse.error((String)registeredRecordRequest.getTransactionId(), (String)"0", (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if (!"0".equals(registeredRecordResDTO.getResultCode())) {
            return FrontResponse.success((String)registeredRecordRequest.getTransactionId(), new ArrayList());
        }
        List resVoList = registeredRecordResDTO.getRegisteredRecordResVoList();
        if (CollectionUtils.isEmpty((Collection)resVoList)) {
            return FrontResponse.success((String)registeredRecordRequest.getTransactionId(), new ArrayList());
        }
        if (StringUtils.isNotBlank((CharSequence)((RegisteredRecordReqVo)registeredRecordRequest.getBody()).getDeptCode())) {
            resVoList = resVoList.stream().filter(registeredRecordResVo -> registeredRecordResVo.getDeptCode().equals(((RegisteredRecordReqVo)registeredRecordRequest.getBody()).getDeptCode())).collect(Collectors.toList());
        }
        return FrontResponse.success((String)registeredRecordRequest.getTransactionId(), (Object)resVoList);
    }

    public FrontResponse<ReferralRegisterResVo> referralRegister(FrontRequest<ReferralRegisterReqVo> param) {
        ReferralRegisterReqVo body = (ReferralRegisterReqVo)param.getBody();
        HashMap<String, ReferralRegisterReqVo> map = new HashMap<String, ReferralRegisterReqVo>(1);
        map.put(EntityKeyEnum.REFERRAL_REGISTER.getValue(), body);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.REFERRAL_REGISTER.getValue(), map, ReferralRegisterResVo.class);
        ReferralRegisterResVo referralRegisterResVo = (ReferralRegisterResVo)response.getBody();
        if (null == referralRegisterResVo) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        if (!"0".equals(referralRegisterResVo.getResultCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)referralRegisterResVo.getResultMsg());
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)referralRegisterResVo);
    }

    public FrontResponse<ReferralRefoundResVo> referralRefound(FrontRequest<ReferralRefoundReqVo> param) {
        ReferralRefoundReqVo body = (ReferralRefoundReqVo)param.getBody();
        HashMap<String, ReferralRefoundReqVo> map = new HashMap<String, ReferralRefoundReqVo>(1);
        map.put(EntityKeyEnum.REFERRAL_REFOUND.getValue(), body);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.REFERRAL_REFOUND.getValue(), map, ReferralRefoundResVo.class);
        ReferralRefoundResVo referralRefoundResVo = (ReferralRefoundResVo)response.getBody();
        if (null == referralRefoundResVo) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        if (!"0".equals(referralRefoundResVo.getResultCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)referralRefoundResVo.getResultMsg());
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)referralRefoundResVo);
    }
}

