/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.config;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class StatisticsInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(StatisticsInterceptor.class);
    private static final String START_TIME = "start_time";

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        request.setAttribute(START_TIME, (Object)System.currentTimeMillis());
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        long start = (Long)request.getAttribute(START_TIME);
        long end = System.currentTimeMillis();
        long executeTime = end - start;
        logger.info("Controller\u6267\u884c - {} - \u6267\u884c\u65f6\u95f4:{}ms", (Object)request.getRequestURI(), (Object)executeTime);
    }
}

