/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class KeyWordUtil {
    private Map<String, Object> dictionaryMap;

    public KeyWordUtil(Set<String> wordSet) {
        this.dictionaryMap = this.handleToMap(wordSet);
    }

    public Map<String, Object> getDictionaryMap() {
        return this.dictionaryMap;
    }

    public void setDictionaryMap(Map<String, Object> dictionaryMap) {
        this.dictionaryMap = dictionaryMap;
    }

    private Map<String, Object> handleToMap(Set<String> wordSet) {
        if (wordSet == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(wordSet.size());
        HashMap<String, Object> curMap = null;
        for (String word : wordSet) {
            curMap = map;
            int len = word.length();
            for (int i = 0; i < len; ++i) {
                String key = String.valueOf(word.charAt(i));
                HashMap<String, String> wordMap = (HashMap<String, String>)curMap.get(key);
                if (wordMap == null) {
                    wordMap = new HashMap<String, String>();
                    wordMap.put("isEnd", "0");
                    curMap.put(key, wordMap);
                    curMap = wordMap;
                } else {
                    curMap = wordMap;
                }
                if (i != len - 1) continue;
                curMap.put("isEnd", "1");
            }
        }
        return map;
    }

    public int checkWord(String text, int beginIndex) {
        String key;
        if (this.dictionaryMap == null) {
            throw new RuntimeException("\u5b57\u5178\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        boolean isEnd = false;
        int wordLength = 0;
        Map curMap = this.dictionaryMap;
        int len = text.length();
        for (int i = beginIndex; i < len && (curMap = (Map)curMap.get(key = String.valueOf(text.charAt(i)))) != null; ++i) {
            ++wordLength;
            if (!"1".equals(curMap.get("isEnd"))) continue;
            isEnd = true;
        }
        if (!isEnd) {
            wordLength = 0;
        }
        return wordLength;
    }

    public Set<String> getWords(String text) {
        HashSet<String> wordSet = new HashSet<String>();
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            int wordLength = this.checkWord(text, i);
            if (wordLength <= 0) continue;
            String word = text.substring(i, i + wordLength);
            wordSet.add(word);
            i = i + wordLength - 1;
        }
        return wordSet;
    }

    public static String getInState(String inState) {
        HashSet<String> wordSet = new HashSet<String>();
        wordSet.add("\u5728\u9662");
        KeyWordUtil keyWordUtil = new KeyWordUtil(wordSet);
        Set words = keyWordUtil.getWords(inState);
        if (words.size() > 0) {
            return "A";
        }
        return "D";
    }
}

