/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.config.ProPropertiesConstant;
import com.ebaiyihui.his.pojo.vo.BdPayReqVo;
import com.ebaiyihui.his.pojo.vo.BdRefundReqVo;
import com.ebaiyihui.his.pojo.vo.HisPayRes;
import com.ebaiyihui.his.pojo.vo.OrderBarcodeReq;
import com.ebaiyihui.his.pojo.vo.PaymentChannelReq;
import com.ebaiyihui.his.pojo.vo.PolymerizationReq;
import com.ebaiyihui.his.pojo.vo.PolymerizationRes;
import com.ebaiyihui.his.pojo.vo.RefundReq;
import com.ebaiyihui.his.service.BdPayService;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.utils.EncryptUtils;
import com.ebaiyihui.his.utils.IgnoreSSLHttpKit;
import com.ebaiyihui.his.utils.SnowflakeIdWorker;
import com.ebaiyihui.his.utils.XmlUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BdPayServiceImpl
implements BdPayService {
    private static final Logger log = LoggerFactory.getLogger(BdPayServiceImpl.class);
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private EncryptUtils encryptUtils;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private HisRemoteService hisRemoteService;

    public BaseResponse pay(BdPayReqVo bdPayReqVo) {
        log.info("\u652f\u4ed8\u8bf7\u6c42\u53c2\u6570:" + JSON.toJSONString((Object)bdPayReqVo));
        HashMap<String, PolymerizationReq> map = new HashMap<String, PolymerizationReq>();
        PolymerizationReq polymerizationReq = new PolymerizationReq();
        polymerizationReq.setBody(bdPayReqVo.getBody());
        polymerizationReq.setCardNo(bdPayReqVo.getCardNo());
        polymerizationReq.setMachineNo("wechat");
        polymerizationReq.setMethod("8");
        polymerizationReq.setType(bdPayReqVo.getType());
        polymerizationReq.setShowUrl("showUrl");
        polymerizationReq.setSubAppid(this.propertiesConstant.getSubAppid());
        BigDecimal totalFee = new BigDecimal(bdPayReqVo.getTotalFee()).setScale(2);
        polymerizationReq.setTotalFee(totalFee.multiply(new BigDecimal("100")).stripTrailingZeros().toPlainString());
        polymerizationReq.setSubject(bdPayReqVo.getSubject());
        polymerizationReq.setReturnUrl("ReturnUrl");
        polymerizationReq.setOpenid(bdPayReqVo.getOpenid());
        polymerizationReq.setPatientName(bdPayReqVo.getPatientName());
        map.put("polymerizationReq", polymerizationReq);
        PolymerizationRes encrypt = (PolymerizationRes)this.encryptUtils.encrypt("0001", map, this.propertiesConstant.getPolymerization(), PolymerizationRes.class);
        log.info("\u652f\u4ed8\u8bf7\u6c42\u7ed3\u679c:{}", (Object)encrypt);
        if (Objects.nonNull(encrypt)) {
            if (Objects.equals(encrypt.getResultCode(), "0")) {
                return BaseResponse.success((Object)encrypt);
            }
            return BaseResponse.error((String)("\u652f\u4ed8\u5931\u8d25:" + encrypt.getResultMsg()));
        }
        return BaseResponse.error((String)"\u8bf7\u6c42\u652f\u4ed8\u5931\u8d25");
    }

    public BaseResponse queryPay(OrderBarcodeReq orderBarcodeReq) {
        HashMap<String, OrderBarcodeReq> map = new HashMap<String, OrderBarcodeReq>();
        map.put("orderBarcodeReq", orderBarcodeReq);
        log.info("\u67e5\u8be2\u652f\u4ed8\u7ed3\u679c\u7ed3\u679c\u53c2\u6570:" + JSON.toJSONString(map));
        HisPayRes hisPayRes = (HisPayRes)this.encryptUtils.queryPolymer("0002", map, this.propertiesConstant.getOrderBarcode(), HisPayRes.class);
        log.info("\u67e5\u8be2\u652f\u4ed8\u7ed3\u679c\u7ed3\u679c:{}", (Object)hisPayRes);
        if (!Objects.isNull(hisPayRes)) {
            if (Objects.equals(hisPayRes.getResultCode(), "0")) {
                return BaseResponse.success((Object)"\u5145\u503c\u6210\u529f");
            }
            return BaseResponse.error((String)hisPayRes.getResultMsg());
        }
        return BaseResponse.error((String)"\u8bf7\u6c42\u652f\u4ed8\u7ed3\u679c\u67e5\u8be2\u5931\u8d25");
    }

    public BaseResponse refund(BdRefundReqVo bdRefundReqVo) {
        RefundReq refundReq = new RefundReq();
        refundReq.setMachineNo("wechat");
        refundReq.setTrace(String.valueOf(this.snowflakeIdWorker.nextId()));
        refundReq.setCardNo(bdRefundReqVo.getCardNo());
        refundReq.setOutTradeNo(bdRefundReqVo.getOutTradeNo());
        BigDecimal totalFee = new BigDecimal(bdRefundReqVo.getTotalFee()).setScale(2);
        refundReq.setTotalFee(String.valueOf(totalFee.multiply(new BigDecimal("100")).stripTrailingZeros().toPlainString()));
        log.info("\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)refundReq));
        HashMap<String, RefundReq> map = new HashMap<String, RefundReq>();
        map.put("refundReq", refundReq);
        HisPayRes hisPayRes = (HisPayRes)this.encryptUtils.encrypt("0003", map, this.propertiesConstant.getRefund(), HisPayRes.class);
        log.info("\u9000\u6b3e\u8fd4\u56de\u53c2\u6570\u4e3ahisPayRes:{}", (Object)JSON.toJSONString((Object)hisPayRes));
        if (Objects.nonNull(hisPayRes)) {
            if (Objects.equals(hisPayRes.getResultCode(), "0")) {
                return BaseResponse.success((Object)hisPayRes);
            }
            return BaseResponse.error((String)("\u8bf7\u6c42\u9000\u6b3e\u5f02\u5e38:{}" + hisPayRes.getResultMsg()));
        }
        return BaseResponse.error((String)"\u8bf7\u6c42\u9000\u6b3e\u5f02\u5e38/\u5931\u8d25");
    }

    public BaseResponse getBankOrder(String dateTime) throws NoSuchAlgorithmException, IOException, NoSuchProviderException, ExecutionException, InterruptedException, KeyManagementException {
        log.info("getBankOrder\u5165\u53c2-> {}", (Object)JSON.toJSONString((Object)dateTime));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("xml", "<Request><Row><Date>" + dateTime + "</Date></Row></Request>");
        String s = IgnoreSSLHttpKit.get((String)"http://192.26.200.71:8005/download/billDetail", map);
        PaymentChannelReq paymentChannelReq = (PaymentChannelReq)XmlUtil.convertToJavaBean((String)s, PaymentChannelReq.class);
        log.info("\u94f6\u884c\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f{}", (Object)paymentChannelReq);
        return BaseResponse.success((Object)paymentChannelReq);
    }

    public static void main(String[] args) throws NoSuchAlgorithmException, IOException, NoSuchProviderException, ExecutionException, InterruptedException, KeyManagementException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("xml", "<Request><Row><Date>2022-07-14</Date></Row></Request>");
        String s = IgnoreSSLHttpKit.get((String)"https://hospitaltest.chengdebank.com/bds_dyzyy/download/billDetail", map);
        PaymentChannelReq paymentChannelReq = (PaymentChannelReq)XmlUtil.convertToJavaBean((String)s, PaymentChannelReq.class);
        System.out.println(paymentChannelReq);
    }
}

