/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.api;

import com.ebaiyihui.common.pojo.AccountEntity;
import com.ebaiyihui.common.pojo.AccountEntityVo;
import com.ebaiyihui.common.vo.QueryAccountByPhoneReqVo;
import com.ebaiyihui.common.vo.ResetPassWordReqVo;
import com.ebaiyihui.common.vo.SetPassswordVo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.server.service.AccountService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/account"})
public class AccountController {
    @Autowired
    private AccountService accountService;

    @RequestMapping(value={"/insert"}, method={RequestMethod.POST})
    public BaseResponse insert(@RequestBody List<AccountEntityVo> accountEntities) {
        this.accountService.inert(accountEntities);
        return BaseResponse.success();
    }

    @RequestMapping(value={"/resetPassword"}, method={RequestMethod.POST})
    public BaseResponse resetPassword(@RequestBody ResetPassWordReqVo resetPassWordReqVo) {
        this.accountService.resetPassword(resetPassWordReqVo);
        return BaseResponse.success();
    }

    @RequestMapping(value={"/setPasswoed"}, method={RequestMethod.POST})
    public BaseResponse setPasswoed(@RequestBody SetPassswordVo setPassswordVo) {
        this.accountService.setPassword(setPassswordVo);
        return BaseResponse.success();
    }

    @RequestMapping(value={"/remove"}, method={RequestMethod.GET})
    public BaseResponse remove(@RequestParam(value="accountId") String accountId, @RequestHeader(value="token") String token) {
        this.accountService.remove(accountId, token);
        return BaseResponse.success();
    }

    @RequestMapping(value={"/queryAccountByPhone"}, method={RequestMethod.POST})
    public BaseResponse queryAccountByPhone(@RequestBody QueryAccountByPhoneReqVo queryAccountByPhoneReqVo) {
        AccountEntity accountEntity = this.accountService.getByPhone(queryAccountByPhoneReqVo.getMobilePhone(), queryAccountByPhoneReqVo.getUserType(), queryAccountByPhoneReqVo.getAppCode());
        return BaseResponse.success((Object)accountEntity.getAccountId());
    }

    @RequestMapping(value={"findWxUserUnique"}, method={RequestMethod.GET})
    public BaseResponse findWxUserUnique(@RequestParam(value="accountId") String accountId) {
        AccountEntity accountEntity = this.accountService.findByAccountId(accountId);
        return BaseResponse.success((Object)accountEntity.getWxUserUnique());
    }

    @RequestMapping(value={"v1/queryAccountByPhone"}, method={RequestMethod.POST})
    public BaseResponse<AccountEntity> queryAccount(@RequestBody QueryAccountByPhoneReqVo queryAccountByPhoneReqVo) {
        AccountEntity accountEntity = this.accountService.getByPhone(queryAccountByPhoneReqVo.getMobilePhone(), queryAccountByPhoneReqVo.getUserType(), queryAccountByPhoneReqVo.getAppCode());
        return BaseResponse.success((Object)accountEntity);
    }
}

