/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.loginbusiness;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.common.pojo.AccountEntity;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.server.conmon.ProjProperties;
import com.ebaiyihui.server.conmon.enums.ErrorEnum;
import com.ebaiyihui.server.conmon.enums.PushCenterEnums;
import com.ebaiyihui.server.service.AccountService;
import com.ebaiyihui.server.shiro.realm.UserToken;
import com.ebaiyihui.server.token.TokenJson;
import com.ebaiyihui.server.token.TokenUtil;
import com.ebaiyihui.server.util.RandomUtil;
import com.ebaiyihui.server.util.RedisUtil;
import com.ebaiyihui.server.util.VerifyCodeUtil;
import com.ebaiyihui.server.vo.AliSmsSendAuthCodeReqPhone;
import com.ebaiyihui.server.vo.LoginRequestVo;
import com.ebaiyihui.server.vo.SmsConfig;
import com.ebaiyihui.server.vo.SmsSendAuthCodeReqVO;
import com.ebaiyihui.server.vo.SmsSendAuthCodeRspVO;
import com.ebaiyihui.server.vo.VercodeRespVo;
import exception.UserCenterRuntimeException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import sun.misc.BASE64Encoder;

@Component
public class LoginProcess {
    private static final Logger log = LoggerFactory.getLogger(LoginProcess.class);
    @Autowired
    protected RedisUtil redisUtil;
    @Autowired
    ProjProperties projProperties;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    AccountService accountService;

    public BaseResponse shiroLogin(UserToken token) throws Exception {
        Subject subject = SecurityUtils.getSubject();
        subject.login((AuthenticationToken)token);
        String printcipal = subject.getPrincipal().toString();
        if (subject.isAuthenticated()) {
            TokenJson tokenJson = new TokenJson();
            LoginRequestVo loginRequestVo = token.getLoginRequestVo();
            BeanUtils.copyProperties((Object)loginRequestVo, (Object)tokenJson);
            AccountEntity user = this.accountService.getByPhone(printcipal, loginRequestVo.getUserType(), loginRequestVo.getAppCode());
            tokenJson.setAccountId(user.getAccountId());
            tokenJson.setAccountNo(user.getMobilePhone());
            tokenJson.setDeviceNumber(loginRequestVo.getLoginType());
            JSONObject json = new JSONObject();
            String accessToken = null;
            if (loginRequestVo.getLoginType().equals("2")) {
                Long time = 30L;
                accessToken = TokenUtil.gen((TokenJson)tokenJson, (String)this.projProperties.getAuthTokenAppSecret(), (Long)time, (TimeUnit)TimeUnit.DAYS);
                this.redisUtil.set(user.getAccountId() + loginRequestVo.getLoginType(), (Object)accessToken, time.longValue(), TimeUnit.DAYS);
            } else {
                Long time = 8L;
                accessToken = TokenUtil.gen((TokenJson)tokenJson, (String)this.projProperties.getAuthTokenAppSecret(), (Long)time, (TimeUnit)TimeUnit.HOURS);
                this.redisUtil.set(user.getAccountId() + loginRequestVo.getLoginType(), (Object)accessToken, time.longValue(), TimeUnit.HOURS);
            }
            if (!user.getStatus().equals(0)) {
                String refreshToken = TokenUtil.gen((TokenJson)tokenJson, (String)this.projProperties.getRefreshTokenAppSecret(), (Long)30L, (TimeUnit)TimeUnit.DAYS);
                json.put("refreshToken", (Object)refreshToken);
                json.put("isActive", (Object)1);
            } else {
                json.put("refreshToken", (Object)"");
                json.put("isActive", (Object)0);
            }
            json.put("accountId", (Object)user.getAccountId());
            json.put("loginName", (Object)user.getLoginName());
            json.put("accessToken", (Object)accessToken);
            json.put("mobilePhone", (Object)user.getMobilePhone());
            return BaseResponse.success((Object)json);
        }
        return BaseResponse.error((IError)ErrorEnum.SYSTEM_ERROR);
    }

    public BaseResponse<VercodeRespVo> getVerCode(int width, int height) {
        if (width == 0 || height == 0) {
            width = 100;
            height = 40;
        }
        VerifyCodeUtil vc = new VerifyCodeUtil();
        if (height != 0 && width != 0) {
            vc.setHeight(height);
            vc.setWidth(width);
        }
        BufferedImage image = vc.getImage();
        String text = vc.getText();
        String random = RandomUtil.getRandom();
        this.redisUtil.set("vercode_" + random, (Object)text, 600L);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", baos);
        }
        catch (IOException e) {
            log.info("\u83b7\u53d6\u56fe\u6587\u9a8c\u8bc1\u7801 \u5f02\u5e38", (Object)e.getMessage());
            e.printStackTrace();
        }
        byte[] bytes = baos.toByteArray();
        BASE64Encoder encoder = new BASE64Encoder();
        String png_base64 = encoder.encodeBuffer(bytes).trim();
        png_base64 = png_base64.replaceAll("\n", "").replaceAll("\r", "");
        VercodeRespVo vercodeRespVo = new VercodeRespVo();
        vercodeRespVo.setVercodeKey("vercode_" + random);
        vercodeRespVo.setPng_base64("data:image/jpeg;base64," + png_base64);
        log.info("\u83b7\u53d6\u56fe\u6587\u9a8c\u8bc1\u7801 \u9a8c\u8bc1\u7801:" + text);
        return BaseResponse.success((Object)vercodeRespVo);
    }

    public boolean verifyVercode(String vercodeKey, String vercodeValue) {
        Object vercode = "";
        if (!StringUtils.isEmpty((Object)vercodeKey) && !StringUtils.isEmpty((Object)vercodeValue) && (vercode = this.redisUtil.get(vercodeKey)) != null && vercodeValue.equalsIgnoreCase((String)vercode)) {
            log.info("\u56fe\u6587\u9a8c\u8bc1\u901a\u8fc7  \u5165\u53c2\uff1a{},\u5b9e\u9645\u9a8c\u8bc1\u7801\uff1a{}", (Object)vercodeValue, vercode);
            this.redisUtil.del(new String[]{vercodeKey});
            return true;
        }
        log.info("\u56fe\u6587\u9a8c\u8bc1\u4e0d\u6b63\u786e\u5165\u53c2\uff1a{},\u5b9e\u9645\u9a8c\u8bc1\u7801\uff1a{}", (Object)vercodeValue, vercode);
        this.redisUtil.del(new String[]{vercodeKey});
        return false;
    }

    public BaseResponse getSms(SmsSendAuthCodeReqVO smsSendAuthCodeReqVO) {
        BaseResponse body;
        AliSmsSendAuthCodeReqPhone params = new AliSmsSendAuthCodeReqPhone();
        BeanUtils.copyProperties((Object)smsSendAuthCodeReqVO, (Object)params);
        params.setAppSdkType("ali");
        params.setPhone(smsSendAuthCodeReqVO.getPhone());
        params.setTemplateCode(smsSendAuthCodeReqVO.getTemplateCode());
        SmsConfig smsConfig = this.getSmsConfig(smsSendAuthCodeReqVO.getAppCode(), PushCenterEnums.PushTypeEnum.SMS.getValue());
        if (smsConfig.getPatientSignCode() == null || smsConfig.getClientCode() == null) {
            log.info("\u8c03\u7528\u533b\u751f\u670d\u52a1 - \u67e5\u8be2\u63a8\u9001\u914d\u7f6e\u4fe1\u606f \u914d\u7f6e\u4e3a\u7a7asmsConfig:{}", (Object)smsConfig);
            return BaseResponse.error((IError)ErrorEnum.PUSH_CONFIG_NULL);
        }
        params.setSignCode(smsConfig.getPatientSignCode());
        params.setSmsAppCode(smsConfig.getClientCode());
        String baseUrl = this.projProperties.getEbaiyihuiDomain().concat("/cloud/push/alismsapi/sendAuthCodeWithPhoneV2");
        log.info("\u8c03\u7528\u63a8\u9001\u63a5\u53e3URL:{},\u5165\u53c2:{}", (Object)baseUrl, (Object)JSON.toJSONString((Object)params));
        HttpHeaders headers = new HttpHeaders();
        headers.set("accept-language", "zh-CN,zh;q=0.9,en;q=0.8");
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(baseUrl, HttpMethod.POST, httpEntity, BaseResponse.class, new Object[0]);
        log.error("\u6821\u9a8c\u77ed\u4fe1\u9a8c\u8bc1\u7801--\u54cd\u5e94:" + JSON.toJSONString((Object)responseEntity));
        if (HttpStatus.OK.equals((Object)responseEntity.getStatusCode()) && responseEntity.getBody() != null && (body = (BaseResponse)responseEntity.getBody()).isSuccess()) {
            SmsSendAuthCodeRspVO rspVO = (SmsSendAuthCodeRspVO)JSONObject.parseObject((String)JSON.toJSONString((Object)body.getData()), SmsSendAuthCodeRspVO.class);
            return BaseResponse.success((Object)rspVO);
        }
        return BaseResponse.error((IError)ErrorEnum.OTHER_SERVICE_ERROR_DEFAULT_CODE, (String)(responseEntity.getBody() == null ? "\u77ed\u4fe1\u53d1\u9001\u5931\u8d25" : ((BaseResponse)responseEntity.getBody()).getMsg()));
    }

    private SmsConfig getSmsConfig(String appCode, String type) {
        String cacheKey = "PUSH".concat(appCode).concat("_").concat(type);
        try {
            SmsConfig smsConfig;
            Object sms = this.redisUtil.get(cacheKey);
            if (sms != null && (smsConfig = (SmsConfig)JSONObject.parseObject((String)((String)sms), SmsConfig.class)).getClientCode() != null && smsConfig.getPatientSignCode() != null) {
                return smsConfig;
            }
        }
        catch (Exception e) {
            log.info("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6sms\u914d\u7f6e\u4fe1\u606f \u5f02\u5e38{}", (Object)e.getMessage());
        }
        SmsConfig smsConfig = new SmsConfig();
        smsConfig.setAppCode(appCode);
        smsConfig.setType(type);
        String url = this.projProperties.getEbaiyihuiDomain().concat("/cloud/doctoruser/configuration/getdetail");
        log.info("\u8c03\u7528\u533b\u751f\u63a5\u53e3URL:{},\u5165\u53c2:{}", (Object)url, (Object)smsConfig);
        BaseResponse baseResponse = (BaseResponse)this.restTemplate.postForObject(url, (Object)smsConfig, BaseResponse.class, new Object[0]);
        if (baseResponse == null) {
            log.error("\u8c03\u7528\u533b\u751f\u670d\u52a1 - \u67e5\u8be2\u63a8\u9001\u914d\u7f6e\u4fe1\u606f - \u8fd4\u56denull");
            throw new UserCenterRuntimeException(ErrorEnum.DOCTOR_SYSTEM_RETURN_NULL);
        }
        String toJSONString = JSON.toJSONString((Object)baseResponse);
        JSONObject jsonObject1 = JSONObject.parseObject((String)toJSONString);
        log.info("\u8c03\u7528\u533b\u751f\u670d\u52a1 - \u67e5\u8be2\u63a8\u9001\u914d\u7f6e\u4fe1\u606f \u8fd4\u56de " + toJSONString);
        if ("1".equalsIgnoreCase(jsonObject1.getString("code"))) {
            String data = jsonObject1.getString("data");
            JSONObject jsonDate = JSONObject.parseObject((String)data);
            if (null == jsonDate) {
                throw new UserCenterRuntimeException(ErrorEnum.INVALID_PUSH_PARAMETER);
            }
            String clientCodeStr = jsonDate.getString("clientCode");
            String statusStr = jsonDate.getString("status");
            if (statusStr != null) {
                smsConfig.setStatus(Integer.valueOf(statusStr).intValue());
            }
            if (clientCodeStr != null) {
                log.info("==========clientCodeStr========" + clientCodeStr);
                JSONObject clientCodeJson = JSONObject.parseObject((String)clientCodeStr);
                if (PushCenterEnums.PushTypeEnum.SMS.getValue().equalsIgnoreCase(type) && clientCodeJson != null) {
                    String clientCode1 = clientCodeJson.getString("clientCode");
                    smsConfig.setClientCode(clientCode1);
                    String signCode = clientCodeJson.getString("signCode");
                    JSONObject signCodeJson = JSONObject.parseObject((String)signCode);
                    if (signCodeJson != null) {
                        smsConfig.setDoctorSignCode(signCodeJson.getString("doctorCode"));
                        smsConfig.setPatientSignCode(signCodeJson.getString("patientCode"));
                        this.redisUtil.set(cacheKey, (Object)JSON.toJSONString((Object)smsConfig), 1440L, TimeUnit.MINUTES);
                    }
                }
            }
        }
        return smsConfig;
    }
}

